/*
 * Decompiled with CFR 0.152.
 */
package lib;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.Method;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueChanger;
import util.ValueComparer;
import util.utils;

public class MultiPropertyTest
extends MultiMethodTest {
    public XPropertySet oObj;
    protected boolean optionalService = false;

    protected void before() {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.oObj);
        this.optionalService = this.entry.isOptional;
        String string = this.getTestedClassName();
        if (xServiceInfo != null && !xServiceInfo.supportsService(string)) {
            this.log.println("Service " + string + " not available");
            if (this.optionalService) {
                this.log.println("This is OK since it is optional");
            } else {
                Status.failed(string + " is not supported");
            }
        }
    }

    protected void invokeTestMethod(Method method, String string) {
        if (method != null) {
            super.invokeTestMethod(method, string);
        } else {
            this.testProperty(string);
        }
    }

    protected void testProperty(String string, PropertyTester propertyTester) {
        propertyTester.testProperty(string);
    }

    protected void testProperty(String string) {
        this.testProperty(string, new PropertyTester());
    }

    protected void testProperty(String string, Object object, Object object2) {
        this.testProperty(string, new PropertyValueSwitcher(object, object2));
    }

    private boolean callCompare(Object object, Object object2) {
        return this.compare(object, object2);
    }

    protected boolean compare(Object object, Object object2) {
        return ValueComparer.equalValue(object, object2);
    }

    private String callToString(Object object) {
        return this.toString(object);
    }

    protected String toString(Object object) {
        return object == null ? "null" : object.toString();
    }

    public class PropertyValueSwitcher
    extends PropertyTester {
        Object val1;
        Object val2;

        public PropertyValueSwitcher(Object object, Object object2) {
            this.val1 = null;
            this.val2 = null;
            this.val1 = object;
            this.val2 = object2;
        }

        protected Object getNewValue(String string, Object object) {
            if (ValueComparer.equalValue(this.val1, object)) {
                return this.val2;
            }
            return this.val1;
        }
    }

    public class PropertyTester {
        protected void testProperty(String string) {
            XPropertySetInfo xPropertySetInfo = MultiPropertyTest.this.oObj.getPropertySetInfo();
            if (!xPropertySetInfo.hasPropertyByName(string)) {
                if (MultiPropertyTest.this.isOptional(string) || MultiPropertyTest.this.optionalService) {
                    MultiPropertyTest.this.log.println("Property '" + string + "' is optional and not supported");
                    MultiPropertyTest.this.tRes.tested(string, true);
                    return;
                }
                MultiPropertyTest.this.log.println("Tested XPropertySet does not contain'" + string + "' property");
                MultiPropertyTest.this.tRes.tested(string, false);
                return;
            }
            try {
                Object object;
                Object object2 = MultiPropertyTest.this.oObj.getPropertyValue(string);
                try {
                    object = this.getNewValue(string, object2);
                }
                catch (java.lang.IllegalArgumentException illegalArgumentException) {
                    Status.failed("Cannot create new value for '" + string + " : " + illegalArgumentException.getMessage());
                    return;
                }
                Exception exception = null;
                try {
                    MultiPropertyTest.this.log.println("try to set:");
                    MultiPropertyTest.this.log.println("old = " + this.toString(object2));
                    MultiPropertyTest.this.log.println("new = " + this.toString(object));
                    MultiPropertyTest.this.oObj.setPropertyValue(string, object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    exception = illegalArgumentException;
                }
                catch (PropertyVetoException propertyVetoException) {
                    exception = propertyVetoException;
                }
                catch (WrappedTargetException wrappedTargetException) {
                    exception = wrappedTargetException;
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    exception = unknownPropertyException;
                }
                catch (RuntimeException runtimeException) {
                    exception = runtimeException;
                }
                Object object3 = MultiPropertyTest.this.oObj.getPropertyValue(string);
                this.checkResult(string, object2, object, object3, exception);
            }
            catch (Exception exception) {
                MultiPropertyTest.this.log.println("Exception occured while testing property '" + string + "'");
                exception.printStackTrace(MultiPropertyTest.this.log);
                MultiPropertyTest.this.tRes.tested(string, false);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void checkResult(String string, Object object, Object object2, Object object3, Exception exception) throws Exception {
            boolean bl;
            XPropertySetInfo xPropertySetInfo = MultiPropertyTest.this.oObj.getPropertySetInfo();
            Property property = xPropertySetInfo.getPropertyByName(string);
            short s = property.Attributes;
            boolean bl2 = (property.Attributes & 0x10) != 0;
            boolean bl3 = bl = (property.Attributes & 1) != 0;
            if (bl) {
                MultiPropertyTest.this.log.println("Property " + string + " is void");
            }
            if (bl2) {
                MultiPropertyTest.this.log.println("Property " + string + " is readOnly");
            }
            if (utils.isVoid(object) && !bl) {
                MultiPropertyTest.this.log.println(string + " is void, but it's not MAYBEVOID");
                MultiPropertyTest.this.tRes.tested(string, false);
                return;
            }
            if (object == null) {
                MultiPropertyTest.this.log.println(string + " has null value, and therefore can't be changed");
                MultiPropertyTest.this.tRes.tested(string, true);
                return;
            }
            if (bl2) {
                if (exception != null) {
                    if (exception instanceof PropertyVetoException) {
                        MultiPropertyTest.this.log.println("Property is ReadOnly and wasn't changed");
                        MultiPropertyTest.this.log.println("Property '" + string + "' OK");
                        MultiPropertyTest.this.tRes.tested(string, true);
                        return;
                    } else if (exception instanceof IllegalArgumentException) {
                        MultiPropertyTest.this.log.println("Property is ReadOnly and wasn't changed");
                        MultiPropertyTest.this.log.println("Property '" + string + "' OK");
                        MultiPropertyTest.this.tRes.tested(string, true);
                        return;
                    } else if (exception instanceof UnknownPropertyException) {
                        MultiPropertyTest.this.log.println("Property is ReadOnly and wasn't changed");
                        MultiPropertyTest.this.log.println("Property '" + string + "' OK");
                        MultiPropertyTest.this.tRes.tested(string, true);
                        return;
                    } else {
                        if (!(exception instanceof RuntimeException)) throw exception;
                        MultiPropertyTest.this.log.println("Property is ReadOnly and wasn't changed");
                        MultiPropertyTest.this.log.println("Property '" + string + "' OK");
                        MultiPropertyTest.this.tRes.tested(string, true);
                    }
                    return;
                }
                if (!this.compare(object3, object)) {
                    MultiPropertyTest.this.log.println("Read only property '" + string + "' has changed");
                    try {
                        if (!utils.isVoid(object) && object instanceof Any) {
                            object = AnyConverter.toObject((Type)new Type(((Any)object).getClass()), (Object)object);
                        }
                        MultiPropertyTest.this.log.println("result = " + this.toString(object3));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        MultiPropertyTest.this.log.println("NOTIFY: this property needs further investigations.");
                        MultiPropertyTest.this.log.println("\t The type seems to be an Any with value of NULL.");
                        MultiPropertyTest.this.log.println("\t Maybe the property should get it's own test method.");
                    }
                    MultiPropertyTest.this.tRes.tested(string, false);
                    return;
                }
                MultiPropertyTest.this.log.println("Read only property '" + string + "' hasn't changed");
                MultiPropertyTest.this.log.println("Property '" + string + "' OK");
                MultiPropertyTest.this.tRes.tested(string, true);
                return;
            }
            if (exception != null) throw exception;
            if (!this.compare(object3, object2) || this.compare(object3, object)) {
                MultiPropertyTest.this.log.println("Value for '" + string + "' hasn't changed as expected");
                try {
                    if (!utils.isVoid(object) && object instanceof Any) {
                        object = AnyConverter.toObject((Type)new Type(((Any)object).getClass()), (Object)object);
                    }
                    MultiPropertyTest.this.log.println("result = " + this.toString(object3));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MultiPropertyTest.this.log.println("NOTIFY: this property needs further investigations.");
                    MultiPropertyTest.this.log.println("\t The type seems to be an Any with value of NULL.");
                    MultiPropertyTest.this.log.println("\t Maybe the property should get it's own test method.");
                }
                if (object3 != null) {
                    if (!this.compare(object3, object) || !object3.equals(object)) {
                        MultiPropertyTest.this.log.println("But it has changed.");
                        MultiPropertyTest.this.tRes.tested(string, true);
                        return;
                    } else {
                        MultiPropertyTest.this.tRes.tested(string, false);
                    }
                    return;
                } else {
                    MultiPropertyTest.this.tRes.tested(string, false);
                }
                return;
            }
            MultiPropertyTest.this.log.println("Property '" + string + "' OK");
            try {
                if (!utils.isVoid(object) && object instanceof Any) {
                    object = AnyConverter.toObject((Type)new Type(((Any)object).getClass()), (Object)object);
                }
                MultiPropertyTest.this.log.println("result = " + this.toString(object3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            MultiPropertyTest.this.tRes.tested(string, true);
        }

        protected Object getNewValue(String string, Object object) throws java.lang.IllegalArgumentException {
            return ValueChanger.changePValue(object);
        }

        protected boolean compare(Object object, Object object2) {
            return MultiPropertyTest.this.callCompare(object, object2);
        }

        protected String toString(Object object) {
            return MultiPropertyTest.this.callToString(object);
        }
    }
}

