/*
 * Decompiled with CFR 0.152.
 */
package helper;

import com.sun.star.uno.RuntimeException;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;

public class URLHelper {
    public static String getFileURLFromSystemPath(File file) {
        String string = null;
        try {
            string = file.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            string = null;
        }
        if (string != null && string.startsWith("file:/") && !string.startsWith("file://")) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(6, "//");
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String getFileURLFromSystemPath(String string) {
        return URLHelper.getFileURLFromSystemPath(new File(string));
    }

    public static String getURLWithProtocolFromSystemPath(File file, File file2, String string) {
        String string2 = URLHelper.getFileURLFromSystemPath(file);
        String string3 = URLHelper.getFileURLFromSystemPath(file2);
        if (string3.lastIndexOf(47) == string3.length() - 1) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (string.lastIndexOf(47) == string.length() - 1) {
            string = string.substring(0, string.length() - 1);
        }
        int n = string2.indexOf(string3);
        String string4 = string2.substring(0, n) + string + string2.substring(n + string3.length());
        return string4;
    }

    public static String getURLWithProtocolFromSystemPath(String string, String string2, String string3) {
        return URLHelper.getURLWithProtocolFromSystemPath(new File(string), new File(string2), string3);
    }

    public static URL parseURL(XURLTransformer xURLTransformer, String string) {
        URL uRL = null;
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            URL[] uRLArray = new URL[]{new URL()};
            uRLArray[0].Complete = string;
            xURLTransformer.parseStrict(uRLArray);
            uRL = uRLArray[0];
        }
        catch (RuntimeException runtimeException) {
            uRL = null;
        }
        return uRL;
    }

    public static Vector getSystemFilesFromDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        Vector<File> vector = new Vector<File>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            Vector vector2;
            if (fileArray[i].isFile()) {
                vector.add(fileArray[i]);
                continue;
            }
            if (!fileArray[i].isDirectory() || (vector2 = URLHelper.getSystemFilesFromDir(fileArray[i].getPath())) == null) continue;
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                vector.add((File)enumeration.nextElement());
            }
        }
        return vector;
    }
}

