/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import convwatch.BuildID;
import convwatch.GlobalLogWriter;
import convwatch.PerformanceContainer;
import convwatch.TriState;
import java.io.File;
import java.io.FileFilter;
import lib.TestParameters;

public class GraphicalTestArguments {
    String m_sReferenceType = "OOo";
    String m_sTargetFrameName = "_blank";
    String m_sPrinterName = null;
    boolean m_bHidden = true;
    String m_sDefaultXMLFormatApplication = null;
    boolean m_bIncludeSubdirectories;
    TestParameters m_aCurrentParams;
    int m_nMaxPages = 0;
    String m_sOnlyPage = "";
    int m_nResolutionInDPI = 0;
    boolean m_bStoreFile = true;
    boolean m_bResuseOffice = false;
    boolean m_bDebugMode = false;
    String m_sLeaveOutNames = null;
    String m_sDistinct = null;
    private String m_sRefBuildID;
    String m_sImportFilterName = "";
    String m_sExportFilterName = "";
    String m_sOfficeProgram = "";
    String m_sHTMLOutputPrefix = "";
    TriState m_tWithBorderMove = TriState.UNSET;
    String m_sDocumentType = "";
    PerformanceContainer m_aPerformanceContainer = null;
    private String m_aInputFile;
    private String m_sDBInfoString;

    private GraphicalTestArguments() {
    }

    public GraphicalTestArguments(TestParameters testParameters) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        this.m_aCurrentParams = testParameters;
        String string9 = (String)testParameters.get("DOC_COMPARATOR_REFERENCE_CREATOR_TYPE");
        if (string9 != null && string9.length() != 0) {
            this.setReferenceType(string9);
        }
        if ((string8 = (String)testParameters.get("DOC_COMPARATOR_PRINTER_NAME")) != null && string8.length() != 0) {
            this.setPrinterName(string8);
        }
        if ((string7 = (String)testParameters.get("DOC_COMPARATOR_DEFAULT_XML_FORMAT_APP")) != null && string7.length() != 0) {
            this.setDefaultXMLFormatApp(string7);
        }
        this.m_bIncludeSubdirectories = true;
        String string10 = (String)testParameters.get("DOC_COMPARATOR_INCLUDE_SUBDIRS");
        if (string10 == null) {
            string10 = "true";
        }
        if (string10.toLowerCase().equals("no") || string10.toLowerCase().equals("false")) {
            this.m_bIncludeSubdirectories = false;
        }
        this.m_nMaxPages = testParameters.getInt("DOC_COMPARATOR_PRINT_MAX_PAGE");
        this.m_sOnlyPage = (String)testParameters.get("DOC_COMPARATOR_PRINT_ONLY_PAGE");
        this.m_nResolutionInDPI = testParameters.getInt("DOC_COMPARATOR_GFX_OUTPUT_DPI_RESOLUTION");
        if (this.m_nResolutionInDPI == 0) {
            this.m_nResolutionInDPI = 212;
        }
        if ((string6 = (String)testParameters.get("DOC_CONVERTER_IMPORT_FILTER_NAME")) != null && string6.length() > 0) {
            this.m_sImportFilterName = string6;
            if (string6.toLowerCase().equals("help")) {
                GraphicalTestArguments.showInternalFilterName(string6, this.getMultiServiceFactory());
                GlobalLogWriter.get().println("Must quit.");
            }
        }
        if ((string5 = (String)testParameters.get("DOC_CONVERTER_EXPORT_FILTER_NAME")) != null && string5.length() > 0) {
            this.m_sExportFilterName = string5;
            if (string5.toLowerCase().equals("help")) {
                GraphicalTestArguments.showInternalFilterName(string5, this.getMultiServiceFactory());
                GlobalLogWriter.get().println("Must quit.");
            }
        }
        if ((string4 = (String)testParameters.get("DOC_CONVERTER_OFFICE_PROGRAM")) != null && string4.length() > 0) {
            this.m_sOfficeProgram = string4;
        }
        if ((string3 = (String)testParameters.get("DOC_CONVERTER_REUSE_OFFICE")) == null) {
            string3 = "false";
        }
        this.m_bResuseOffice = string3.toLowerCase().equals("yes") || string3.toLowerCase().equals("true");
        String string11 = (String)testParameters.get("DOC_COMPARATOR_HTML_OUTPUT_PREFIX");
        this.m_sHTMLOutputPrefix = string11 == null ? "" : string11;
        String string12 = (String)testParameters.get("DOC_COMPARATOR_GFXCMP_WITH_BORDERMOVE");
        if (string12 == null) {
            string12 = "";
            this.m_tWithBorderMove = TriState.FALSE;
        }
        this.m_tWithBorderMove = string12.toLowerCase().equals("yes") || string12.toLowerCase().equals("true") ? TriState.TRUE : (string12.toLowerCase().equals("no") || string12.toLowerCase().equals("false") ? TriState.FALSE : TriState.FALSE);
        String string13 = (String)testParameters.get("DOC_COMPARATOR_LEAVE_OUT_FILES");
        if (string13 != null) {
            this.m_sLeaveOutNames = string13;
        }
        if ((string2 = (String)testParameters.get("DOC_COMPARATOR_DB_INFO_STRING")) != null) {
            this.m_sDBInfoString = string2;
        }
        if ((string = (String)testParameters.get("DISTINCT")) == null || string.length() == 0) {
            string = "";
        } else {
            this.m_sDistinct = string;
        }
    }

    public boolean checkIfUsableDocumentType(String string) {
        return !string.toLowerCase().endsWith(".jpg") && !string.toLowerCase().endsWith(".png") && !string.toLowerCase().endsWith(".gif") && !string.toLowerCase().endsWith(".bmp") && !string.toLowerCase().endsWith(".prn") && !string.toLowerCase().endsWith(".ps");
    }

    static void showInternalFilterName(String string, XMultiServiceFactory xMultiServiceFactory) {
        XNameAccess xNameAccess;
        if (string.length() == 0) {
            return;
        }
        if (xMultiServiceFactory == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return;
        }
        Object object = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.document.FilterFactory");
        }
        catch (Exception exception) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.FilterFactory.");
            return;
        }
        if (object != null && (xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, object)) != null && string.toLowerCase().equals("help")) {
            GlobalLogWriter.get().println("Show all possible ElementNames from current version.");
            String[] stringArray = xNameAccess.getElementNames();
            for (int i = 0; i < stringArray.length; ++i) {
                GlobalLogWriter.get().println(stringArray[i]);
            }
        }
    }

    public void setReferenceType(String string) {
        this.m_sReferenceType = string == null ? "OOo" : string;
    }

    public void setTargetFrameName(String string) {
        this.m_sTargetFrameName = string;
    }

    public void setPrinterName(String string) {
        this.m_sPrinterName = string;
    }

    public void setHidden() {
        this.m_bHidden = true;
    }

    public void setViewable() {
        this.m_bHidden = false;
    }

    public void setDefaultXMLFormatApp(String string) {
        this.m_sDefaultXMLFormatApplication = string;
    }

    public XMultiServiceFactory getMultiServiceFactory() {
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)this.m_aCurrentParams.getMSF();
        if ((this.getReferenceType().toLowerCase().equals("pdf") || this.getReferenceType().toLowerCase().equals("ooo")) && xMultiServiceFactory == null) {
            GlobalLogWriter.get().println("ERROR! MultiServiceFactory not given.");
        }
        return xMultiServiceFactory;
    }

    public String getReferenceType() {
        return this.m_sReferenceType;
    }

    public String getTargetFrameName() {
        return this.m_sTargetFrameName;
    }

    public String getPrinterName() {
        return this.m_sPrinterName;
    }

    public boolean isHidden() {
        return this.m_bHidden;
    }

    public String getDefaultXMLFormatApp() {
        return this.m_sDefaultXMLFormatApplication;
    }

    public FileFilter getFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.getName().startsWith("~$")) {
                    return false;
                }
                if (file.getName().endsWith(".prn")) {
                    return false;
                }
                if (file.getName().endsWith(".zip")) {
                    return false;
                }
                return !file.getName().endsWith("_");
            }
        };
        return fileFilter;
    }

    public boolean includeSubDirectories() {
        return this.m_bIncludeSubdirectories;
    }

    public int getMaxPages() {
        return this.m_nMaxPages;
    }

    public String getOnlyPages() {
        if (this.m_sOnlyPage == null) {
            return "";
        }
        return this.m_sOnlyPage;
    }

    public boolean printAllPages() {
        return this.getMaxPages() <= 0 && this.getOnlyPages().length() == 0;
    }

    public int getResolutionInDPI() {
        return this.m_nResolutionInDPI;
    }

    public static void checkIfMSWindowsConformPath(String string) {
        if (string != null && string.length() > 1 && string.charAt(1) == ':' && string.charAt(2) != '\\') {
            GlobalLogWriter.get().println("This is not a Microsoft Windows conform path: '" + string + "' please fix.");
            System.exit(1);
        }
    }

    public String getInputPath() {
        String string = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_INPUT_PATH");
        GraphicalTestArguments.checkIfMSWindowsConformPath(string);
        return string;
    }

    public String getOutputPath() {
        String string = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_OUTPUT_PATH");
        GraphicalTestArguments.checkIfMSWindowsConformPath(string);
        return string;
    }

    public String getReferencePath() {
        String string = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_REFERENCE_PATH");
        GraphicalTestArguments.checkIfMSWindowsConformPath(string);
        return string;
    }

    public String getDiffPath() {
        String string = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_DIFF_PATH");
        GraphicalTestArguments.checkIfMSWindowsConformPath(string);
        return string;
    }

    public boolean getOverwrite() {
        boolean bl = this.m_aCurrentParams.getBool("DOC_COMPARATOR_OVERWRITE_REFERENCE");
        return bl;
    }

    public String getReferenceInputPath() {
        String string = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_REFERENCE_INPUT_PATH");
        return string;
    }

    public String getBuildID() {
        String string = (String)this.m_aCurrentParams.get("AppExecutionCommand");
        String string2 = BuildID.getBuildID(string);
        return string2;
    }

    public boolean shouldOfficeStart() {
        String string = (String)this.m_aCurrentParams.get("NoOffice");
        return string == null || !string.toLowerCase().startsWith("t") && !string.toLowerCase().startsWith("y");
    }

    public void setRefBuildID(String string) {
        this.m_sRefBuildID = string;
    }

    public String getRefBuildID() {
        return this.m_sRefBuildID;
    }

    public void disallowStore() {
        this.m_bStoreFile = false;
    }

    public void allowStore() {
        this.m_bStoreFile = true;
    }

    public boolean isStoreAllowed() {
        return this.m_bStoreFile;
    }

    public void setImportFilterName(String string) {
        this.m_sImportFilterName = string;
    }

    public String getImportFilterName() {
        return this.m_sImportFilterName;
    }

    public void setExportFilterName(String string) {
        this.m_sExportFilterName = string;
    }

    public String getExportFilterName() {
        return this.m_sExportFilterName;
    }

    public void setOfficeProgram(String string) {
        this.m_sOfficeProgram = string;
    }

    public String getOfficeProgram() {
        return this.m_sOfficeProgram;
    }

    public boolean restartOffice() {
        return !this.m_bResuseOffice;
    }

    public String getHTMLOutputPrefix() {
        return this.m_sHTMLOutputPrefix;
    }

    public TriState getBorderMove() {
        return this.m_tWithBorderMove;
    }

    public void setBorderMove(TriState triState) {
        this.m_tWithBorderMove = triState;
    }

    public void setDocumentType(String string) {
        this.m_sDocumentType = string;
    }

    public String getDocumentType() {
        return this.m_sDocumentType;
    }

    public PerformanceContainer getPerformance() {
        if (this.m_aPerformanceContainer == null) {
            this.m_aPerformanceContainer = new PerformanceContainer();
        }
        return this.m_aPerformanceContainer;
    }

    public void setInputFile(String string) {
        this.m_aInputFile = string;
    }

    public String getInputFile() {
        return this.m_aInputFile;
    }

    public String getDBInfoString() {
        if (this.m_sDBInfoString != null && this.m_sDBInfoString.length() == 0) {
            return null;
        }
        return this.m_sDBInfoString;
    }

    public boolean cancelRequest() {
        File file = null;
        String string = System.getProperty("file.separator");
        String string2 = (String)this.m_aCurrentParams.get("TEMPPATH");
        if (string2 != null) {
            String string3;
            String string4 = string2;
            if (this.m_sDistinct.length() > 0) {
                string4 = string4 + string + this.m_sDistinct;
            }
            if ((file = new File(string3 = string4 + string + "cancel_compare.txt")).exists()) {
                GlobalLogWriter.get().println("ATTENTION: Found file: '" + string3 + "'.");
                GlobalLogWriter.get().println("User has canceled the program flow.");
                return true;
            }
        }
        return false;
    }
}

