/*
 * Decompiled with CFR 0.152.
 */
package basicrunner;

import basicrunner.BasicException;
import basicrunner.BasicIfcTest;
import basicrunner.HandlerContainer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XChangesBatch;
import lib.TestParameters;
import share.LogWriter;
import util.DesktopTools;

public class BasicHandler
implements XServiceInfo,
XSingleServiceFactory {
    static final String serviceName = "com.sun.star.jsuite.basicrunner.BasicHandler";
    private static HandlerContainer container = null;
    private static LogWriter log;
    private static XComponent oHandlerDoc;
    private static XMultiServiceFactory xMSF;
    private static BasicIfcTest TestedInterface;
    private static boolean respFlag;
    private static int iBasicTimeout;

    public BasicHandler(TestParameters testParameters) {
        if (testParameters.get("soapi.test.basic.debugFile") != null) {
            iBasicTimeout = 0;
        }
        container = new HandlerContainer(this);
    }

    public void setTestedInterface(BasicIfcTest basicIfcTest, LogWriter logWriter) {
        log = logWriter;
        TestedInterface = basicIfcTest;
    }

    synchronized void methodTested(String string, boolean bl) {
        respFlag = true;
        TestedInterface.methodTested(string, bl);
        this.notify();
    }

    public synchronized void Log(String string) {
        respFlag = true;
        log.println(string);
        this.notify();
    }

    public boolean isUptodate(XMultiServiceFactory xMultiServiceFactory) {
        return xMultiServiceFactory.equals(xMSF);
    }

    public synchronized void Connect(String string, TestParameters testParameters, XMultiServiceFactory xMultiServiceFactory, LogWriter logWriter) throws ConnectionSetupException {
        log = logWriter;
        try {
            xMSF = xMultiServiceFactory;
            Object object = xMultiServiceFactory.createInstance("com.sun.star.frame.Desktop");
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, object);
            XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xDesktop);
            PropertyValue[] propertyValueArray = new PropertyValue[1];
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.Name = "MacroExecutionMode";
            propertyValue.Value = new Short(4);
            propertyValueArray[0] = propertyValue;
            Object[] objectArray = new PropertyValue[1];
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.Name = "nodepath";
            propertyValue2.Value = "/org.openoffice.Office.Common/Security";
            objectArray[0] = propertyValue2;
            Object object2 = xMultiServiceFactory.createInstance("com.sun.star.configuration.ConfigurationProvider");
            XMultiServiceFactory xMultiServiceFactory2 = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, object2);
            Object object3 = xMultiServiceFactory2.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", objectArray);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, object3);
            Object object4 = xPropertySet.getPropertyValue("Scripting");
            XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, object4);
            xPropertySet2.setPropertyValue("Warning", Boolean.FALSE);
            xPropertySet2.setPropertyValue("OfficeBasic", new Integer(2));
            XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, object3);
            xChangesBatch.commitChanges();
            String string2 = (String)testParameters.get("soapi.test.basic.debugFile");
            if (string2 == null) {
                string2 = "BasicRunner";
            }
            oHandlerDoc = xComponentLoader.loadComponentFromURL(string, string2, 40, propertyValueArray);
            do {
                respFlag = false;
                this.wait(10000L);
            } while (respFlag && !container.hasByName("BASIC_Done"));
            if (!container.hasByName("BASIC_Done")) {
                throw new ConnectionSetupException("Connection timed out.");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
            throw new ConnectionSetupException();
        }
        logWriter.println("Java-BASIC connection established!");
    }

    public synchronized PropertyValue perform(String string, Object object) throws BasicException {
        try {
            container.callBasicFunction(string, object);
            do {
                respFlag = false;
                this.wait(iBasicTimeout);
            } while (respFlag && !container.hasByName("BASIC_Done"));
        }
        catch (InterruptedException interruptedException) {
            System.out.println("The operation " + string + " was interrupted.");
        }
        catch (DisposedException disposedException) {
            System.out.println("## Office is disposed");
        }
        if (!container.hasByName("BASIC_Done")) {
            System.out.println("Operation timed out.");
            throw new BasicException("Operation timed out.");
        }
        Object object2 = container.getByName("BASIC_Done");
        container.removeByName("BASIC_Done");
        if (!(object2 instanceof PropertyValue)) {
            if (object2 == null) {
                System.out.println("BasicBridge returns null");
                throw new BasicException("BasicBridge returns null");
            }
            System.out.println("BasicBridge returns wrong type: " + object2.getClass());
            throw new BasicException("BasicBridge returns wrong type: " + object2.getClass());
        }
        PropertyValue propertyValue = (PropertyValue)object2;
        if (propertyValue.Value instanceof String && ((String)propertyValue.Value).startsWith("Exception")) {
            throw new BasicException((String)propertyValue.Value);
        }
        return propertyValue;
    }

    public boolean supportsService(String string) {
        return serviceName.equals(string);
    }

    public String[] getSupportedServiceNames() {
        return new String[]{serviceName};
    }

    public String getImplementationName() {
        return this.getClass().getName();
    }

    public Object createInstanceWithArguments(Object[] objectArray) {
        return container;
    }

    public Object createInstance() {
        return this.createInstanceWithArguments(null);
    }

    public synchronized void dispose() {
        try {
            if (oHandlerDoc != null) {
                DesktopTools.closeDoc(oHandlerDoc);
                this.wait(1000L);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
        }
    }

    static {
        oHandlerDoc = null;
        xMSF = null;
        TestedInterface = null;
        respFlag = false;
        iBasicTimeout = 10000;
    }
}

