/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.jsc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class Main {
    private static boolean hasOutOption = false;
    private static ToolErrorReporter reporter;

    public static void main(String[] stringArray) {
        Context context = Context.enter();
        reporter = new ToolErrorReporter(true);
        context.setErrorReporter(reporter);
        stringArray = Main.processOptions(context, stringArray);
        if (!reporter.hasReportedError()) {
            Main.processSource(context, stringArray);
        }
        context.exit();
    }

    public static String[] processOptions(Context context, String[] stringArray) {
        ClassNameHelper classNameHelper = ClassNameHelper.get(context);
        classNameHelper.setTargetPackage("");
        context.setGeneratingDebug(false);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            block24: {
                string = stringArray[i];
                if (!string.startsWith("-")) {
                    String[] stringArray2 = new String[stringArray.length - i];
                    for (int j = i; j < stringArray.length; ++j) {
                        stringArray2[j - i] = stringArray[j];
                    }
                    return stringArray2;
                }
                try {
                    if (string.equals("-version") && ++i < stringArray.length) {
                        int n = Integer.parseInt(stringArray[i]);
                        context.setLanguageVersion(n);
                        continue;
                    }
                    if ((string.equals("-opt") || string.equals("-O")) && ++i < stringArray.length) {
                        int n = Integer.parseInt(stringArray[i]);
                        context.setOptimizationLevel(n);
                    }
                    break block24;
                }
                catch (NumberFormatException numberFormatException) {
                    Context.reportError(ToolErrorReporter.getMessage("msg.jsc.usage", stringArray[i]));
                }
                continue;
            }
            if (string.equals("-nosource")) {
                context.setGeneratingSource(false);
                continue;
            }
            if (string.equals("-debug") || string.equals("-g")) {
                context.setGeneratingDebug(true);
                continue;
            }
            if (string.equals("-o") && ++i < stringArray.length) {
                String string2 = stringArray[i];
                if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
                    Context.reportError(ToolErrorReporter.getMessage("msg.invalid.classfile.name", string2));
                    continue;
                }
                for (int j = 1; j < string2.length(); ++j) {
                    if ((Character.isJavaIdentifierPart(string2.charAt(j)) || string2.charAt(j) == '.') && (string2.charAt(j) != '.' || string2.endsWith(".class") && j == string2.length() - 6)) continue;
                    Context.reportError(ToolErrorReporter.getMessage("msg.invalid.classfile.name", string2));
                    break;
                }
                classNameHelper.setTargetClassFileName(string2);
                hasOutOption = true;
                continue;
            }
            if (string.equals("-package") && ++i < stringArray.length) {
                String string3 = stringArray[i];
                for (int j = 0; j < string3.length(); ++j) {
                    if (!Character.isJavaIdentifierStart(string3.charAt(j))) {
                        Context.reportError(ToolErrorReporter.getMessage("msg.package.name", string3));
                        continue;
                    }
                    int n = ++j;
                    while (n < string3.length()) {
                        if (!(string3.charAt(n) == '.' && string3.charAt(n - 1) != '.' && n != string3.length() - 1 || Character.isJavaIdentifierPart(string3.charAt(n)))) {
                            Context.reportError(ToolErrorReporter.getMessage("msg.package.name", string3));
                        }
                        ++n;
                        ++j;
                    }
                }
                classNameHelper.setTargetPackage(string3);
                continue;
            }
            if (string.equals("-extends") && ++i < stringArray.length) {
                String string4 = stringArray[i];
                try {
                    classNameHelper.setTargetExtends(Class.forName(string4));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new Error(classNotFoundException.toString());
                }
            }
            if (string.equals("-implements") && ++i < stringArray.length) {
                Object[] objectArray;
                String string5 = stringArray[i];
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                Vector vector = new Vector();
                while (stringTokenizer.hasMoreTokens()) {
                    objectArray = stringTokenizer.nextToken();
                    try {
                        vector.addElement(Class.forName((String)objectArray));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new Error(classNotFoundException.toString());
                    }
                }
                objectArray = new Class[vector.size()];
                vector.copyInto(objectArray);
                classNameHelper.setTargetImplements((Class[])objectArray);
                continue;
            }
            Main.usage(string);
        }
        Main.p(ToolErrorReporter.getMessage("msg.no.file"));
        System.exit(1);
        return null;
    }

    public static void usage(String string) {
        Main.p(ToolErrorReporter.getMessage("msg.jsc.usage", string));
        System.exit(1);
    }

    public static void processSource(Context context, String[] stringArray) {
        ClassNameHelper classNameHelper = ClassNameHelper.get(context);
        if (hasOutOption && stringArray.length > 1) {
            Context.reportError(ToolErrorReporter.getMessage("msg.multiple.js.to.file", classNameHelper.getTargetClassFileName()));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i];
            File file = new File(string);
            if (!file.exists()) {
                Context.reportError(ToolErrorReporter.getMessage("msg.jsfile.not.found", string));
                return;
            }
            if (!string.endsWith(".js")) {
                Context.reportError(ToolErrorReporter.getMessage("msg.extension.not.js", string));
                return;
            }
            if (!hasOutOption) {
                object = file.getName();
                String string2 = ((String)object).substring(0, ((String)object).length() - 3);
                String string3 = Main.getClassName(string2) + ".class";
                String string4 = file.getParent() == null ? string3 : file.getParent() + File.separator + string3;
                classNameHelper.setTargetClassFileName(string4);
            }
            if (classNameHelper.getTargetClassFileName() == null) {
                Context.reportError(ToolErrorReporter.getMessage("msg.no-opt"));
            }
            try {
                object = new FileReader(string);
                context.compileReader(null, (Reader)object, string, 1, null);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", string));
                return;
            }
            catch (IOException iOException) {
                Context.reportError(iOException.toString());
            }
        }
    }

    static String getClassName(String string) {
        char[] cArray = new char[string.length() + 1];
        int n = 0;
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            cArray[n++] = 95;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.charAt(n2);
            cArray[n] = Character.isJavaIdentifierPart((char)n3) ? n3 : 95;
            ++n2;
            ++n;
        }
        return new String(cArray).trim();
    }

    private static void p(String string) {
        System.out.println(string);
    }
}

