/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.SourceInfo;

class CreateFileWindow
implements Runnable {
    Main db;
    SourceInfo sourceInfo;
    int line;
    boolean activate;

    private CreateFileWindow() {
    }

    static Runnable action(Main main, SourceInfo sourceInfo, int n) {
        CreateFileWindow createFileWindow = new CreateFileWindow();
        createFileWindow.db = main;
        createFileWindow.sourceInfo = sourceInfo;
        createFileWindow.line = n;
        createFileWindow.activate = true;
        return createFileWindow;
    }

    static Runnable action(Main main, SourceInfo sourceInfo, int n, boolean bl) {
        CreateFileWindow createFileWindow = new CreateFileWindow();
        createFileWindow.db = main;
        createFileWindow.sourceInfo = sourceInfo;
        createFileWindow.line = n;
        createFileWindow.activate = bl;
        return createFileWindow;
    }

    public void run() {
        String string = this.sourceInfo.getUrl();
        FileWindow fileWindow = new FileWindow(this.db, this.sourceInfo);
        this.db.fileWindows.put(string, fileWindow);
        if (this.line != -1) {
            if (this.db.currentWindow != null) {
                this.db.currentWindow.setPosition(-1);
            }
            try {
                fileWindow.setPosition(fileWindow.textArea.getLineStartOffset(this.line - 1));
            }
            catch (BadLocationException badLocationException) {
                try {
                    fileWindow.setPosition(fileWindow.textArea.getLineStartOffset(0));
                }
                catch (BadLocationException badLocationException2) {
                    fileWindow.setPosition(-1);
                }
            }
        }
        this.db.desk.add(fileWindow);
        if (this.line != -1) {
            this.db.currentWindow = fileWindow;
        }
        fileWindow.setVisible(true);
        if (this.activate) {
            try {
                fileWindow.setMaximum(true);
                fileWindow.setSelected(true);
                fileWindow.moveToFront();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

