/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.optimizer.CSEHolder;
import org.mozilla.javascript.optimizer.DataFlowBitSet;
import org.mozilla.javascript.optimizer.FatBlock;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

public class Block {
    private IRFactory itsIRFactory;
    private Block[] itsSuccessors;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private int itsEndNodeIndex;
    private Node[] itsStatementNodes;
    private int itsBlockID;
    private DataFlowBitSet itsLiveOnEntrySet;
    private DataFlowBitSet itsLiveOnExitSet;
    private DataFlowBitSet itsUseBeforeDefSet;
    private DataFlowBitSet itsNotDefSet;

    public Block(int n, int n2, Node[] nodeArray) {
        this.itsStartNodeIndex = n;
        this.itsEndNodeIndex = n2;
        this.itsStatementNodes = nodeArray;
    }

    public void setBlockID(int n) {
        this.itsBlockID = n;
    }

    public int getBlockID() {
        return this.itsBlockID;
    }

    public Node getStartNode() {
        return this.itsStatementNodes[this.itsStartNodeIndex];
    }

    public Node getEndNode() {
        return this.itsStatementNodes[this.itsEndNodeIndex];
    }

    public Block[] getPredecessorList() {
        return this.itsPredecessors;
    }

    public Block[] getSuccessorList() {
        return this.itsSuccessors;
    }

    public static Block[] buildBlocks(Node[] nodeArray) {
        Object object;
        FatBlock fatBlock;
        int n;
        Hashtable<Node, FatBlock> hashtable = new Hashtable<Node, FatBlock>();
        ObjArray objArray = new ObjArray();
        int n2 = 0;
        block4: for (n = 0; n < nodeArray.length; ++n) {
            switch (nodeArray[n].getType()) {
                case 137: {
                    if (n == n2) continue block4;
                    fatBlock = new FatBlock(n2, n - 1, nodeArray);
                    if (nodeArray[n2].getType() == 137) {
                        hashtable.put(nodeArray[n2], fatBlock);
                    }
                    objArray.add(fatBlock);
                    n2 = n;
                    continue block4;
                }
                case 6: 
                case 7: 
                case 8: {
                    fatBlock = new FatBlock(n2, n, nodeArray);
                    if (nodeArray[n2].getType() == 137) {
                        hashtable.put(nodeArray[n2], fatBlock);
                    }
                    objArray.add(fatBlock);
                    n2 = n + 1;
                }
            }
        }
        if (n2 != nodeArray.length) {
            FatBlock fatBlock2 = new FatBlock(n2, nodeArray.length - 1, nodeArray);
            if (nodeArray[n2].getType() == 137) {
                hashtable.put(nodeArray[n2], fatBlock2);
            }
            objArray.add(fatBlock2);
        }
        for (n = 0; n < objArray.size(); ++n) {
            Object object2;
            fatBlock = (FatBlock)objArray.get(n);
            object = fatBlock.getEndNode();
            int n3 = ((Node)object).getType();
            if (n3 != 6 && n < objArray.size() - 1) {
                object2 = (FatBlock)objArray.get(n + 1);
                fatBlock.addSuccessor((FatBlock)object2);
                ((FatBlock)object2).addPredecessor(fatBlock);
            }
            if (n3 != 8 && n3 != 7 && n3 != 6) continue;
            object2 = (Node)((Node)object).getProp(1);
            FatBlock fatBlock3 = (FatBlock)hashtable.get(object2);
            ((Node)object2).putProp(23, fatBlock3.getSlimmerSelf());
            fatBlock.addSuccessor(fatBlock3);
            fatBlock3.addPredecessor(fatBlock);
        }
        Block[] blockArray = new Block[objArray.size()];
        for (int i = 0; i < objArray.size(); ++i) {
            object = (FatBlock)objArray.get(i);
            blockArray[i] = ((FatBlock)object).diet();
            blockArray[i].setBlockID(i);
        }
        return blockArray;
    }

    public static String toString(Block[] blockArray, Node[] nodeArray) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(blockArray.length + " Blocks");
        for (int i = 0; i < blockArray.length; ++i) {
            int n;
            Block block = blockArray[i];
            printWriter.println("#" + block.itsBlockID);
            printWriter.println("from " + block.itsStartNodeIndex + " " + nodeArray[block.itsStartNodeIndex].toString());
            printWriter.println("thru " + block.itsEndNodeIndex + " " + nodeArray[block.itsEndNodeIndex].toString());
            printWriter.print("Predecessors ");
            if (block.itsPredecessors != null) {
                for (n = 0; n < block.itsPredecessors.length; ++n) {
                    printWriter.print(block.itsPredecessors[n].getBlockID() + " ");
                }
                printWriter.println();
            } else {
                printWriter.println("none");
            }
            printWriter.print("Successors ");
            if (block.itsSuccessors != null) {
                for (n = 0; n < block.itsSuccessors.length; ++n) {
                    printWriter.print(block.itsSuccessors[n].getBlockID() + " ");
                }
                printWriter.println();
                continue;
            }
            printWriter.println("none");
        }
        return stringWriter.toString();
    }

    void lookForVariablesAndCalls(Node node, boolean[] blArray, VariableTable variableTable) {
        switch (node.getType()) {
            case 73: {
                Node node2 = node.getFirstChild();
                Node node3 = node2.getNext();
                this.lookForVariablesAndCalls(node3, blArray, variableTable);
                Object object = node.getProp(24);
                if (object == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                blArray[n] = true;
                break;
            }
            case 43: {
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                    this.lookForVariablesAndCalls(node4, blArray, variableTable);
                }
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    OptLocalVariable.get(variableTable, i).markLiveAcrossCall();
                }
                break;
            }
            case 72: {
                Object object = node.getProp(24);
                if (object == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                if (node.getProp(25) == null || this.itsLiveOnExitSet.test(n)) break;
                blArray[n] = false;
                break;
            }
            default: {
                for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNext()) {
                    this.lookForVariablesAndCalls(node5, blArray, variableTable);
                }
            }
        }
    }

    void markAnyTypeVariables(VariableTable variableTable) {
        for (int i = 0; i < variableTable.size(); ++i) {
            if (!this.itsLiveOnEntrySet.test(i)) continue;
            OptLocalVariable.get(variableTable, i).assignType(3);
        }
    }

    void markVolatileVariables(VariableTable variableTable) {
        int n;
        boolean[] blArray = new boolean[variableTable.size()];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = this.itsLiveOnEntrySet.test(n);
        }
        for (n = this.itsStartNodeIndex; n <= this.itsEndNodeIndex; ++n) {
            Node node = this.itsStatementNodes[n];
            this.lookForVariablesAndCalls(node, blArray, variableTable);
        }
    }

    void lookForVariableAccess(Node node, Node[] nodeArray) {
        switch (node.getType()) {
            case 106: 
            case 107: {
                Object object;
                Node node2 = node.getFirstChild();
                if (node2.getType() != 72 || (object = node2.getProp(24)) == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                if (!this.itsNotDefSet.test(n)) {
                    this.itsUseBeforeDefSet.set(n);
                }
                this.itsNotDefSet.set(n);
                break;
            }
            case 73: {
                Node node3 = node.getFirstChild();
                Node node4 = node3.getNext();
                this.lookForVariableAccess(node4, nodeArray);
                Object object = node.getProp(24);
                if (object == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                this.itsNotDefSet.set(n);
                if (nodeArray[n] == null) break;
                nodeArray[n].putProp(25, object);
                break;
            }
            case 72: {
                Object object = node.getProp(24);
                if (object == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                if (!this.itsNotDefSet.test(n)) {
                    this.itsUseBeforeDefSet.set(n);
                }
                nodeArray[n] = node;
                break;
            }
            default: {
                for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNext()) {
                    this.lookForVariableAccess(node5, nodeArray);
                }
            }
        }
    }

    public void initLiveOnEntrySets(VariableTable variableTable) {
        int n;
        int n2 = variableTable.size();
        Node[] nodeArray = new Node[n2];
        this.itsUseBeforeDefSet = new DataFlowBitSet(n2);
        this.itsNotDefSet = new DataFlowBitSet(n2);
        this.itsLiveOnEntrySet = new DataFlowBitSet(n2);
        this.itsLiveOnExitSet = new DataFlowBitSet(n2);
        for (n = this.itsStartNodeIndex; n <= this.itsEndNodeIndex; ++n) {
            Node node = this.itsStatementNodes[n];
            this.lookForVariableAccess(node, nodeArray);
        }
        for (n = 0; n < n2; ++n) {
            if (nodeArray[n] == null) continue;
            nodeArray[n].putProp(25, this);
        }
        this.itsNotDefSet.not();
    }

    boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            for (int i = 0; i < this.itsSuccessors.length; ++i) {
                this.itsLiveOnExitSet.or(this.itsSuccessors[i].itsLiveOnEntrySet);
            }
        }
        return this.itsLiveOnEntrySet.df2(this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    int findExpressionType(Node node) {
        Node node2;
        switch (node.getType()) {
            case 45: {
                return 1;
            }
            case 30: 
            case 43: {
                return 0;
            }
            case 41: {
                return 3;
            }
            case 72: {
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
                if (optLocalVariable != null) {
                    return optLocalVariable.getTypeUnion();
                }
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 106: 
            case 107: {
                return 1;
            }
            case 23: {
                Node node3 = node.getFirstChild();
                int n = this.findExpressionType(node3);
                int n2 = this.findExpressionType(node3.getNext());
                return n | n2;
            }
        }
        if (node2 == null) {
            return 3;
        }
        int n = 0;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            n |= this.findExpressionType(node2);
        }
        return n;
    }

    boolean findDefPoints(Node node) {
        boolean bl = false;
        switch (node.getType()) {
            default: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    bl |= this.findDefPoints(node2);
                }
                break;
            }
            case 106: 
            case 107: {
                Node node3 = node.getFirstChild();
                OptLocalVariable optLocalVariable = (OptLocalVariable)node3.getProp(24);
                if (optLocalVariable == null) break;
                bl |= optLocalVariable.assignType(1);
                break;
            }
            case 40: {
                Node node4 = node.getFirstChild();
                Node node5 = node4.getNext();
                Node node6 = node5.getNext();
                if (node4 != null) {
                    OptLocalVariable optLocalVariable;
                    if (node4.getType() == 72 && (optLocalVariable = (OptLocalVariable)node4.getProp(24)) != null) {
                        optLocalVariable.assignType(3);
                    }
                    bl |= this.findDefPoints(node4);
                }
                if (node5 != null) {
                    bl |= this.findDefPoints(node5);
                }
                if (node6 == null) break;
                bl |= this.findDefPoints(node6);
                break;
            }
            case 73: {
                Node node7 = node.getFirstChild();
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
                if (optLocalVariable == null) break;
                Node node8 = node7.getNext();
                int n = this.findExpressionType(node8);
                bl |= optLocalVariable.assignType(n);
            }
        }
        return bl;
    }

    void localCSE(Node node, Node node2, Hashtable hashtable, OptFunctionNode optFunctionNode) {
        switch (node2.getType()) {
            default: {
                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    this.localCSE(node2, node3, hashtable, optFunctionNode);
                }
                break;
            }
            case 106: 
            case 107: {
                Node node4 = node2.getFirstChild();
                if (node4.getType() == 39) {
                    Node node5 = node4.getFirstChild().getNext();
                    if (node5.getType() == 46) {
                        hashtable.remove(node5.getString());
                        break;
                    }
                    hashtable.clear();
                    break;
                }
                if (node4.getType() == 72) break;
                hashtable.clear();
                break;
            }
            case 40: {
                Node node6 = node2.getFirstChild();
                Node node7 = node6.getNext();
                Node node8 = node7.getNext();
                if (node6 != null) {
                    this.localCSE(node2, node6, hashtable, optFunctionNode);
                }
                if (node7 != null) {
                    this.localCSE(node2, node7, hashtable, optFunctionNode);
                }
                if (node8 != null) {
                    this.localCSE(node2, node8, hashtable, optFunctionNode);
                }
                if (node7.getType() == 46) {
                    hashtable.remove(node7.getString());
                    break;
                }
                hashtable.clear();
                break;
            }
            case 39: {
                Node node9;
                Node node10;
                Object object;
                Node node11;
                Node node12 = node2.getFirstChild();
                if (node12 != null) {
                    this.localCSE(node2, node12, hashtable, optFunctionNode);
                }
                if (node12.getType() != 109 || node12.getOperation() != 50 || (node11 = node12.getNext()).getType() != 46) break;
                String string = node11.getString();
                Object v = hashtable.get(string);
                if (v == null) {
                    hashtable.put(string, new CSEHolder(node, node2));
                    break;
                }
                if (node == null) break;
                if (v instanceof CSEHolder) {
                    object = (CSEHolder)v;
                    node10 = ((CSEHolder)object).getPropChild.getNext();
                    ((CSEHolder)object).getPropParent.removeChild(((CSEHolder)object).getPropChild);
                    node9 = this.itsIRFactory.createNewLocal(((CSEHolder)object).getPropChild);
                    optFunctionNode.incrementLocalCount();
                    if (node10 == null) {
                        ((CSEHolder)object).getPropParent.addChildToBack(node9);
                    } else {
                        ((CSEHolder)object).getPropParent.addChildBefore(node9, node10);
                    }
                    hashtable.put(string, node9);
                } else {
                    node9 = (Node)v;
                }
                object = node2.getNext();
                node.removeChild(node2);
                node10 = this.itsIRFactory.createUseLocal(node9);
                if (object == null) {
                    node.addChildToBack(node10);
                    break;
                }
                node.addChildBefore(node10, (Node)object);
                break;
            }
            case 42: {
                Node node13 = node2.getFirstChild();
                Node node14 = node13.getNext();
                Node node15 = node14.getNext();
                if (node13 != null) {
                    this.localCSE(node2, node13, hashtable, optFunctionNode);
                }
                if (node14 != null) {
                    this.localCSE(node2, node14, hashtable, optFunctionNode);
                }
                if (node15 != null) {
                    this.localCSE(node2, node15, hashtable, optFunctionNode);
                }
                hashtable.clear();
                break;
            }
            case 43: {
                for (Node node16 = node2.getFirstChild(); node16 != null; node16 = node16.getNext()) {
                    this.localCSE(node2, node16, hashtable, optFunctionNode);
                }
                hashtable.clear();
            }
        }
    }

    Hashtable localCSE(Hashtable hashtable, OptFunctionNode optFunctionNode) {
        this.itsIRFactory = new IRFactory(null, null);
        if (hashtable == null) {
            hashtable = new Hashtable(5);
        }
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node node = this.itsStatementNodes[i];
            if (node == null) continue;
            this.localCSE(null, node, hashtable, optFunctionNode);
        }
        return hashtable;
    }

    void findDefs() {
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node node = this.itsStatementNodes[i];
            if (node == null) continue;
            this.findDefPoints(node);
        }
    }

    public boolean doTypeFlow() {
        boolean bl = false;
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node node = this.itsStatementNodes[i];
            if (node == null) continue;
            bl |= this.findDefPoints(node);
        }
        return bl;
    }

    public boolean isLiveOnEntry(int n) {
        return this.itsLiveOnEntrySet != null && this.itsLiveOnEntrySet.test(n);
    }

    public void printLiveOnEntrySet(PrintWriter printWriter, VariableTable variableTable) {
        for (int i = 0; i < variableTable.size(); ++i) {
            String string = OptLocalVariable.get(variableTable, i).getName();
            if (this.itsUseBeforeDefSet.test(i)) {
                printWriter.println(string + " is used before def'd");
            }
            if (this.itsNotDefSet.test(i)) {
                printWriter.println(string + " is not def'd");
            }
            if (this.itsLiveOnEntrySet.test(i)) {
                printWriter.println(string + " is live on entry");
            }
            if (!this.itsLiveOnExitSet.test(i)) continue;
            printWriter.println(string + " is live on exit");
        }
    }

    public void setSuccessorList(Block[] blockArray) {
        this.itsSuccessors = blockArray;
    }

    public void setPredecessorList(Block[] blockArray) {
        this.itsPredecessors = blockArray;
    }
}

