/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Invoker;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class FunctionObject
extends BaseFunction {
    static final long serialVersionUID = -4074285335521944312L;
    private static final Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private static final String INVOKER_MASTER_CLASS = "org.mozilla.javascript.optimizer.InvokerImpl";
    static Invoker invokerMaster = FunctionObject.newInvokerMaster();
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    static Method[] methodsCache;
    transient Method method;
    transient Constructor ctor;
    transient Invoker invoker;
    private transient Class[] types;
    private int parmsLength;
    private boolean hasVoidReturn;
    private boolean isStatic;
    private boolean useDynamicScope;

    public FunctionObject(String string, Member member, Scriptable scriptable) {
        String string2;
        if (member instanceof Constructor) {
            this.ctor = (Constructor)member;
            this.isStatic = true;
            this.types = this.ctor.getParameterTypes();
            string2 = this.ctor.getName();
        } else {
            this.method = (Method)member;
            this.isStatic = Modifier.isStatic(this.method.getModifiers());
            this.types = this.method.getParameterTypes();
            string2 = this.method.getName();
        }
        this.functionName = string;
        if (this.types.length == 4 && (this.types[1].isArray() || this.types[2].isArray())) {
            if (this.types[1].isArray()) {
                if (!this.isStatic || this.types[0] != Context.class || this.types[1].getComponentType() != ScriptRuntime.ObjectClass || this.types[2] != ScriptRuntime.FunctionClass || this.types[3] != Boolean.TYPE) {
                    throw Context.reportRuntimeError1("msg.varargs.ctor", string2);
                }
                this.parmsLength = -2;
            } else {
                if (!this.isStatic || this.types[0] != Context.class || this.types[1] != ScriptRuntime.ScriptableClass || this.types[2].getComponentType() != ScriptRuntime.ObjectClass || this.types[3] != ScriptRuntime.FunctionClass) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", string2);
                }
                this.parmsLength = -1;
            }
        } else {
            for (Class clazz : this.types) {
                if (clazz == ScriptRuntime.ObjectClass || clazz == ScriptRuntime.StringClass || clazz == ScriptRuntime.BooleanClass || ScriptRuntime.NumberClass.isAssignableFrom(clazz) || Scriptable.class.isAssignableFrom(clazz) || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Float.TYPE || clazz == Double.TYPE) continue;
                throw Context.reportRuntimeError1("msg.bad.parms", string2);
            }
        }
        this.hasVoidReturn = this.method != null && this.method.getReturnType() == Void.TYPE;
        ScriptRuntime.setFunctionProtoAndParent(scriptable, this);
        Context context = Context.getCurrentContext();
        this.useDynamicScope = context != null && context.hasCompileFunctionsWithDynamicScope();
    }

    public int getArity() {
        return this.parmsLength < 0 ? 1 : this.parmsLength;
    }

    public int getLength() {
        return this.getArity();
    }

    public static Method[] findMethods(Class clazz, String string) {
        return FunctionObject.findMethods(FunctionObject.getMethodList(clazz), string);
    }

    static Method[] findMethods(Method[] methodArray, String string) {
        ObjArray objArray = null;
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i] == null || !methodArray[i].getName().equals(string)) continue;
            if (method == null) {
                method = methodArray[i];
                continue;
            }
            if (objArray == null) {
                objArray = new ObjArray(5);
                objArray.add(method);
            }
            objArray.add(methodArray[i]);
        }
        if (objArray == null) {
            if (method == null) {
                return null;
            }
            Method[] methodArray2 = new Method[]{method};
            return methodArray2;
        }
        Object[] objectArray = new Method[objArray.size()];
        objArray.toArray(objectArray);
        return objectArray;
    }

    static Method[] getMethodList(Class clazz) {
        Method[] methodArray = methodsCache;
        if (methodArray != null && methodArray[0].getDeclaringClass() == clazz) {
            return methodArray;
        }
        Method[] methodArray2 = null;
        try {
            if (!sawSecurityException) {
                methodArray2 = clazz.getDeclaredMethods();
            }
        }
        catch (SecurityException securityException) {
            sawSecurityException = true;
        }
        if (methodArray2 == null) {
            methodArray2 = clazz.getMethods();
        }
        int n = 0;
        for (int i = 0; i < methodArray2.length; ++i) {
            if (sawSecurityException ? methodArray2[i].getDeclaringClass() != clazz : !Modifier.isPublic(methodArray2[i].getModifiers())) {
                methodArray2[i] = null;
                continue;
            }
            ++n;
        }
        Method[] methodArray3 = new Method[n];
        int n2 = 0;
        for (int i = 0; i < methodArray2.length; ++i) {
            if (methodArray2[i] == null) continue;
            methodArray3[n2++] = methodArray2[i];
        }
        if (methodArray3.length > 0 && Context.isCachingEnabled) {
            methodsCache = methodArray3;
        }
        return methodArray3;
    }

    public void addAsConstructor(Scriptable scriptable, Scriptable scriptable2) {
        ScriptRuntime.setFunctionProtoAndParent(scriptable, this);
        this.setImmunePrototypeProperty(scriptable2);
        scriptable2.setParentScope(this);
        FunctionObject.defineProperty(scriptable2, "constructor", this, 7);
        String string = scriptable2.getClassName();
        FunctionObject.defineProperty(scriptable, string, this, 2);
        this.setParentScope(scriptable);
    }

    public static Object convertArg(Context context, Scriptable scriptable, Object object, Class clazz) {
        if (clazz == ScriptRuntime.StringClass) {
            return ScriptRuntime.toString(object);
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            return new Integer(ScriptRuntime.toInt32(object));
        }
        if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
            return ScriptRuntime.toBoolean(object) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            return new Double(ScriptRuntime.toNumber(object));
        }
        if (clazz == ScriptRuntime.ScriptableClass) {
            return ScriptRuntime.toObject(context, scriptable, object);
        }
        if (clazz == ScriptRuntime.ObjectClass) {
            return object;
        }
        throw Context.reportRuntimeError1("msg.cant.convert", clazz.getName());
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object;
        int n;
        Object[] objectArray2;
        if (this.parmsLength < 0) {
            return this.callVarargs(context, scriptable2, objectArray, false);
        }
        if (!this.isStatic) {
            Object[] objectArray3 = objectArray2 = this.method != null ? this.method.getDeclaringClass() : this.ctor.getDeclaringClass();
            while (!objectArray2.isInstance(scriptable2)) {
                if ((scriptable2 = scriptable2.getPrototype()) != null && this.useDynamicScope) continue;
                throw NativeGlobal.typeError1("msg.incompat.call", this.functionName, scriptable);
            }
        }
        if (this.parmsLength == objectArray.length) {
            objectArray2 = objectArray;
            n = this.types == null ? this.parmsLength : 0;
        } else {
            objectArray2 = new Object[this.parmsLength];
            n = 0;
        }
        while (n < this.parmsLength) {
            Object object2 = object = n < objectArray.length ? objectArray[n] : Undefined.instance;
            if (this.types != null) {
                object = FunctionObject.convertArg(context, this, object, this.types[n]);
            }
            objectArray2[n] = object;
            ++n;
        }
        try {
            object = this.method == null ? this.ctor.newInstance(objectArray2) : this.doInvoke(context, scriptable2, objectArray2);
            return this.hasVoidReturn ? Undefined.instance : object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JavaScriptException.wrapException(context, scriptable, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        if (this.method == null || this.parmsLength == -2) {
            Scriptable scriptable2;
            Scriptable scriptable3 = this.method != null ? (Scriptable)this.callVarargs(context, null, objectArray, true) : (Scriptable)this.call(context, scriptable, null, objectArray);
            if (scriptable3.getPrototype() == null) {
                scriptable3.setPrototype(this.getClassPrototype());
            }
            if (scriptable3.getParentScope() == null && scriptable3 != (scriptable2 = this.getParentScope())) {
                scriptable3.setParentScope(scriptable2);
            }
            return scriptable3;
        }
        if (this.method != null && !this.isStatic) {
            Scriptable scriptable4;
            try {
                scriptable4 = (Scriptable)this.method.getDeclaringClass().newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw WrappedException.wrapException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw WrappedException.wrapException(instantiationException);
            }
            scriptable4.setPrototype(this.getClassPrototype());
            scriptable4.setParentScope(this.getParentScope());
            Object object = this.call(context, scriptable, scriptable4, objectArray);
            if (object != null && object != Undefined.instance && object instanceof Scriptable) {
                return (Scriptable)object;
            }
            return scriptable4;
        }
        return super.construct(context, scriptable, objectArray);
    }

    private final Object doInvoke(Context context, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        Invoker invoker = invokerMaster;
        if (invoker != null) {
            if (this.invoker == null) {
                this.invoker = invoker.createInvoker(context, this.method, this.types);
            }
            try {
                return this.invoker.invoke(object, objectArray);
            }
            catch (Exception exception) {
                throw new InvocationTargetException(exception);
            }
        }
        return this.method.invoke(object, objectArray);
    }

    private Object callVarargs(Context context, Scriptable scriptable, Object[] objectArray, boolean bl) throws JavaScriptException {
        try {
            if (this.parmsLength == -1) {
                Object[] objectArray2 = new Object[]{context, scriptable, objectArray, this};
                Object object = this.doInvoke(context, null, objectArray2);
                return this.hasVoidReturn ? Undefined.instance : object;
            }
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            Object[] objectArray3 = new Object[]{context, objectArray, this, bl2};
            return this.method == null ? this.ctor.newInstance(objectArray3) : this.doInvoke(context, null, objectArray3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof EvaluatorException) {
                throw (EvaluatorException)throwable;
            }
            if (throwable instanceof EcmaError) {
                throw (EcmaError)throwable;
            }
            Scriptable scriptable2 = scriptable == null ? this : scriptable;
            throw JavaScriptException.wrapException(context, scriptable2, throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    static void setCachingEnabled(boolean bl) {
        if (!bl) {
            methodsCache = null;
            invokerMaster = null;
        } else if (invokerMaster == null) {
            invokerMaster = FunctionObject.newInvokerMaster();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        boolean bl = this.ctor != null;
        Executable executable = bl ? this.ctor : this.method;
        FunctionObject.writeMember(objectOutputStream, executable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Member member = FunctionObject.readMember(objectInputStream);
        if (member instanceof Method) {
            this.method = (Method)member;
            this.types = this.method.getParameterTypes();
        } else {
            this.ctor = (Constructor)member;
            this.types = this.ctor.getParameterTypes();
        }
    }

    static void writeMember(ObjectOutputStream objectOutputStream, Member member) throws IOException {
        if (member == null) {
            objectOutputStream.writeBoolean(false);
            return;
        }
        objectOutputStream.writeBoolean(true);
        if (!(member instanceof Method) && !(member instanceof Constructor)) {
            throw new IllegalArgumentException("not Method or Constructor");
        }
        objectOutputStream.writeBoolean(member instanceof Method);
        objectOutputStream.writeObject(member.getName());
        objectOutputStream.writeObject(member.getDeclaringClass());
        if (member instanceof Method) {
            FunctionObject.writeParameters(objectOutputStream, ((Method)member).getParameterTypes());
        } else {
            FunctionObject.writeParameters(objectOutputStream, ((Constructor)member).getParameterTypes());
        }
    }

    static Member readMember(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (!objectInputStream.readBoolean()) {
            return null;
        }
        boolean bl = objectInputStream.readBoolean();
        String string = (String)objectInputStream.readObject();
        Class clazz = (Class)objectInputStream.readObject();
        Class[] classArray = FunctionObject.readParameters(objectInputStream);
        try {
            if (bl) {
                return clazz.getMethod(string, classArray);
            }
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Cannot find member: " + noSuchMethodException);
        }
    }

    static void writeParameters(ObjectOutputStream objectOutputStream, Class[] classArray) throws IOException {
        objectOutputStream.writeShort(classArray.length);
        block0: for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            objectOutputStream.writeBoolean(clazz.isPrimitive());
            if (!clazz.isPrimitive()) {
                objectOutputStream.writeObject(clazz);
                continue;
            }
            for (int j = 0; j < primitives.length; ++j) {
                if (!clazz.equals(primitives[j])) continue;
                objectOutputStream.writeByte(j);
                continue block0;
            }
            throw new IllegalArgumentException("Primitive " + clazz + " not found");
        }
    }

    static Class[] readParameters(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class[] classArray = new Class[objectInputStream.readShort()];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = !objectInputStream.readBoolean() ? (Class)objectInputStream.readObject() : primitives[objectInputStream.readByte()];
        }
        return classArray;
    }

    private static Invoker newInvokerMaster() {
        try {
            Class<?> clazz = Class.forName(INVOKER_MASTER_CLASS);
            return (Invoker)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }
}

