/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.ClassOutput;
import org.mozilla.javascript.ClassRepository;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.DefiningClassLoader;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.ListenerArray;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeMath;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrapHandler;
import org.mozilla.javascript.debug.DebugReader;
import org.mozilla.javascript.debug.Debugger;

public class Context {
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    static final String defaultResource = "org.mozilla.javascript.resources.Messages";
    static final boolean printTrees = false;
    static final boolean printICode = false;
    private static Class codegenClass;
    static final boolean check = true;
    static boolean isCachingEnabled;
    private static Hashtable threadContexts;
    private static Object threadLocalCx;
    private static Method threadLocalGet;
    private static Method threadLocalSet;
    private static Method method_getContextClassLoader;
    private static final Object contextListenersLock;
    private static Object[] contextListeners;
    NativeCall currentActivation;
    ObjToIntMap iterating;
    Object interpreterSecurityDomain;
    int version;
    int errorCount;
    private SecurityController securityController;
    private ClassShutter classShutter;
    private ErrorReporter errorReporter;
    private RegExpProxy regExpProxy;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    private boolean compileFunctionsWithDynamicScopeFlag;
    private int optimizationLevel;
    private WrapFactory wrapFactory;
    Debugger debugger;
    private Object debuggerData;
    private int enterCount;
    private Object[] listeners;
    private Hashtable hashtable;
    private ClassLoader applicationClassLoader;
    private Hashtable activationNames;
    int interpreterLine;
    String interpreterSourceFile;
    int instructionCount;
    int instructionThreshold;

    public Context() {
        this.setLanguageVersion(0);
        this.optimizationLevel = codegenClass != null ? 0 : -1;
        Object[] objectArray = contextListeners;
        if (objectArray != null) {
            int n = objectArray.length;
            while (n-- != 0) {
                ((ContextListener)objectArray[n]).contextCreated(this);
            }
        }
    }

    public Context(SecuritySupport securitySupport) {
        this();
        this.setClassShutter(securitySupport);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context context) {
        Context context2 = Context.getCurrentContext();
        if (context == null) {
            if (context2 != null) {
                context = context2;
            } else {
                context = new Context();
                Context.setThreadContext(context);
            }
        } else if (context.enterCount != 0) {
            if (context != context2) {
                throw new RuntimeException("Cannot enter Context active on another thread");
            }
        } else if (context2 != null) {
            context = context2;
        } else {
            Context.setThreadContext(context);
        }
        ++context.enterCount;
        Object[] objectArray = contextListeners;
        if (objectArray != null) {
            int n = objectArray.length;
            while (n-- != 0) {
                ((ContextListener)objectArray[n]).contextEntered(context);
            }
        }
        return context;
    }

    public static void exit() {
        Object[] objectArray;
        boolean bl = false;
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new RuntimeException("Calling Context.exit without previous Context.enter");
        }
        if (context.enterCount < 1) {
            Context.codeBug();
        }
        --context.enterCount;
        if (context.enterCount == 0) {
            bl = true;
            Context.setThreadContext(null);
        }
        if ((objectArray = contextListeners) != null) {
            int n = objectArray.length;
            while (n-- != 0) {
                ((ContextListener)objectArray[n]).contextExited(context);
            }
            if (bl) {
                n = objectArray.length;
                while (n-- != 0) {
                    ((ContextListener)objectArray[n]).contextReleased(context);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContextListener(ContextListener contextListener) {
        Object object = contextListenersLock;
        synchronized (object) {
            contextListeners = ListenerArray.add(contextListeners, contextListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContextListener(ContextListener contextListener) {
        Object object = contextListenersLock;
        synchronized (object) {
            contextListeners = ListenerArray.remove(contextListeners, contextListener);
        }
    }

    public static Context getCurrentContext() {
        if (threadLocalCx != null) {
            try {
                return (Context)threadLocalGet.invoke(threadLocalCx, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread thread = Thread.currentThread();
        return (Context)threadContexts.get(thread);
    }

    private static void setThreadContext(Context context) {
        if (threadLocalCx != null) {
            try {
                threadLocalSet.invoke(threadLocalCx, context);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread thread = Thread.currentThread();
        if (context != null) {
            threadContexts.put(thread, context);
        } else {
            threadContexts.remove(thread);
        }
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int n) {
        Object[] objectArray = this.listeners;
        if (objectArray != null && n != this.version) {
            this.firePropertyChangeImpl(objectArray, languageVersionProperty, new Integer(this.version), new Integer(n));
        }
        this.version = n;
    }

    public String getImplementationVersion() {
        return "Rhino 1.5 release 4.1 2003 04 21";
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = new DefaultErrorReporter();
        }
        return this.errorReporter;
    }

    public ErrorReporter setErrorReporter(ErrorReporter errorReporter) {
        ErrorReporter errorReporter2 = this.errorReporter;
        Object[] objectArray = this.listeners;
        if (objectArray != null && this.errorReporter != errorReporter) {
            this.firePropertyChangeImpl(objectArray, errorReporterProperty, this.errorReporter, errorReporter);
        }
        this.errorReporter = errorReporter;
        return errorReporter2;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public Locale setLocale(Locale locale) {
        Locale locale2 = this.locale;
        this.locale = locale;
        return locale2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.add(this.listeners, propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.remove(this.listeners, propertyChangeListener);
        }
    }

    void firePropertyChange(String string, Object object, Object object2) {
        Object[] objectArray = this.listeners;
        if (objectArray != null) {
            this.firePropertyChangeImpl(objectArray, string, object, object2);
        }
    }

    private void firePropertyChangeImpl(Object[] objectArray, String string, Object object, Object object2) {
        int n = objectArray.length;
        while (n-- != 0) {
            Object object3 = objectArray[n];
            if (!(object3 instanceof PropertyChangeListener)) continue;
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)object3;
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public static void reportWarning(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getContext();
        context.getErrorReporter().warning(string, string2, n, string3, n2);
    }

    public static void reportWarning(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportWarning(string, string2, nArray[0], null, 0);
    }

    public static void reportError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            ++context.errorCount;
        } else {
            throw new EvaluatorException(string);
        }
        context.getErrorReporter().error(string, string2, n, string3, n2);
    }

    public static void reportError(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportError(string, string2, nArray[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            ++context.errorCount;
            return context.getErrorReporter().runtimeError(string, string2, n, string3, n2);
        }
        throw new EvaluatorException(string);
    }

    static EvaluatorException reportRuntimeError0(String string) {
        return Context.reportRuntimeError(Context.getMessage0(string));
    }

    static EvaluatorException reportRuntimeError1(String string, Object object) {
        return Context.reportRuntimeError(Context.getMessage1(string, object));
    }

    static EvaluatorException reportRuntimeError2(String string, Object object, Object object2) {
        return Context.reportRuntimeError(Context.getMessage2(string, object, object2));
    }

    static EvaluatorException reportRuntimeError3(String string, Object object, Object object2, Object object3) {
        return Context.reportRuntimeError(Context.getMessage3(string, object, object2, object3));
    }

    public static EvaluatorException reportRuntimeError(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        return Context.reportRuntimeError(string, string2, nArray[0], null, 0);
    }

    public Scriptable initStandardObjects(ScriptableObject scriptableObject) {
        return this.initStandardObjects(scriptableObject, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scriptableObject, boolean bl) {
        if (scriptableObject == null) {
            scriptableObject = new NativeObject();
        }
        BaseFunction.init(this, scriptableObject, bl);
        NativeObject.init(this, scriptableObject, bl);
        Scriptable scriptable = ScriptableObject.getObjectPrototype(scriptableObject);
        Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptableObject);
        scriptable2.setPrototype(scriptable);
        if (scriptableObject.getPrototype() == null) {
            scriptableObject.setPrototype(scriptable);
        }
        NativeError.init(this, scriptableObject, bl);
        NativeGlobal.init(this, scriptableObject, bl);
        NativeArray.init(this, scriptableObject, bl);
        NativeString.init(this, scriptableObject, bl);
        NativeBoolean.init(this, scriptableObject, bl);
        NativeNumber.init(this, scriptableObject, bl);
        NativeDate.init(this, scriptableObject, bl);
        NativeMath.init(this, scriptableObject, bl);
        NativeWith.init(this, scriptableObject, bl);
        NativeCall.init(this, scriptableObject, bl);
        NativeScript.init(this, scriptableObject, bl);
        new LazilyLoadedCtor(scriptableObject, "RegExp", "org.mozilla.javascript.regexp.NativeRegExp", bl);
        new LazilyLoadedCtor(scriptableObject, "Packages", "org.mozilla.javascript.NativeJavaPackage", bl);
        new LazilyLoadedCtor(scriptableObject, "java", "org.mozilla.javascript.NativeJavaPackage", bl);
        new LazilyLoadedCtor(scriptableObject, "getClass", "org.mozilla.javascript.NativeJavaPackage", bl);
        String string = "org.mozilla.javascript.JavaAdapter";
        String string2 = "JavaAdapter";
        try {
            string = System.getProperty(string, string);
            string2 = System.getProperty("org.mozilla.javascript.JavaAdapterClassName", string2);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        new LazilyLoadedCtor(scriptableObject, string2, string, bl);
        return scriptableObject;
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public Object evaluateString(Scriptable scriptable, String string, String string2, int n, Object object) throws JavaScriptException {
        try {
            StringReader stringReader = new StringReader(string);
            return this.evaluateReader(scriptable, stringReader, string2, n, object);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public Object evaluateReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException, JavaScriptException {
        Script script = this.compileReader(scriptable, reader, string, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean stringIsCompilableUnit(String string) {
        StringReader stringReader = new StringReader(string);
        TokenStream tokenStream = new TokenStream(stringReader, null, null, 1);
        ErrorReporter errorReporter = this.setErrorReporter(new DefaultErrorReporter());
        boolean bl = false;
        try {
            IRFactory iRFactory = new IRFactory(tokenStream, null);
            Parser parser = new Parser(iRFactory);
            parser.parse(tokenStream);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (EvaluatorException evaluatorException) {
            bl = true;
        }
        finally {
            this.setErrorReporter(errorReporter);
        }
        return !bl || !tokenStream.eof();
    }

    public Script compileReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        return (Script)this.compile(scriptable, reader, string, n, object, false);
    }

    public Function compileFunction(Scriptable scriptable, String string, String string2, int n, Object object) {
        StringReader stringReader = new StringReader(string);
        try {
            return (Function)this.compile(scriptable, stringReader, string2, n, object, true);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public String decompileScript(Script script, Scriptable scriptable, int n) {
        NativeScript nativeScript = (NativeScript)script;
        nativeScript.initScript(scriptable);
        return nativeScript.decompile(this, n, false);
    }

    public String decompileFunction(Function function, int n) {
        if (function instanceof BaseFunction) {
            return ((BaseFunction)function).decompile(this, n, false);
        }
        return "function " + function.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public String decompileFunctionBody(Function function, int n) {
        if (function instanceof BaseFunction) {
            return ((BaseFunction)function).decompile(this, n, true);
        }
        return "[native code]\n";
    }

    public Scriptable newObject(Scriptable scriptable) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scriptable, "Object", null);
    }

    public Scriptable newObject(Scriptable scriptable, String string) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scriptable, string, null);
    }

    public Scriptable newObject(Scriptable scriptable, String string, Object[] objectArray) throws PropertyException, NotAFunctionException, JavaScriptException {
        Object object = ScriptableObject.getProperty(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object instanceof Function) {
            Function function = (Function)object;
            if (objectArray == null) {
                objectArray = ScriptRuntime.emptyArgs;
            }
            return function.construct(this, scriptable, objectArray);
        }
        if (object == Scriptable.NOT_FOUND) {
            String string2 = Context.getMessage1("msg.ctor.not.found", string);
            throw new PropertyException(string2);
        }
        String string3 = Context.getMessage1("msg.not.ctor", string);
        throw new NotAFunctionException(string3);
    }

    public Scriptable newArray(Scriptable scriptable, int n) {
        NativeArray nativeArray = new NativeArray(n);
        this.newArrayHelper(scriptable, nativeArray);
        return nativeArray;
    }

    public Scriptable newArray(Scriptable scriptable, Object[] objectArray) {
        NativeArray nativeArray = new NativeArray(objectArray);
        this.newArrayHelper(scriptable, nativeArray);
        return nativeArray;
    }

    public Object[] getElements(Scriptable scriptable) {
        long l = NativeArray.getLengthProperty(scriptable);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int n = (int)l;
        if (n == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object = ScriptableObject.getProperty(scriptable, i);
            objectArray[i] = object == Scriptable.NOT_FOUND ? Undefined.instance : object;
        }
        return objectArray;
    }

    public static boolean toBoolean(Object object) {
        return ScriptRuntime.toBoolean(object);
    }

    public static double toNumber(Object object) {
        return ScriptRuntime.toNumber(object);
    }

    public static String toString(Object object) {
        return ScriptRuntime.toString(object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable) {
        return ScriptRuntime.toObject(scriptable, object, null);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable, Class clazz) {
        if (object == null && clazz != null) {
            return null;
        }
        return ScriptRuntime.toObject(scriptable, object, clazz);
    }

    public static Object toType(Object object, Class clazz) throws IllegalArgumentException {
        return NativeJavaObject.coerceType(clazz, object, false);
    }

    public boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public void setGeneratingDebug(boolean bl) {
        this.generatingDebugChanged = true;
        if (bl && this.getOptimizationLevel() > 0) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = bl;
    }

    public boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public void setGeneratingSource(boolean bl) {
        this.generatingSource = bl;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int n) {
        if (n < 0) {
            n = -1;
        } else if (n > 9) {
            n = 9;
        }
        if (codegenClass == null) {
            n = -1;
        }
        this.optimizationLevel = n;
    }

    public String getClassName() {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        return classNameHelper != null ? classNameHelper.getClassName() : null;
    }

    public void setClassName(String string) {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        if (classNameHelper != null) {
            classNameHelper.setClassName(string);
        }
    }

    public String getTargetClassFileName() {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        if (classNameHelper != null) {
            return classNameHelper.getTargetClassFileName();
        }
        return null;
    }

    public void setTargetClassFileName(String string) {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        if (classNameHelper != null) {
            classNameHelper.setTargetClassFileName(string);
        }
    }

    public String getTargetPackage() {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        return classNameHelper != null ? classNameHelper.getTargetPackage() : null;
    }

    public void setTargetPackage(String string) {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        if (classNameHelper != null) {
            classNameHelper.setTargetPackage(string);
        }
    }

    public ClassRepository getClassRepository() {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        return classNameHelper != null ? classNameHelper.getClassRepository() : null;
    }

    public void setClassRepository(ClassRepository classRepository) {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        if (classNameHelper != null) {
            classNameHelper.setClassRepository(classRepository);
        }
    }

    public ClassOutput getClassOutput() {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        if (classNameHelper != null) {
            return classNameHelper.getClassOutput();
        }
        return null;
    }

    public void setClassOutput(ClassOutput classOutput) {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        if (classNameHelper != null) {
            classNameHelper.setClassOutput(classOutput);
        }
    }

    public void setSecurityController(SecurityController securityController) {
        if (securityController == null) {
            throw new IllegalArgumentException();
        }
        if (this.securityController != null) {
            throw new SecurityException("Cannot overwrite existing SecurityController object");
        }
        this.securityController = securityController;
    }

    public void setSecuritySupport(SecuritySupport securitySupport) {
        this.setClassShutter(securitySupport);
    }

    public void setClassShutter(ClassShutter classShutter) {
        if (classShutter == null) {
            throw new IllegalArgumentException();
        }
        if (this.classShutter != null) {
            throw new SecurityException("Cannot overwrite existing ClassShutter object");
        }
        this.classShutter = classShutter;
    }

    final ClassShutter getClassShutter() {
        return this.classShutter;
    }

    public void setTargetExtends(Class clazz) {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        if (classNameHelper != null) {
            classNameHelper.setTargetExtends(clazz);
        }
    }

    public void setTargetImplements(Class[] classArray) {
        ClassNameHelper classNameHelper = ClassNameHelper.get(this);
        if (classNameHelper != null) {
            classNameHelper.setTargetImplements(classArray);
        }
    }

    public final Object getThreadLocal(Object object) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(object);
    }

    public void putThreadLocal(Object object, Object object2) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(object, object2);
    }

    public void removeThreadLocal(Object object) {
        if (this.hashtable == null) {
            return;
        }
        this.hashtable.remove(object);
    }

    public final boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public void setCompileFunctionsWithDynamicScope(boolean bl) {
        this.compileFunctionsWithDynamicScopeFlag = bl;
    }

    public static void setCachingEnabled(boolean bl) {
        if (isCachingEnabled && !bl) {
            JavaMembers.classTable = new Hashtable();
            ClassNameHelper.clearCache();
        }
        isCachingEnabled = bl;
        FunctionObject.setCachingEnabled(bl);
    }

    public void setWrapHandler(WrapHandler wrapHandler) {
        if (wrapHandler == null) {
            this.setWrapFactory(new WrapFactory());
        } else {
            this.setWrapFactory(new WrapHandlerProxy(wrapHandler));
        }
    }

    public WrapHandler getWrapHandler() {
        WrapFactory wrapFactory = this.getWrapFactory();
        if (wrapFactory instanceof WrapHandlerProxy) {
            return ((WrapHandlerProxy)wrapFactory)._handler;
        }
        return null;
    }

    public void setWrapFactory(WrapFactory wrapFactory) {
        if (wrapFactory == null) {
            throw new IllegalArgumentException();
        }
        this.wrapFactory = wrapFactory;
    }

    public final WrapFactory getWrapFactory() {
        if (this.wrapFactory == null) {
            this.wrapFactory = new WrapFactory();
        }
        return this.wrapFactory;
    }

    public final Debugger getDebugger() {
        return this.debugger;
    }

    public final Object getDebuggerContextData() {
        return this.debuggerData;
    }

    public void setDebugger(Debugger debugger, Object object) {
        this.debugger = debugger;
        this.debuggerData = object;
    }

    public boolean hasFeature(int n) {
        switch (n) {
            case 1: {
                return this.version == 100 || this.version == 110 || this.version == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.version == 120;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public void setInstructionObserverThreshold(int n) {
        this.instructionThreshold = n;
    }

    protected void observeInstructionCount(int n) {
    }

    public GeneratedClassLoader createClassLoader(ClassLoader classLoader) {
        return new DefiningClassLoader(classLoader);
    }

    public final ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader != null) {
            return this.applicationClassLoader;
        }
        ClassLoader classLoader = null;
        if (method_getContextClassLoader != null) {
            Thread thread = Thread.currentThread();
            try {
                classLoader = (ClassLoader)method_getContextClassLoader.invoke((Object)thread, ScriptRuntime.emptyArgs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (classLoader != null && !this.testIfCanUseLoader(classLoader)) {
            classLoader = null;
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    public void setApplicationClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            this.applicationClassLoader = null;
            return;
        }
        if (!this.testIfCanUseLoader(classLoader)) {
            throw new IllegalArgumentException("Loader can not resolve Rhino classes");
        }
        this.applicationClassLoader = classLoader;
    }

    private boolean testIfCanUseLoader(ClassLoader classLoader) {
        Class<?> clazz = this.getClass();
        Class clazz2 = ScriptRuntime.getClassOrNull(classLoader, clazz.getName());
        return clazz2 == clazz;
    }

    static String getMessage0(String string) {
        return Context.getMessage(string, null);
    }

    static String getMessage1(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return Context.getMessage(string, objectArray);
    }

    static String getMessage2(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return Context.getMessage(string, objectArray);
    }

    static String getMessage3(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return Context.getMessage(string, objectArray);
    }

    static Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return context;
    }

    static String getMessage(String string, Object[] objectArray) {
        String string2;
        Context context = Context.getCurrentContext();
        Locale locale = context != null ? context.getLocale() : Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(defaultResource, locale);
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("no message resource found for message property " + string);
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray);
    }

    private Object compile(Scriptable scriptable, Reader reader, String string, int n, Object object, boolean bl) throws IOException {
        Object object2 = null;
        if (this.securityController != null) {
            object2 = this.securityController.getDynamicSecurityDomain(object);
        }
        if (this.debugger != null && reader != null) {
            reader = new DebugReader(reader);
        }
        TokenStream tokenStream = new TokenStream(reader, scriptable, string, n);
        return this.compile(scriptable, tokenStream, object2, reader, bl);
    }

    private Interpreter getCompiler() {
        if (codegenClass != null) {
            try {
                return (Interpreter)codegenClass.newInstance();
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return new Interpreter();
    }

    private Object compile(Scriptable scriptable, TokenStream tokenStream, Object object, Reader reader, boolean bl) throws IOException {
        Object object2;
        Interpreter interpreter = this.optimizationLevel == -1 ? new Interpreter() : this.getCompiler();
        ClassNameHelper classNameHelper = this.optimizationLevel == -1 ? null : ClassNameHelper.get(this);
        this.errorCount = 0;
        IRFactory iRFactory = interpreter.createIRFactory(tokenStream, classNameHelper, scriptable);
        Parser parser = new Parser(iRFactory);
        Node node = (Node)parser.parse(tokenStream);
        if (node == null) {
            return null;
        }
        node = interpreter.transform(node, tokenStream, scriptable);
        if (bl) {
            object2 = node.getFirstChild();
            if (object2 == null) {
                return null;
            }
            node = (Node)((Node)object2).getProp(5);
            if (node == null) {
                return null;
            }
        }
        if (reader instanceof DebugReader) {
            object2 = (DebugReader)reader;
            node.putProp(31, ((DebugReader)object2).getSaved());
        }
        object2 = interpreter.compile(this, scriptable, node, object, this.securityController, classNameHelper);
        return this.errorCount == 0 ? object2 : null;
    }

    static String getSourcePositionFromStack(int[] nArray) {
        Context context = Context.getCurrentContext();
        if (context == null) {
            return null;
        }
        if (context.interpreterLine > 0 && context.interpreterSourceFile != null) {
            nArray[0] = context.interpreterLine;
            return context.interpreterSourceFile;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        RuntimeException runtimeException = new RuntimeException();
        runtimeException.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                n3 = i;
                continue;
            }
            if (c == '(') {
                n = i;
                continue;
            }
            if (c == ')') {
                n2 = i;
                continue;
            }
            if (c != '\n' || n == -1 || n2 == -1 || n3 == -1 || n >= n3 || n3 >= n2) continue;
            String string2 = string.substring(n + 1, n3);
            if (!string2.endsWith(".java")) {
                String string3 = string.substring(n3 + 1, n2);
                try {
                    nArray[0] = Integer.parseInt(string3);
                    return string2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            n3 = -1;
            n2 = -1;
            n = -1;
        }
        return null;
    }

    RegExpProxy getRegExpProxy() {
        if (this.regExpProxy == null) {
            try {
                Class<?> clazz = Class.forName("org.mozilla.javascript.regexp.RegExpImpl");
                this.regExpProxy = (RegExpProxy)clazz.newInstance();
                return this.regExpProxy;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this.regExpProxy;
    }

    private void newArrayHelper(Scriptable scriptable, Scriptable scriptable2) {
        scriptable2.setParentScope(scriptable);
        Object object = ScriptRuntime.getTopLevelProp(scriptable, "Array");
        if (object != null && object instanceof Scriptable) {
            Scriptable scriptable3 = (Scriptable)object;
            scriptable2.setPrototype((Scriptable)scriptable3.get("prototype", scriptable3));
        }
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    SecurityController getSecurityController() {
        return this.securityController;
    }

    public boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public void addActivationName(String string) {
        if (this.activationNames == null) {
            this.activationNames = new Hashtable(5);
        }
        this.activationNames.put(string, string);
    }

    public boolean isActivationNeeded(String string) {
        if ("arguments".equals(string)) {
            return true;
        }
        return this.activationNames != null && this.activationNames.containsKey(string);
    }

    public void removeActivationName(String string) {
        if (this.activationNames != null) {
            this.activationNames.remove(string);
        }
    }

    static void codeBug() {
        throw new RuntimeException("FAILED ASSERTION");
    }

    static {
        Class clazz;
        try {
            codegenClass = Class.forName("org.mozilla.javascript.optimizer.Codegen");
        }
        catch (ClassNotFoundException classNotFoundException) {
            codegenClass = null;
        }
        isCachingEnabled = true;
        threadContexts = new Hashtable(11);
        try {
            clazz = Class.forName("java.lang.ThreadLocal");
            threadLocalGet = clazz.getMethod("get", null);
            threadLocalSet = clazz.getMethod("set", ScriptRuntime.ObjectClass);
            threadLocalCx = clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        clazz = ScriptRuntime.getClassOrNull("java.lang.Thread");
        if (clazz != null) {
            try {
                method_getContextClassLoader = clazz.getDeclaredMethod("getContextClassLoader", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        contextListenersLock = new Object();
    }

    private static class WrapHandlerProxy
    extends WrapFactory {
        WrapHandler _handler;

        WrapHandlerProxy(WrapHandler wrapHandler) {
            this._handler = wrapHandler;
        }

        public Object wrap(Context context, Scriptable scriptable, Object object, Class clazz) {
            if (object == null) {
                return object;
            }
            Object object2 = this._handler.wrap(scriptable, object, clazz);
            if (object2 == null) {
                object2 = super.wrap(context, scriptable, object, clazz);
            }
            return object2;
        }

        public Scriptable wrapNewObject(Context context, Scriptable scriptable, Object object) {
            Object object2 = this._handler.wrap(scriptable, object, object.getClass());
            if (object2 instanceof Scriptable) {
                return (Scriptable)object2;
            }
            if (object2 == null) {
                return super.wrapNewObject(context, scriptable, object);
            }
            throw new RuntimeException("Please upgrade from WrapHandler to WrapFactory");
        }
    }
}

