/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mozilla.javascript.ClassOutput;
import org.mozilla.javascript.ClassRepository;
import org.mozilla.javascript.Context;

public abstract class ClassNameHelper {
    private static ClassNameHelper savedNameHelper;
    private static boolean helperNotAvailable;

    public static ClassNameHelper get(Context context) {
        ClassNameHelper classNameHelper = savedNameHelper;
        if (classNameHelper == null && !helperNotAvailable) {
            try {
                Class<?> clazz = Class.forName("org.mozilla.javascript.optimizer.OptClassNameHelper");
                classNameHelper = (ClassNameHelper)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            if (classNameHelper != null) {
                savedNameHelper = classNameHelper;
            } else {
                helperNotAvailable = true;
            }
        }
        return classNameHelper;
    }

    static void clearCache() {
        ClassNameHelper classNameHelper = savedNameHelper;
        if (classNameHelper != null) {
            classNameHelper.reset();
        }
    }

    public String getTargetClassFileName() {
        ClassRepository classRepository = this.getClassRepository();
        if (classRepository instanceof FileClassRepository) {
            return ((FileClassRepository)classRepository).getTargetClassFileName(this.getClassName());
        }
        return null;
    }

    public void setTargetClassFileName(String string) {
        if (string != null) {
            this.setClassRepository(new FileClassRepository(string));
        } else {
            this.setClassName(null);
        }
    }

    public final ClassOutput getClassOutput() {
        ClassRepository classRepository = this.getClassRepository();
        if (classRepository instanceof ClassOutputWrapper) {
            return ((ClassOutputWrapper)classRepository).classOutput;
        }
        return null;
    }

    public void setClassOutput(ClassOutput classOutput) {
        if (classOutput != null) {
            this.setClassRepository(new ClassOutputWrapper(classOutput));
        } else {
            this.setClassRepository(null);
        }
    }

    public abstract String getTargetPackage();

    public abstract void setTargetPackage(String var1);

    public abstract void setTargetExtends(Class var1);

    public abstract void setTargetImplements(Class[] var1);

    public abstract ClassRepository getClassRepository();

    public abstract void setClassRepository(ClassRepository var1);

    public abstract String getClassName();

    public abstract void setClassName(String var1);

    public abstract void reset();

    private static class ClassOutputWrapper
    implements ClassRepository {
        ClassOutput classOutput;

        ClassOutputWrapper(ClassOutput classOutput) {
            this.classOutput = classOutput;
        }

        public boolean storeClass(String string, byte[] byArray, boolean bl) throws IOException {
            OutputStream outputStream = this.classOutput.getOutputStream(string, bl);
            outputStream.write(byArray);
            outputStream.close();
            return true;
        }
    }

    private class FileClassRepository
    implements ClassRepository {
        String generatingDirectory;

        FileClassRepository(String string) {
            String string2;
            int n = string.lastIndexOf(File.separatorChar);
            if (n == -1) {
                this.generatingDirectory = null;
                string2 = string;
            } else {
                this.generatingDirectory = string.substring(0, n);
                string2 = string.substring(n + 1);
            }
            if (string2.endsWith(".class")) {
                string2 = string2.substring(0, string2.length() - 6);
            }
            ClassNameHelper.this.setClassName(string2);
        }

        public boolean storeClass(String string, byte[] byArray, boolean bl) throws IOException {
            String string2 = ClassNameHelper.this.getTargetPackage();
            if (string2 != null && string2.length() > 0 && string.startsWith(string2 + ".")) {
                string = string.substring(string2.length() + 1);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.getTargetClassFileName(string));
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            return false;
        }

        String getTargetClassFileName(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.generatingDirectory != null) {
                stringBuffer.append(this.generatingDirectory);
                stringBuffer.append(File.separator);
            }
            stringBuffer.append(string);
            stringBuffer.append(".class");
            return stringBuffer.toString();
        }
    }
}

