/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.geometry.IntegerSize2D;
import com.sun.star.geometry.RealBezierSegment2D;
import com.sun.star.geometry.RealPoint2D;
import com.sun.star.geometry.RealSize2D;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.rendering.XBezierPolyPolygon2D;
import com.sun.star.rendering.XBitmap;
import com.sun.star.rendering.XBufferController;
import com.sun.star.rendering.XColorSpace;
import com.sun.star.rendering.XGraphicDevice;
import com.sun.star.rendering.XLinePolyPolygon2D;
import com.sun.star.rendering.XParametricPolyPolygon2DFactory;
import com.sun.star.rendering.XVolatileBitmap;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;

public class CanvasGraphicDevice
extends ComponentBase
implements XServiceInfo,
XPropertySet,
XGraphicDevice {
    private Graphics2D graphics;
    private GraphicsConfiguration graphicsConfig;
    private static final String s_implName = "XGraphicsDevice.java.impl";
    private static final String s_serviceName = "com.sun.star.rendering.GraphicsDevice";

    public CanvasGraphicDevice(Graphics2D graphics2D) {
        this.graphics = graphics2D;
        this.graphicsConfig = this.graphics.getDeviceConfiguration();
    }

    public synchronized XBufferController getBufferController() {
        CanvasUtils.printLog("CanvasGraphicDevice.getBufferController!");
        return null;
    }

    public synchronized XColorSpace getDeviceColorSpace() {
        CanvasUtils.printLog("CanvasGraphicDevice.getDeviceColorSpace!");
        return null;
    }

    public synchronized RealSize2D getPhysicalResolution() {
        CanvasUtils.printLog("CanvasGraphicDevice.getPhysicalResolution!");
        return new RealSize2D(100.0, 100.0);
    }

    public synchronized RealSize2D getPhysicalSize() {
        CanvasUtils.printLog("CanvasGraphicDevice.getSize!");
        Rectangle rectangle = this.graphicsConfig.getBounds();
        return new RealSize2D((double)rectangle.width, (double)rectangle.height);
    }

    public synchronized XLinePolyPolygon2D createCompatibleLinePolyPolygon(RealPoint2D[][] realPoint2DArray) {
        CanvasUtils.printLog("createCompatibleLinePolyPolygon");
        return new LinePolyPolygon(realPoint2DArray);
    }

    public synchronized XBezierPolyPolygon2D createCompatibleBezierPolyPolygon(RealBezierSegment2D[][] realBezierSegment2DArray) {
        CanvasUtils.printLog("createCompatibleBezierPolyPolygon");
        return new BezierPolyPolygon(realBezierSegment2DArray);
    }

    public synchronized XBitmap createCompatibleBitmap(IntegerSize2D integerSize2D) {
        CanvasUtils.printLog("createCompatibleBitmap called with size (" + integerSize2D.Width + ", " + integerSize2D.Height + ")");
        return new CanvasBitmap(this.graphicsConfig.createCompatibleImage(integerSize2D.Width, integerSize2D.Height, 1));
    }

    public synchronized XVolatileBitmap createVolatileBitmap(IntegerSize2D integerSize2D) {
        CanvasUtils.printLog("createVolatileBitmap called with size (" + integerSize2D.Width + ", " + integerSize2D.Height + ")");
        return null;
    }

    public synchronized XBitmap createCompatibleAlphaBitmap(IntegerSize2D integerSize2D) {
        CanvasUtils.printLog("createCompatibleBitmap called with size (" + integerSize2D.Width + ", " + integerSize2D.Height + ")");
        return new CanvasBitmap(this.graphicsConfig.createCompatibleImage(integerSize2D.Width, integerSize2D.Height, 3));
    }

    public synchronized XVolatileBitmap createVolatileAlphaBitmap(IntegerSize2D integerSize2D) {
        CanvasUtils.printLog("createVolatileBitmap called with size (" + integerSize2D.Width + ", " + integerSize2D.Height + ")");
        return null;
    }

    public synchronized XParametricPolyPolygon2DFactory getParametricPolyPolygonFactory() {
        return null;
    }

    public synchronized XPropertySetInfo getPropertySetInfo() {
        return null;
    }

    public synchronized void setPropertyValue(String string, Object object) throws PropertyVetoException {
        throw new PropertyVetoException();
    }

    public synchronized Object getPropertyValue(String string) throws UnknownPropertyException {
        if (string == "DeviceHandle") {
            return this.graphics;
        }
        throw new UnknownPropertyException();
    }

    public synchronized void addPropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException {
        if (string == "DeviceHandle") {
            return;
        }
        throw new UnknownPropertyException();
    }

    public synchronized void removePropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException {
        if (string == "DeviceHandle") {
            return;
        }
        throw new UnknownPropertyException();
    }

    public synchronized void addVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException {
        if (string == "DeviceHandle") {
            return;
        }
        throw new UnknownPropertyException();
    }

    public synchronized void removeVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException {
        if (string == "DeviceHandle") {
            return;
        }
        throw new UnknownPropertyException();
    }

    public synchronized boolean hasFullScreenMode() {
        return this.graphicsConfig.getDevice().isFullScreenSupported();
    }

    public synchronized boolean enterFullScreenMode(boolean bl) {
        return false;
    }

    public String getImplementationName() {
        return s_implName;
    }

    public String[] getSupportedServiceNames() {
        return new String[]{s_serviceName};
    }

    public boolean supportsService(String string) {
        return string.equals(s_serviceName);
    }
}

