/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.geometry.AffineMatrix2D;
import com.sun.star.geometry.RealPoint2D;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.rendering.RenderState;
import com.sun.star.rendering.ViewState;
import com.sun.star.rendering.XPolyPolygon2D;
import com.sun.star.rendering.XSprite;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class CanvasClonedSprite
extends ComponentBase
implements XSprite,
XServiceInfo,
SpriteBase {
    private JavaCanvas canvas;
    private double alpha;
    private Point2D.Double outputPosition;
    private SpriteRep spriteRep;
    private SpriteBase original;
    private static final String s_implName = "XSprite.java.impl";
    private static final String s_serviceName = "com.sun.star.rendering.Sprite";

    public CanvasClonedSprite(JavaCanvas javaCanvas, XSprite xSprite) {
        CanvasUtils.printLog("CanvasClonesSprite constructor called!");
        this.canvas = javaCanvas;
        if (xSprite instanceof SpriteBase) {
            this.original = (SpriteBase)xSprite;
        }
        this.alpha = 0.0;
        this.outputPosition = new Point2D.Double(0.0, 0.0);
    }

    public SpriteRep getSpriteRep() {
        if (this.spriteRep == null) {
            this.spriteRep = new SpriteRep(this.original.getSpriteRep());
            this.spriteRep.moveSprite(this.outputPosition);
            this.spriteRep.setSpriteAlpha(this.alpha);
        }
        return this.spriteRep;
    }

    public void dispose() {
        this.canvas = null;
        this.spriteRep = null;
        this.original = null;
        super.dispose();
    }

    public synchronized void setPriority(double d) {
    }

    public synchronized void setAlpha(double d) {
        this.alpha = d;
        if (this.spriteRep != null) {
            this.spriteRep.setSpriteAlpha(this.alpha);
        }
    }

    public synchronized void move(RealPoint2D realPoint2D, ViewState viewState, RenderState renderState) {
        AffineTransform affineTransform = CanvasUtils.ViewConcatRenderTransform(viewState, renderState);
        affineTransform.transform(new Point2D.Double(realPoint2D.X, realPoint2D.Y), this.outputPosition);
        if (this.spriteRep != null) {
            this.spriteRep.moveSprite(this.outputPosition);
        }
    }

    public synchronized void transform(AffineMatrix2D affineMatrix2D) throws IllegalArgumentException {
    }

    public synchronized void clip(XPolyPolygon2D xPolyPolygon2D) {
    }

    public synchronized void show() {
        this.canvas.showSprite(this);
        this.canvas.updateScreen(false);
    }

    public synchronized void hide() {
        this.canvas.hideSprite(this);
    }

    public String getImplementationName() {
        return s_implName;
    }

    public String[] getSupportedServiceNames() {
        return new String[]{s_serviceName};
    }

    public boolean supportsService(String string) {
        return string.equals(s_serviceName);
    }
}

