/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleRelation;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleText;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleEditableTextImpl;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.Component;

public class TextComponent
extends Component
implements Accessible {
    protected TextComponent(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleTextComponentListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleTextComponent();
    }

    protected class AccessibleTextComponent
    extends Component.AccessibleUNOComponent {
        protected AccessibleTextComponent() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleText getAccessibleText() {
            if (TextComponent.this.disposed) {
                return null;
            }
            try {
                XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)TextComponent.this.unoAccessibleComponent);
                if (xAccessibleText != null) {
                    return new AccessibleTextImpl(xAccessibleText);
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public AccessibleEditableText getAccessibleEditableText() {
            try {
                XAccessibleEditableText xAccessibleEditableText = (XAccessibleEditableText)UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)TextComponent.this.unoAccessibleComponent);
                if (xAccessibleEditableText != null) {
                    return new AccessibleEditableTextImpl(xAccessibleEditableText);
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public AccessibleAction getAccessibleAction() {
            try {
                XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)TextComponent.this.unoAccessibleComponent);
                return xAccessibleAction != null ? new AccessibleActionImpl(xAccessibleAction) : null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            try {
                XAccessibleRelationSet xAccessibleRelationSet = TextComponent.this.unoAccessible.getAccessibleContext().getAccessibleRelationSet();
                if (xAccessibleRelationSet == null) {
                    return super.getAccessibleRelationSet();
                }
                AccessibleRelationSet accessibleRelationSet = new AccessibleRelationSet();
                int n = xAccessibleRelationSet.getRelationCount();
                block11: for (int i = 0; i < n; ++i) {
                    AccessibleRelation accessibleRelation = xAccessibleRelationSet.getRelation(i);
                    switch (accessibleRelation.RelationType) {
                        case 3: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLED_BY, TextComponent.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 4: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLER_FOR, TextComponent.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 6: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.LABELED_BY, TextComponent.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 7: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.MEMBER_OF, TextComponent.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 2: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation("flowsTo", TextComponent.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 1: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation("flowsFrom", TextComponent.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            continue block11;
                        }
                    }
                }
                return accessibleRelationSet;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return super.getAccessibleRelationSet();
            }
            catch (RuntimeException runtimeException) {
                return super.getAccessibleRelationSet();
            }
        }
    }

    protected class AccessibleTextComponentListener
    extends Component.AccessibleUNOComponentListener {
        protected AccessibleTextComponentListener() {
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 6: {
                    TextComponent.this.fireStatePropertyChange(AccessibleState.EDITABLE, bl);
                    break;
                }
                case 17: {
                    TextComponent.this.fireStatePropertyChange(AccessibleState.MULTI_LINE, bl);
                    break;
                }
                case 26: {
                    break;
                }
                default: {
                    super.setComponentState(s, bl);
                }
            }
        }
    }
}

