<?php

// 2525ビューア Version2.2

// データをもらう
$videoid = htmlspecialchars($_GET['id']);
$videoheight = htmlspecialchars($_GET['height']);
if ($videoheight < 100)
{
	$videoheight = 100;
}
$videowidth = htmlspecialchars($_GET['width']);
if ($videowidth < 100)
{
	$videowidth = 100;
}


// XML 動画情報
$xml = file_get_contents("http://ext.nicovideo.jp/api/getthumbinfo/$videoid");
$xmlObject = simplexml_load_string($xml);

// XML 総カウント
$xml_total = file_get_contents("http://flapi.nicovideo.jp/api/getheadline");
$xmlObject_total = simplexml_load_string($xml_total);

// エラー処理
if ($videoid == "")
{
	error("IDが入力されていません！");
	exit;
}

if (!strstr($videoid, 'sm'))
{
	if (!strstr($videoid, 'nm'))
	{
		error("『sm』 or 『nm』 を入れて下さい！");
		exit;
	}
}


// ヘッダを挿入
head();

// --------------------

// ここにソースを書きます。
// --------------------


// IDは$videoid。
print <<<HTML
<p>動画IDは{$videoid}です。</p>
<hr />
<h2>動画</h2>
<script type="text/javascript" src="http://ext.nicovideo.jp/thumb_watch/{$videoid}?w={$videowidth}&h={$videoheight}"></script><noscript><a href="http://www.nicovideo.jp/watch/{$videoid}">【ニコニコ動画】</a>
</noscript>
<hr />
<h2>動画情報</h2>
HTML;

print "<table border=\"3\" style=\"text-align:center;margin:auto\" width=\"$videowidth\">\n";
print "<tr>\n";
print "<th>動画ID</th><th>動画タイトル</th><th>長さ</th>\n";
print "</tr>\n";
print "<tr>";
print "<td>\n";
print( (string)$xmlObject->thumb->video_id);
print "</td>\n";
print "<td>\n";
print( (string)$xmlObject->thumb->title);
print "</td>\n";
print "<td>\n";
print( (string)$xmlObject->thumb->length);
print "</td>\n";
print "</table>\n";

print "<table border=\"3\" style=\"text-align:center;margin:auto\" width=\"$videowidth\">\n";
print "<tr>\n";
print "<th>再生回数</th><th>コメント数</th><th>マイリスト数</th>\n";
print "</tr>\n";
print "<tr>";
print "<td>\n";
print( (string)$xmlObject->thumb->view_counter);
print "</td>\n";
print "<td>\n";
print( (string)$xmlObject->thumb->comment_num);
print "</td>\n";
print "<td>\n";
print( (string)$xmlObject->thumb->mylist_counter);
print "</td>\n";
print "</tr>";
print "</table>\n";

print "<table border=\"3\" style=\"text-align:center;margin:auto\" width=\"$videowidth\">\n";
print "<tr>\n";
print "<th>動画説明</th>\n";
print "</tr>\n";
print "<tr>";
print "<td>\n";
print( (string)$xmlObject->thumb->description);
print "</td>\n";
print "</tr>";
print "</table>\n";

print "<table border=\"3\" style=\"text-align:center;margin:auto\" width=\"$videowidth\">\n";
print "<tr>\n";
print "<th>新着コメント</th>\n";
print "</tr>\n";
print "<tr>";
print "<td>\n";
print( (string)$xmlObject->thumb->last_res_body);
print "</td>\n";
print "</tr>";
print "</table>\n";


print "<table border=\"3\" style=\"text-align: center; margin: auto\" width=\"$videowidth\">\n";
print "<tr>\n";
print "<th colspan=\"6\">タグ</th>";
print "</tr>\n";
print "<tr>";
$count = 0;
while ($count <= 5) {
	$tag_link = ( (string)$xmlObject->thumb->tags->tag[$count]);
	print "<td>\n<a href=\"http://dic.nicovideo.jp/a/$tag_link\" target=\"_blank\">\n";
	print( (string)$xmlObject->thumb->tags->tag[$count]);
	$count++;
	print "</a>\n</td>\n";
}
print "</tr>\n";
print "<tr>";

while ($count <= 10) {
	$tag_link = ( (string)$xmlObject->thumb->tags->tag[$count]);
	print "<td><a href=\"http://dic.nicovideo.jp/a/$tag_link\" target=\"_blank\">";
	print( (string)$xmlObject->thumb->tags->tag[$count]);
	$count++;
	print "</a></td>\n";
}
print "</tr>\n";
print "</table>\n";


// 埋め込み
print <<<HTML
<h3>埋め込み用タグ ◆外部プレイヤー◆</h3>
<textarea cols="70" rows="7">
&lt;script type=&quot;text/javascript&quot; src=&quot;http://ext.nicovideo.jp/thumb_watch/{$videoid}?w={$videowidth}&amp;h={$videoheight}&quot;&gt;
&lt;/script&gt;
&lt;noscript&gt;
&lt;a href=&quot;http://www.nicovideo.jp/watch/{$videoid}&quot;&gt;【ニコニコ動画】&lt;/a&gt;
&lt;/noscript&gt;
</textarea>
<h3>埋め込み用タグ ◆リンク◆</h3>
<textarea cols="70" rows="7">
&lt;iframe width=&quot;312&quot; height=&quot;176&quot; src=&quot;http://ext.nicovideo.jp/thumb/$videoid&quot; scrolling=&quot;no&quot; style=&quot;border:solid 1px #CCC;&quot; frameborder=&quot;0&quot;&gt;
&lt;a href=&quot;http://www.nicovideo.jp/watch/$videoid&quot;&gt;【ニコニコ動画】&lt;/a&gt;
&lt;/iframe&gt;
</textarea>
<h3>動画サムネイル</h3>
HTML;
print "<p><img src=\"";
print( (string)$xmlObject->thumb->thumbnail_url);
print "\"></p>";

// 投稿者情報

// IDセット
$user_id = $xmlObject->thumb->user_id;

print "<h3>投稿者情報</h3>\n<p>";
print "ID：";
print( (string)$xmlObject->thumb->user_id);
print "&nbsp;名前：";
print "<a href=\"http://www.nicovideo.jp/user/{$user_id}\" target=\"_blank\">";
print( (string)$xmlObject->thumb->user_nickname);
print "</a></p><p>";
$user_img = $xmlObject->thumb->user_icon_url;
print "<img src=\"{$user_img}\">";
print "</p>\n";

print <<<HTML
<hr />
<h2>リンク</h2>
<p><a href="http://www.nicovideo.jp/watch/{$videoid}" target="_blank">ニコニコ動画で見る！</a></p>
<p><a href="http://www.nicovideo.jp/user/{$user_id}" target="_blank">投稿者のプロフィール</a></p>
<p><a href="http://www.nicovideo.jp/" target="_blank">ニコニコTOP</a></p>
<p><a href="http://www.nicovideo.jp/video_top" target="_blank">ニコニコ動画TOP</a></p>
HTML;
print "<p>総動画数：";
print( (string)$xmlObject_total->total_video);
print "&nbsp;&nbsp;&nbsp;総再生回数：";
print( (string)$xmlObject_total->total_view);
print "&nbsp;&nbsp;&nbsp;総コメント数：";
print( (string)$xmlObject_total->total_res);
print "</p>";
print <<<HTML
<hr />
HTML;


// --------------------
// ソース ここまで

// フッタを挿入
foot();
// --------------------



// 以下、サブルーチン集

// ヘッダ処理
function head()
{
	print <<<HTML
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta name="viewport" content="width=device-width,initial-scale=1">
<meta name="Keywords" content="ニコニコ,2525,外部プレーヤ" />
<meta name="Description" content="ニコニコ動画の動画をアカウント無しで視聴できるウェブアプリケーション。" />
<style type="text/css">
body{
background: linear-gradient(#BFE6FB, #FFFFFF);
text-align: center;
}
</style>
<meta charset="UTF-8">
<title>2525ビューワ</title>
</head>
<body>
<p align="center"><a href="./">■戻る■</a></p>
HTML;
}

// --------------------

// フッタ処理
function foot()
{
	print <<<HTML
<p align="center"><a href="./">■戻る■</a></p>
<p align="right">Cording by Light.<a href="http://light-tv.club/">LIGHT-TV</a></p>
</body>
</html>
HTML;
}
// --------------------

// エラー処理
function error($mes)
{
head();
	print <<<HTML
<h2>エラー！</h2>
<p><span style="color: red;font-size: xx-large"><strong>$mes</strong></span></p>
<hr>
<h2>エラーが発生するとでるメッセージ集</h2>
<h3>IDが入力されていません！</h3>
<p>IDが空白だとこうなります。見るにはIDを入れて下さい。</p>
<h3>『sm』 or 『nm』 を入れて下さい！</h3>
<p>ニコニコ動画の動画の99%が『sm』と『nm』で投稿されている、</p>
<p>また、それ以外は外部プレイヤーに対応しないなどの理由で</p>
<p>かならず『sm』か『nm』が入っていないと再生できません…</p>
HTML;
foot();
}
// --------------------

?>