﻿using System;
using System.Diagnostics;
using System.Windows;
using System.Windows.Interop;
using System.Windows.Media;
using Forms = System.Windows.Forms;
using System.Collections.Generic;

namespace JoinNotes
{
    /// <summary>
    /// NotifyTray.xaml の相互作用ロジック
    /// </summary>
    public partial class NotifyTray : Window
    {
        Forms.NotifyIcon notifyIcon;
        Forms.ContextMenuStrip menuStrip;
        Forms.ToolStripMenuItem searchToolStripMenuItem;
        Forms.ToolStripMenuItem editorToolStripMenuItem;
        Forms.ToolStripMenuItem configToolStripMenuItem;
        Forms.ToolStripMenuItem exitToolStripMenuItem;
        Forms.ToolStripMenuItem aboutToolStripMenuItem;

        public NotifyTray()
        {
            InitializeComponent();

            //FIXME: タイプイニシャライザーで定義
            Application.HotKeyId["ActivateHotKey"] = 0;
            Application.HotKeyId["OpenWindowHotKey"] = 1;
            Application.HotKey["ActivateHotKey"] = null;
            Application.HotKey["OpenWindowHotKey"] = null;

            this.Unloaded += new RoutedEventHandler(NotifyTray_Unloaded);
            this.Closed += new EventHandler(NotifyTray_Closed);
            this.AllowsTransparency = true;
            this.Background = Brushes.Transparent;
            this.WindowStyle = System.Windows.WindowStyle.None;
            this.ShowInTaskbar = false;
            this.Title = Application.NotifyContainerTitle;

            var components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(NotifyTray));

            this.notifyIcon = new Forms.NotifyIcon(components);
            this.menuStrip = new Forms.ContextMenuStrip(components);
            this.searchToolStripMenuItem = new Forms.ToolStripMenuItem();
            this.editorToolStripMenuItem = new Forms.ToolStripMenuItem();
            this.configToolStripMenuItem = new Forms.ToolStripMenuItem();
            this.exitToolStripMenuItem = new Forms.ToolStripMenuItem();
            this.aboutToolStripMenuItem = new Forms.ToolStripMenuItem();

            // 
            // notifyIcon
            // 
            this.notifyIcon.BalloonTipText = "動いています";
            this.notifyIcon.BalloonTipTitle = "JoinNotes";
            this.notifyIcon.ContextMenuStrip = this.menuStrip;
            this.notifyIcon.Icon = ((System.Drawing.Icon)(Properties.Resources.ResourceManager.GetObject("notifyIcon")));
            this.notifyIcon.Text = Application.AssemblyInfo.ProductName;
            this.notifyIcon.Visible = true;
            this.notifyIcon.MouseClick += new Forms.MouseEventHandler(notifyIcon_MouseClick);
            //this.notifyIcon.MouseDoubleClick += new System.Windows.Forms.MouseEventHandler(this.notifyIcon_MouseDoubleClick);

            // 
            // searchToolStripMenuItem
            // 
            this.searchToolStripMenuItem.Name = "searchToolStripMenuItem";
            this.searchToolStripMenuItem.ShortcutKeyDisplayString = "";
            this.searchToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.searchToolStripMenuItem.Text = "全文検索ウィンドウを開く(&F)";
            this.searchToolStripMenuItem.Click += new EventHandler(searchToolStripMenuItem_Click);
            // 
            // editorToolStripMenuItem
            // 
            this.editorToolStripMenuItem.Name = "editorToolStripMenuItem";
            //this.searchToolStripMenuItem.ShortcutKeyDisplayString = "";
            //this.searchToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.editorToolStripMenuItem.Text = "新しい編集ウィンドウを開く(&N)";
            this.editorToolStripMenuItem.Click += new EventHandler(editorToolStripMenuItem_Click);
            // 
            // configToolStripMenuItem
            // 
            this.configToolStripMenuItem.Name = "configToolStripMenuItem";
            //this.searchToolStripMenuItem.ShortcutKeyDisplayString = "";
            //this.searchToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.configToolStripMenuItem.Text = "設定ウィンドウを開く(&O)";
            this.configToolStripMenuItem.Click += new EventHandler(this.configToolStripMenuItem_Click);
            // 
            // aboutToolStripMenuItem
            // 
            this.aboutToolStripMenuItem.Name = "aboutToolStripMenuItem";
            //this.searchToolStripMenuItem.ShortcutKeyDisplayString = "";
            //this.searchToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.aboutToolStripMenuItem.Text = "JoinNotesについて(&A)";
            this.aboutToolStripMenuItem.Click += new System.EventHandler(this.aboutToolStripMenuItem_Click);
            // 
            // exitToolStripMenuItem
            // 
            this.exitToolStripMenuItem.Name = "exitToolStripMenuItem";
            //this.searchToolStripMenuItem.ShortcutKeyDisplayString = "";
            //this.searchToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.exitToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Alt | System.Windows.Forms.Keys.F4)));
            this.exitToolStripMenuItem.Text = "常駐解除・終了(&X)";
            this.exitToolStripMenuItem.Click += new EventHandler(this.exitToolStripMenuItem_Click);

            // 
            // contextMenuStrip1
            // 
            this.menuStrip.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
                this.searchToolStripMenuItem,
                this.editorToolStripMenuItem,
                this.configToolStripMenuItem,
                this.aboutToolStripMenuItem,
                new Forms.ToolStripSeparator(),
                this.exitToolStripMenuItem,
            });
            this.menuStrip.Name = "contextMenuStrip1";
            this.menuStrip.Size = new System.Drawing.Size(153, 142);
            //this.menuStrip.Opening += new System.ComponentModel.CancelEventHandler(this.menuStrip_Opening);
        }

        static IntPtr WndProc(IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam, ref bool handled)
        {
            Debug.WriteLine(msg.ToString(), "NotifyTray:WndProc");

            if (msg == Application.WM_APP_ACTIVATEAPP)
            {
                Application.Instance.InvokeStartupTask();
                handled = true;
            }

            if (msg == Application.WM_HOTKEY && lParam != null && Application.HotKey["ActivateHotKey"] != null && lParam == Application.HotKey["ActivateHotKey"].LParam)
            {
                Application.SwitchApplicationVisibility();
                handled = true;
            }
            else if (msg == Application.WM_HOTKEY && lParam != null && Application.HotKey["OpenWindowHotKey"] != null && lParam == Application.HotKey["OpenWindowHotKey"].LParam)
            {
                Application.ActivateWindows();
                ShowStartupWindow();
                handled = true;
            }

            return IntPtr.Zero;
        }

        static void ShowStartupWindow()
        {
            var startup = Properties.Settings.Default.StartupWindowClassName;

            var window = Application.Instance.GetWindow(startup);
            window.Show();
            window.Activate();

            if (window is Editor)
                Application.Instance.UntitledEditorWindows.Add((Editor)window);
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            // † http://csfun.blog49.fc2.com/blog-entry-93.html
            HwndSource source = HwndSource.FromHwnd(new WindowInteropHelper(this).Handle);
            source.AddHook(new HwndSourceHook(WndProc));
        }

        void NotifyTray_Closed(object sender, EventArgs e)
        {
            Application.mainWindow = null;
            //FIXME: 適切なイベントハンドラーで実行
            this.notifyIcon.Dispose();
        }

        void NotifyTray_Unloaded(object sender, RoutedEventArgs e)
        {
            // 実行されない
            throw new NotImplementedException();
        }

        void editorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Instance.GetWindow(typeof(Editor).Name).Show();
        }

        void searchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Instance.GetWindow(typeof(Search).Name).Show();
        }

        void configToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Instance.GetWindow(typeof(Config).Name).Show();
        }

        void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Instance.Shutdown();
        }

        void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new AboutBox1().ShowDialog();
        }

        void notifyIcon_MouseClick(object sender, Forms.MouseEventArgs e)
        {
            if (e.Button == Forms.MouseButtons.Left)
                Application.SwitchApplicationVisibility();
            else if (e.Button == Forms.MouseButtons.Right)
                ShowNotifyTrayMenu();
        }

        public void ShowNotifyTrayMenu()
        {
            this.menuStrip.Show();
        }

        public void ShowNotifyTrayMenu(Point position)
        {
            this.menuStrip.Show((int)position.X, (int)position.Y);
        }

    }
}
