#!/bin/sh
# Copyright (C) 2022 Jone Bontus
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# ``Software''), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.	IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

set -e

QEMU_VERSION=4.2.0

PREFIX=$(pwd)/qemu

if [ ! -d "qemu-$QEMU_VERSION" ]; then
    # wget https://download.qemu.org/qemu-$QEMU_VERSION.tar.xz
    tar -xJf qemu-$QEMU_VERSION.tar.xz
fi
patch --no-backup-if-mismatch --remove-empty-files --fuzz=0 --forward --strip=0 --reject-file=- < qemu-$QEMU_VERSION.diff
cd qemu-$QEMU_VERSION
if [ ! -e "config-host.mak" ]; then
    ./configure --target-list=aarch64-softmmu,arm-softmmu --prefix=$PREFIX
fi
make
make install
dtc --in-format dts --out pc-bios/syborg.dtb pc-bios/syborg.dts
