package jp.nanah.bastub.data;

import java.util.ArrayList;
import java.util.List;

/**
 * フィルタ条件の１行分のデータ
 */
public class FilterParam {

	/**
	 * データシートの列名
	 */
	private String columnName;

	/**
	 * 比較条件
	 */
	private String compareType;

	/**
	 * 条件値を持つ要求パラメータのキー値
	 */
	private List<String> requestKeys = new ArrayList<String>();

	/**
	 * 比較する条件値。リスト内はOR条件。
	 */
	private List<String> values;

	public FilterParam (String cellName, String compType, List<String> paramKey) {
		this.columnName = cellName;
		this.compareType = compType;
		this.requestKeys = paramKey;
	}

	public String getColumnName() {
		return columnName;
	}

	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}

	public String getCompareType() {
		return compareType;
	}

	public void setCompareType(String compareType) {
		this.compareType = compareType;
	}

	/**
	 * HTTPの要求パラメータの場合はリスト長は1だが、
	 * JSONで要求しているときは階層で指定するためリスト長は1以上になる
	 * @return
	 */
	public List<String> getRequestKeys() {
		return requestKeys;
	}

	public void setRequestKeys(List<String> requestKeys) {
		this.requestKeys = requestKeys;
	}

	public List<String> getValues() {
		return values;
	}

	public void setValues(List<String> values) {
		this.values = values;
	}

	public void setOneValue(String values) {
		List<String> list = new ArrayList<String>();
		list.add(values);
		setValues(list);
	}

}
