/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nanah.bastub.data.FilterParam;
import jp.nanah.bastub.data.JsonInfo;
import jp.nanah.bastub.data.KvData;
import jp.nanah.bastub.service.JsonService;
import jp.nanah.bastub.util.BastubUtils;
import nanah.oslib.ResUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AnyRestController {
    private static final Logger logger = LoggerFactory.getLogger(AnyRestController.class);
    @Autowired
    private JsonService jsonService;
    private static String APP_SNO = Long.toString(System.currentTimeMillis() / 1000L, 36).toUpperCase();
    private static long reqNo = 0L;
    @Value(value="${pagedata.root:pagedata}")
    private String pagedataPath;
    private Map<String, Object[]> workbookCache = new TreeMap<String, Object[]>();

    @RequestMapping(path={"/{p1}", "{p1}/{p2}", "{p1}/{p2}/{p3}", "{p1}/{p2}/{p3}/{p4}", "{p1}/{p2}/{p3}/{p4}/{p5}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}/{p9}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}/{p9}/{p10}"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE}, produces={"application/json"})
    public String path1(@PathVariable(value="p1") Optional<String> p1, @PathVariable(value="p2") Optional<String> p2, @PathVariable(value="p3") Optional<String> p3, @PathVariable(value="p4") Optional<String> p4, @PathVariable(value="p5") Optional<String> p5, @PathVariable(value="p6") Optional<String> p6, @PathVariable(value="p7") Optional<String> p7, @PathVariable(value="p8") Optional<String> p8, @PathVariable(value="p9") Optional<String> p9, @PathVariable(value="p10") Optional<String> p10, @RequestBody(required=false) ModelMap body, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        return this.path_common(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, (Map)body, model, req, res);
    }

    @RequestMapping(path={"/{p1}", "{p1}/{p2}", "{p1}/{p2}/{p3}", "{p1}/{p2}/{p3}/{p4}", "{p1}/{p2}/{p3}/{p4}/{p5}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}/{p9}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}/{p9}/{p10}"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE}, consumes={"application/x-www-form-urlencoded"}, produces={"application/json"})
    public String path1_multipart(@PathVariable(value="p1") Optional<String> p1, @PathVariable(value="p2") Optional<String> p2, @PathVariable(value="p3") Optional<String> p3, @PathVariable(value="p4") Optional<String> p4, @PathVariable(value="p5") Optional<String> p5, @PathVariable(value="p6") Optional<String> p6, @PathVariable(value="p7") Optional<String> p7, @PathVariable(value="p8") Optional<String> p8, @PathVariable(value="p9") Optional<String> p9, @PathVariable(value="p10") Optional<String> p10, @RequestParam(required=false) Map<String, String> paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        return this.path_common(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, paramMap, model, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String path_common(Optional<String> p1, Optional<String> p2, Optional<String> p3, Optional<String> p4, Optional<String> p5, Optional<String> p6, Optional<String> p7, Optional<String> p8, Optional<String> p9, Optional<String> p10, Map paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        String string = APP_SNO;
        synchronized (string) {
            Thread.currentThread().setName(APP_SNO + "_" + reqNo);
            ++reqNo;
        }
        logger.info("== \u25bc == [{}] {}", (Object)req.getMethod(), (Object)req.getRequestURL().toString());
        res.setContentType("application/json;charset=UTF-8");
        List<String> pathList = BastubUtils.toValidList(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);
        String result = this.getAny(pathList, paramMap, model, req, res);
        logger.info("== \u25b3 ==");
        return result;
    }

    public String getAny(List<String> pathList, Map body, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        try {
            logger.debug("   PathList-->" + pathList);
            logger.debug("   Body    -->" + body);
            logger.debug("   QueryString: " + req.getQueryString());
            File pageDir = new File(this.pagedataPath);
            if (!pageDir.isAbsolute()) {
                File appRoot = ResUtils.getRootDirAs(this.getClass());
                logger.debug("appRoot-->[{}], pagedataPath=[{}]", (Object)appRoot, (Object)this.pagedataPath);
                pageDir = new File(appRoot, this.pagedataPath);
            }
            pageDir = pageDir.getCanonicalFile();
            String path = StringUtils.join(pathList, (String)"/");
            File dataFile = BastubUtils.getPagedataPath(pageDir, path, req.getMethod(), ".xls");
            File jsonFile = BastubUtils.getPagedataPath(pageDir, path, req.getMethod(), ".json");
            logger.debug("dataPath={}, jsonFile={}", (Object)dataFile.getAbsolutePath(), (Object)jsonFile.getAbsolutePath());
            Sheet paramSheet = null;
            Sheet dataSheet = null;
            Workbook wb = this.readWorkbook(dataFile);
            if (wb == null) {
                logger.warn("\u56fa\u5b9a\u5fdc\u7b54 ([{}])", (Object)jsonFile.getAbsolutePath());
            } else {
                paramSheet = wb.getSheet("filter");
                dataSheet = wb.getSheet("data");
                wb.close();
                if (paramSheet == null) {
                    logger.debug("\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb[{}]\u306b[filter]\u30b7\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", (Object)dataFile.getAbsolutePath());
                }
                if (dataSheet == null) {
                    logger.debug("\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb[{}]\u306b[data]\u30b7\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", (Object)dataFile.getAbsolutePath());
                }
            }
            this.trimDataSheet(dataSheet);
            logger.debug("\u25a0\uff11");
            List<KvData> requestData = this.getRequestData(req.getParameterMap(), body);
            logger.debug("\u25a0\uff12");
            List<FilterParam> allFilter = this.getFilterParamList(paramSheet);
            List<FilterParam> validFilter = null;
            if (allFilter != null) {
                validFilter = this.getValidFilter(allFilter, requestData, pathList);
            }
            logger.debug("\u25a0\uff13");
            List<Row> resultTarget = this.pickupSheetData(dataSheet, validFilter);
            logger.debug("\u25a0\uff14");
            JsonInfo jsonInfo = this.jsonService.readJsonFile(jsonFile);
            if (jsonInfo.getJsonObject() == null) {
                res.setStatus(404);
                String jsonPath = jsonFile.getAbsolutePath();
                logger.warn("\u25c6 \u5fdc\u7b54JSON\u7121\u3057 path={}", (Object)jsonPath);
                String errorJson = "no_file - " + jsonPath.replaceAll("\\\\", "/") + "]";
                return errorJson;
            }
            logger.debug("\u25a0\uff15");
            JSONObject responseJSson = this.jsonService.buildResponseJson(jsonInfo.getJsonObject(), resultTarget);
            String jsonText = responseJSson.toString(4);
            if (jsonInfo.isTopArray()) {
                int n1 = jsonText.indexOf(":");
                int n2 = jsonText.lastIndexOf("}");
                jsonText = jsonText.substring(n1 + 1, n2);
            }
            logger.debug("\u5fdc\u7b54\u30c7\u30fc\u30bf:{}", (Object)jsonText);
            res.addHeader("Access-Control-Allow-Origin", "*");
            return jsonText;
        }
        catch (Throwable th) {
            th.printStackTrace();
            return th.toString();
        }
    }

    protected synchronized Workbook readWorkbook(File file) throws IOException {
        Long filetime;
        if (!file.exists()) {
            return null;
        }
        String key = file.getAbsolutePath();
        Object[] cache = this.workbookCache.get(key);
        if (cache != null && (filetime = (Long)cache[0]).longValue() == file.lastModified()) {
            return (Workbook)cache[1];
        }
        Workbook wb = WorkbookFactory.create((File)file, null, (boolean)true);
        this.workbookCache.put(key, new Object[]{file.lastModified(), wb});
        return wb;
    }

    protected void trimDataSheet(Sheet sheet) {
        Cell cell;
        String s;
        int lastColNum;
        if (sheet == null || sheet.getLastRowNum() == 0) {
            return;
        }
        Row topRow = sheet.getRow(0);
        for (lastColNum = topRow.getLastCellNum() - 1; lastColNum >= 0 && !StringUtils.isNotBlank((CharSequence)(s = BastubUtils.getCellText(cell = topRow.getCell(lastColNum)))); --lastColNum) {
        }
        logger.debug("\u30c7\u30fc\u30bf\u30b7\u30fc\u30c8\u306e\u6700\u7d42\u5217={}-->{}", (Object)topRow.getLastCellNum(), (Object)lastColNum);
        for (int rowNum = sheet.getLastRowNum(); rowNum >= 0; --rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            if (BastubUtils.isBlankRow(row)) {
                sheet.removeRow(row);
                continue;
            }
            for (int i = row.getLastCellNum() - 1; i > lastColNum; --i) {
                Cell cell2 = row.getCell(i);
                if (cell2 == null) continue;
                row.removeCell(cell2);
            }
        }
    }

    public List<KvData> getRequestData(Map<String, String[]> paramMap, Map body) {
        ArrayList<KvData> paramList = new ArrayList<KvData>();
        if (paramMap != null) {
            int cnt = 0;
            for (Map.Entry<String, String[]> ent : paramMap.entrySet()) {
                List<String> key = Arrays.asList(ent.getKey());
                for (String val : ent.getValue()) {
                    KvData kv = this.appendKvParam(new KvData(key, val), paramList);
                    logger.info("query[{}]: {}={}", new Object[]{cnt, StringUtils.join((Object[])new List[]{kv.getKey()}), val});
                    ++cnt;
                }
            }
        }
        if (body != null) {
            int startSize = paramList.size();
            this.appendEntryToParamList(body.entrySet(), null, paramList);
            for (int i = startSize; i < paramList.size(); ++i) {
                KvData kv = (KvData)paramList.get(i);
                logger.info("body[{}]: {}={}", new Object[]{i, StringUtils.join((Object[])new List[]{kv.getKey()}), kv.getValues()});
            }
        }
        return paramList;
    }

    private KvData appendKvParam(KvData src, List<KvData> dstList) {
        KvData nowval = null;
        for (int i = 0; i < dstList.size(); ++i) {
            if (!BastubUtils.equals(dstList.get(i).getKey(), src.getKey())) continue;
            nowval = dstList.get(i);
            break;
        }
        if (nowval == null) {
            dstList.add(src);
            nowval = src;
        } else {
            nowval.addValue(src.getValueAsOne());
        }
        return nowval;
    }

    private void appendEntryToParamList(Set<Map.Entry<String, Object>> set, List<String> parentKeys, List<KvData> paramList) {
        int count = 0;
        for (Map.Entry<String, Object> ent : set) {
            String key = ent.getKey();
            Object val = ent.getValue();
            ArrayList<String> thisKeys = new ArrayList<String>();
            if (parentKeys != null) {
                thisKeys.addAll(parentKeys);
            }
            thisKeys.add(key);
            if (val instanceof Map) {
                Map vmap = (Map)val;
                this.appendEntryToParamList(vmap.entrySet(), thisKeys, paramList);
            } else if (val instanceof List) {
                List vlist = (List)val;
                this.appendListToParamList(vlist, thisKeys, paramList);
            } else {
                this.appendToParamList(val, thisKeys, paramList);
            }
            ++count;
        }
    }

    private void appendListToParamList(List<Object> list, List<String> parentKeys, List<KvData> paramList) {
        for (Object o : list) {
            if (o instanceof Map) {
                Map map = (Map)o;
                this.appendEntryToParamList(map.entrySet(), parentKeys, paramList);
                continue;
            }
            if (o instanceof List) {
                List vlist = (List)o;
                this.appendListToParamList(vlist, parentKeys, paramList);
                continue;
            }
            this.appendToParamList(o, parentKeys, paramList);
        }
    }

    private void appendToParamList(Object obj, List<String> parentKeys, List<KvData> paramList) {
        String valstr = obj.toString();
        KvData kv = new KvData(parentKeys, valstr);
        this.appendKvParam(kv, paramList);
    }

    private List<String> createKey(List<String> parentKeys, String key) {
        ArrayList<String> newList = new ArrayList<String>();
        newList.addAll(parentKeys);
        newList.add(key);
        return newList;
    }

    private List<FilterParam> getFilterParamList(Sheet sheet) {
        ArrayList<FilterParam> filterList = null;
        if (sheet == null) {
            return filterList;
        }
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            List<String> cellList = BastubUtils.getRowValueList(row, false);
            if (cellList.size() < 3) continue;
            if (filterList == null) {
                filterList = new ArrayList<FilterParam>();
            }
            String cellName = cellList.get(0);
            String compType = cellList.get(1);
            List<String> paramKey = cellList.subList(2, cellList.size());
            FilterParam fp = new FilterParam(cellName, compType, paramKey);
            filterList.add(fp);
            logger.debug("[" + i + "] FilterParam: cell={}, type={}, keys={}", new Object[]{fp.getColumnName(), fp.getCompareType(), StringUtils.join(fp.getRequestKeys(), (String)"-")});
        }
        return filterList;
    }

    public List<FilterParam> getValidFilter(List<FilterParam> filterParamList, List<KvData> requestData, List<String> pathList) {
        ArrayList<FilterParam> validList = new ArrayList<FilterParam>();
        for (FilterParam fp : filterParamList) {
            String key0;
            logger.debug("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u30ad\u30fc ==>>>:" + StringUtils.join(fp.getRequestKeys(), (String)"."));
            if (fp.getRequestKeys().size() > 0 && (key0 = fp.getRequestKeys().get(0)).startsWith("$")) {
                int pathNumber = NumberUtils.toInt((String)key0.substring(1));
                logger.debug("\u30d1\u30b9\u7f6e\u304d\u63db\u3048\uff1f\uff1a\u30a4\u30f3\u30c7\u30c3\u30af\u30b9={}", (Object)pathNumber);
                if (pathNumber > 0 && pathNumber <= pathList.size()) {
                    fp.setOneValue(pathList.get(pathNumber - 1));
                    logger.debug("\u30d1\u30b9\u7f6e\u304d\u63db\u3048\uff1a" + fp.getValues());
                    validList.add(fp);
                    continue;
                }
            }
            List<String> reqKey = fp.getRequestKeys();
            logger.debug("@@@@ reqKey=[{}] size=[{}]", reqKey, (Object)requestData.size());
            boolean isFound = false;
            String delimText = this.getDelimText(fp.getCompareType());
            for (KvData kv : requestData) {
                logger.debug("@@@@ kv.getKey()=[{}] ", kv.getKey());
                if (!BastubUtils.equalsTail(kv.getKey(), reqKey)) continue;
                List<String> fpValues = this.toFilterValue(delimText, kv.getValues());
                fp.setValues(fpValues);
                logger.debug("\u25ce \u4e00\u81f4!! key=[{}] value=[{}]", (Object)fp.getColumnName(), fp.getValues());
                validList.add(fp);
                isFound = true;
            }
            if (!isFound) {
                logger.warn("HTTP\u30ea\u30af\u30a8\u30b9\u30c8\u5185\u306b\u3001\u9805\u76ee\u5024[{}]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", reqKey);
            }
            if (delimText == null) continue;
            fp.setCompareType("=");
        }
        return validList;
    }

    private String getDelimText(String compareType) {
        int n1 = compareType.indexOf("[");
        int n2 = compareType.indexOf("]");
        if (n1 < 0 || n2 < 0) {
            return null;
        }
        String delim = compareType.substring(n1 + 1, n2);
        return delim;
    }

    private List<String> toFilterValue(String delimText, List<String> org) {
        if (delimText == null) {
            return org;
        }
        ArrayList<String> dst = new ArrayList<String>();
        for (String s : org) {
            dst.addAll(Arrays.asList(s.split(delimText, 0)));
        }
        return dst;
    }

    public List<Row> pickupSheetData(Sheet sheet, List<FilterParam> validFilter) {
        int i;
        ArrayList<Row> noDatasheet = new ArrayList<Row>();
        if (sheet == null) {
            return noDatasheet;
        }
        ArrayList<Row> sheetData = new ArrayList<Row>();
        for (int i2 = sheet.getFirstRowNum(); i2 <= sheet.getLastRowNum(); ++i2) {
            Row row = sheet.getRow(i2);
            if (row == null) continue;
            sheetData.add(sheet.getRow(i2));
            logger.debug("[{}] \u884c\u30c7\u30fc\u30bf\u3092\u8ffd\u52a0... [{}]", (Object)i2, BastubUtils.getRowValueList(sheet.getRow(i2), true));
        }
        if (validFilter == null || validFilter.isEmpty()) {
            return sheetData;
        }
        for (FilterParam fp : validFilter) {
            logger.debug("Filter: {},{}", (Object)fp.getColumnName(), fp.getValues());
        }
        Object[] columnNames = this.getColumnNames(sheet);
        for (FilterParam fp : validFilter) {
            int columnIndex = ArrayUtils.indexOf((Object[])columnNames, (Object)fp.getColumnName());
            if (columnIndex < 0) {
                logger.warn("***** data\u30b7\u30fc\u30c8\u306b\u3001\u5217\u540d[{}]\u304c\u3042\u308a\u307e\u305b\u3093\u3002", (Object)fp.getColumnName());
                continue;
            }
            logger.debug("\u5217\u540d[{}]-->\u30c7\u30fc\u30bf\u30b7\u30fc\u30c8\u306e[{}]\u5217\u76ee", (Object)fp.getColumnName(), (Object)columnIndex);
            for (i = 1; i < sheetData.size(); ++i) {
                Row row = (Row)sheetData.get(i);
                if (row == null) {
                    logger.debug("\u524a\u9664\u6e08\u307f\u306e\u884c\u306f\u30b9\u30ad\u30c3\u30d7:[{}]", (Object)i);
                    continue;
                }
                Cell cell = row.getCell(columnIndex);
                String v = BastubUtils.getCellText(cell);
                if (v == null) continue;
                boolean isMatch = false;
                String ct = fp.getCompareType();
                for (String fv : fp.getValues()) {
                    int n = v.compareTo(fv);
                    if (ct.equals("=")) {
                        isMatch = n == 0;
                    } else if (ct.equals("<")) {
                        isMatch = n < 0;
                    } else if (ct.equals("<=")) {
                        isMatch = n <= 0;
                    } else if (ct.equals(">")) {
                        isMatch = n > 0;
                    } else if (ct.equals(">=")) {
                        boolean bl = isMatch = n >= 0;
                    }
                    if (!isMatch) continue;
                    logger.debug("\u4e00\u81f4\u5224\u5b9a[{}]: [{}]{}[{}]] ===> n={}, isMatch={}", new Object[]{i, v, fp.getCompareType(), fv, n, isMatch});
                    break;
                }
                if (isMatch) continue;
                sheetData.set(i, null);
                logger.debug("\u30a2\u30f3\u30de\u30c3\u30c1\u306e\u305f\u3081\u9664\u5916:[{}] [{}]<-->[{}]", new Object[]{i, fp.getValues(), v});
            }
        }
        sheetData.removeAll(Collections.singleton(null));
        for (Row row : sheetData) {
            StringBuilder sb = new StringBuilder();
            for (i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(BastubUtils.getCellText(row.getCell(i)));
            }
            logger.debug("[{}]=[{}]", (Object)row.getRowNum(), (Object)sb.toString());
        }
        return sheetData;
    }

    private String[] getColumnNames(Sheet sheet) {
        Row row = sheet.getRow(sheet.getFirstRowNum());
        String[] columns = new String[row.getLastCellNum()];
        for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
            columns[i] = BastubUtils.getCellText(row.getCell(i));
            logger.debug("\u5217\u540d[{}]={}", (Object)i, (Object)columns[i]);
        }
        return columns;
    }
}

