/*
 * Decompiled with CFR 0.152.
 */
package nanah.oslib;

import java.io.File;
import java.net.URL;

public class ResUtils {
    private static Class targetClass = ResUtils.class;

    public static void setTarget(Object obj) {
        ResUtils.setTargetClass(obj.getClass());
    }

    public static void setTargetClass(Class klass) {
        targetClass = klass;
    }

    public static File getRootDir() {
        return ResUtils.getRootDirAs(targetClass);
    }

    public static File getRootDirAs(Class klass) {
        URL url = klass.getResource(String.valueOf(klass.getSimpleName()) + ".class");
        String klassPath = url.getFile();
        boolean isJar = klassPath.startsWith("file:/");
        String path = isJar ? klassPath.substring(6) : klassPath;
        File file = new File(path).getParentFile();
        String[] packages = klass.getPackage().getName().split("\\.");
        int i = 0;
        while (i < packages.length) {
            file = file.getParentFile();
            ++i;
        }
        if (isJar) {
            file = file.getParentFile();
        }
        return file;
    }

    public static File getRelativeFile(File dir, String path) {
        File base = dir == null ? ResUtils.getRootDir() : dir;
        File target = new File(base, path);
        return target;
    }
}

