#include "tcl.h"
#include "tk.h"

#include "TTW.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#include <locale.h>
#include <stdlib.h>
#include <tchar.h>

#include <cstdio>
#include <string>

extern "C" {
int Vfs_Init(Tcl_Interp *);
int Memchan_Init(Tcl_Interp *);
int Blt_Init(Tcl_Interp *);
int Tkhtml_Init(Tcl_Interp *);
void TkWinSetHINSTANCE(HINSTANCE hInstance);
}

std::string read_vfs_script(const char *tarfile){
	if (!tarfile) return "";
	FILE *fp = std::fopen(tarfile, "rb");
	if (!fp) return "";

	std::string script;
	char buf[513];
	buf[512] = '\0';
	int datablocks = 0;
	long filesize = 0;
	bool add_to_script = false;
	while(!std::feof(fp)){
		if (datablocks == 0){ // header
			size_t sz = fread(buf, 512, 1, fp);
			char typeflag = buf[156];
			switch(typeflag){
				case '1': case '2': case '3': case '4': case '5': case '6': case '7':
				continue;
			}
			filesize = std::strtol(buf + 124, 0, 8);
			datablocks = (filesize + 511) / 512;
			add_to_script = (std::strstr(buf, "vfs1.3/tarvfs.tcl") != 0) || (std::strstr(buf, "vfs1.3/vfsUtils.tcl") != 0);
		}else if (add_to_script){
			size_t sz = std::fread(buf, 512, 1, fp);
			--datablocks;
			if (!add_to_script) continue;
			if (filesize < 512) buf[filesize] = '\0';
			script += buf;
			filesize -= 512;
		}else{
			std::fseek(fp, datablocks * 512, SEEK_CUR);
			datablocks = filesize = 0;
		}
	}

	std::fclose(fp);
	return script;
}

void LoadTarRT(Tcl_Interp *interp, const char *exedir_){
	int rc;
	::Tcl_StaticPackage(interp, "Tcl", Tcl_Init, 0);
	::Tcl_StaticPackage(interp, "Tk", Tk_Init, 0);
	::Tcl_StaticPackage(interp, "vfs", Vfs_Init, 0);
	::Tcl_StaticPackage(interp, "memchan", Memchan_Init, 0);

	::TkWinSetHINSTANCE(::GetModuleHandle("OSSLibs.dll"));
	// st@C̃fBNg擾
	std::string exedir = exedir_;
	for (size_t i = 0; i < exedir.size(); ++i) if (exedir[i] == '\\') exedir[i] = '/';
	exedir = exedir.substr(0, exedir.find_last_of('/')+1);
	for (size_t i = exedir.size() - 1; i >= 1; --i){
		if (exedir[i-1] == '/' && exedir[i] == '/') exedir.erase(i, 1);
	}

	std::string tcl_lib_dir = (exedir + "lib/tcl8.6/");
	::Tcl_SetVar2(interp, "tcl_library", 0, tcl_lib_dir.c_str(), TCL_GLOBAL_ONLY);
	::Tcl_SetVar2(interp, "env", "TCL_LIBRARY", tcl_lib_dir.c_str(), TCL_GLOBAL_ONLY);

	// tart@C }Eg邽߂ɕKvȃW[Q[h
	rc = ::Vfs_Init(interp);
	rc = ::Memchan_Init(interp);

	// tart@C }Eg邽߂ɕKvȃXNvgtart@C̒猩Ď擾
	std::string scr = read_vfs_script((exedir + "tcl_rt.tar").c_str());
	rc = ::Tcl_Eval(interp, scr.c_str());

	// tart@C }Eg
	rc = ::Tcl_Eval(interp, "package require vfs::tar;");
	rc = ::Tcl_Eval(interp, "vfs::tar::Mount $tcl_library/../../tcl_rt.tar $tcl_library/../;");
	//  interp ł͂ȂA Tcl_FS ̎dgݎ̂Ƀ}Eg邽߁A interp Ƃ͊֌WȂ Tcl_FSn̊֐ tcl_rt.tar ̒gɃANZXłB
}

int APIENTRY WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
    int argc = __argc;
    char **argv = __argv;

	const char *exedir_ = argv[0];

	Tcl_Interp *interp = ::Tcl_CreateInterp();
	LoadTarRT(interp, exedir_);
	Tcl_FindExecutable(argv[0]);

	int rc = 0;
	rc = Tcl_Init(interp);
	rc = Tk_Init(interp);
	rc = Blt_Init(interp);
	rc = Tkhtml_Init(interp);

	if (argc == 1){
		const char *blt_sample = 
			"package require BLT\n"
			"namespace import blt::*\n"
			"wm title . {}[J[łG}\n"
			"\n"
			"set g [graph .g -plotbackground black]\n"
			"$g configure -title {}[J[łG}\n"
			"$g configure -markerclippingarea graph -rightmargin 150\n"
			"\n"
			"$g axis configure x -title {X Axis} -min 0 -max 20\n"
			"$g axis configure y -title {Y Axis} -min 0 -max 20\n"
			"$g marker create polygon -fill red -coords { 5 5 5 10 10 10 10 5 }\n"
			"$g marker create polygon -fill blue -coords { 10 5 10 10 15 10 15 5 }\n"
			"$g marker create polygon -fill #404080 -coords { 15 5 15 10 20 10 20 5 }\n"
			"$g marker create text -outline white -text {Hello world!} -rotate 10 -coords { 15 20 }\n"
			"\n"
			"$g marker create polygon -fill yellow -coords { 17.5 7.5 19.5 5 40 5 40 2 19 2 19 4.5 }\n"
			"$g marker create text -outline black -text {gOɐoI} -coords { 24 3.5 }\n"

			"html .ht -width 400\n"
			".ht style {body {\n"
			"  font-family: \"lr SVbN\";\n"
			"  font-weight: normal;\n"
			"}\n"
			"}\n"
			".ht parse {<html><body><div>Hello World!!</div><br/><div>{</div></body></html>}\n"
			"grid $g .ht\n"
			"\n"
			;
			"after 100 {$g snap -format emf CLIPBOARD}\n";

		TTW_DString scr;
		scr.SysToUtf8(blt_sample, false);

		rc = ::Tcl_Eval(interp, scr);
	}else{
		const char *filename = argv[1];
		rc = ::Tcl_Eval(interp, (std::string("cd [file dirname {") + filename + "}]").c_str());
		FILE *fp = std::fopen(filename, "r");
		std::fseek(fp, 0, SEEK_END);
		size_t sz = std::ftell(fp);
		std::string str; str.resize(sz);
		std::rewind(fp);
		std::fread(&str[0], 1, sz, fp);
		std::fclose(fp);
		rc = ::Tcl_Eval(interp, str.c_str());
	}
	::Tk_MainLoop();
    return 0;
}

