/*
 * Decompiled with CFR 0.152.
 */
package com.japaricraft.japaricraftmod.mob;

import com.japaricraft.japaricraftmod.handler.JapariItems;
import com.japaricraft.japaricraftmod.mob.ai.EntityAITutinokoTradePlayer;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityTutinoko
extends EntityCreature
implements INpc,
IMerchant {
    private MerchantRecipeList buyingList;
    private EntityPlayer buyingPlayer;
    private static final ITradeList[] DEFAULT_TRADE_LIST_MAP = new ITradeList[]{new JapariCoinForItems(Items.field_151042_j, new PriceInfo(3, 6)), new JapariCoinForItems(Items.field_151043_k, new PriceInfo(1, 3)), new ListItemForJapariCoin(Items.field_151144_bL, new PriceInfo(2, 3)), new ListItemForJapariCoin(Items.field_151061_bv, new PriceInfo(-3, -1))};

    public EntityTutinoko(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 0;
        this.func_70105_a(0.48f, 1.7f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITutinokoTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.9));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.9));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.buyingList != null) {
            compound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70089_S()) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (!this.field_70170_p.field_72995_K && !this.buyingList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        return this.finalizeMobSpawn(difficulty, livingdata, true);
    }

    public IEntityLivingData finalizeMobSpawn(DifficultyInstance p_190672_1_, IEntityLivingData data, boolean p_190672_3_) {
        data = super.func_180482_a(p_190672_1_, data);
        this.populateBuyingList();
        return data;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.buyingPlayer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    private void populateBuyingList() {
        ITradeList[] trades;
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        if ((trades = DEFAULT_TRADE_LIST_MAP) != null) {
            for (ITradeList EntityTutinoko$itradelist : trades) {
                EntityTutinoko$itradelist.addMerchantRecipe(this, this.buyingList, this.field_70146_Z);
            }
        }
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
    }

    public void func_70933_a(MerchantRecipe recipe) {
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public static class PriceInfo
    extends Tuple<Integer, Integer> {
        public PriceInfo(int p_i45810_1_, int p_i45810_2_) {
            super((Object)p_i45810_1_, (Object)p_i45810_2_);
        }

        public int getPrice(Random rand) {
            return (Integer)this.func_76341_a() >= (Integer)this.func_76340_b() ? (Integer)this.func_76341_a() : (Integer)this.func_76341_a() + rand.nextInt((Integer)this.func_76340_b() - (Integer)this.func_76341_a() + 1);
        }
    }

    public static class JapariCoinForItems
    implements ITradeList {
        public Item buyingItem;
        public PriceInfo price;

        public JapariCoinForItems(Item itemIn, PriceInfo priceIn) {
            this.buyingItem = itemIn;
            this.price = priceIn;
        }

        @Override
        public void addMerchantRecipe(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.price != null) {
                i = this.price.getPrice(random);
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(this.buyingItem, i, 0), JapariItems.japaricoin));
        }
    }

    public static class ListItemForJapariCoin
    implements ITradeList {
        public ItemStack itemToBuy;
        public PriceInfo priceInfo;

        public ListItemForJapariCoin(Item par1Item, PriceInfo priceInfo) {
            this.itemToBuy = new ItemStack(par1Item);
            this.priceInfo = priceInfo;
        }

        public ListItemForJapariCoin(ItemStack stack, PriceInfo priceInfo) {
            this.itemToBuy = stack;
            this.priceInfo = priceInfo;
        }

        @Override
        public void addMerchantRecipe(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.getPrice(random);
            }
            if (i < 0) {
                itemstack = new ItemStack(JapariItems.japaricoin);
                itemstack1 = new ItemStack(this.itemToBuy.func_77973_b(), -i, this.itemToBuy.func_77960_j());
            } else {
                itemstack = new ItemStack(JapariItems.japaricoin, i, 0);
                itemstack1 = new ItemStack(this.itemToBuy.func_77973_b(), 1, this.itemToBuy.func_77960_j());
            }
            recipeList.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }
    }

    public static interface ITradeList {
        public void addMerchantRecipe(IMerchant var1, MerchantRecipeList var2, Random var3);
    }
}

