/*
First author tiritomato 2013.

mqsdx is distributed under the GNU Lesser General Public License 3.0(LGPLv3).

support blog (Japanese only)
http://d.hatena.ne.jp/tiri_tomato/
*/

#ifndef __MQSDKPlugIn0x_11_h__
#define __MQSDKPlugIn0x_11_h__

#include <string.h>
#include <algorithm>
#include <functional>
#include <iomanip>
#include <regex>
#include <sstream>
#include <vector>
#define NOMINMAX
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <MQSetting.h>
#include <MQBasePlugin.h>
#include <MQPlugin.h>

#include "impl/MQ0x_11.hpp"

// Plugin Version Checker
#ifdef MQPLUGIN_VERSION
	#if MQPLUGIN_VERSION < 0x0300
	"MQx" need newer than mqsdk300
	#endif
#else
	"MQx" need newer than mqsdk300
#endif

namespace MQ0x {
	
/*!	@addtogroup MQ0ẍꗗ
	@{
*/

	/*!
@brief g^z񂩂nbVR[h𐶐NX

@tparam T_OUT nbVR[h̖߂l^w
@tparam default_seed nbVR[h̃ftHg̏lwBȗ͐17gp܂B

@code
	// ̃nbVR[h擾
	DWORD hashOfString = CollectionHashCode<DWORD>("\[Xzij");
	
	// shortz̃nbVR[h擾
	const short array[] = { 0, 1, 2, 3 };
	unsigned int hashOfString = CollectionHashCode<unsigned int>(array, sizeof(array)/sizeof(array[0]));
@endcode

z̊evfɑ΂Ď̂悤ȌvZJԂănbVR[h𐶐܂BlZɑΉg^ŁAƂɕ_ł͂Ȃn̏Ɍ܂B
@code
	T_OUT hashCode = seed;

	(zvf胋[v) {
		hashCode = hashCode * ((sizeof(T_IN)*8)-1) ^ zvf;
	}
	return hashCode;
@endcode
	*/
	template <typename T_OUT, const size_t default_seed = 17> struct CollectionHashCode {
	public:
		///@brief T_OUTɃLXgꂽftHg̏l
		static const T_OUT defaultSeed = (T_OUT)default_seed;
		///@brief ftHgRXgN^
		CollectionHashCode( const T_OUT seed = defaultSeed ) : m_val( seed ) {}
		/*!
		@brief z̐擪|C^ƌw肵ănbVR[h𐶐
		@tparam T_IN \[Xž^w
		@note pSrcNULL܂͔z񐔂0łꍇA^ꂽl̂܂܃nbVR[hƂċL^܂B
		*/
		template <typename T_IN> CollectionHashCode( const T_IN *pSrc, const size_t ct, const T_OUT seed = defaultSeed ) : m_val(seed) {
			if ( pSrc != NULL ) for ( size_t i = 0; i < ct; i++ ) m_val = (m_val * (T_OUT)(sizeof(T_IN) * 8 - 1)) ^ pSrc[i];
		}
		/*!
		@brief w肵ănbVR[h𐶐
		@note pSrcNULL܂͒0̋̕łꍇA^ꂽl̂܂܃nbVR[hƂċL^܂B
		*/
		CollectionHashCode( const char *pSrc, const T_OUT seed = defaultSeed ) : m_val(FromTrailCodeCollection(pSrc,'\0',seed)) {}
		/*!
		@brief Chw肵ănbVR[h𐶐
		@note pSrcNULL܂͒0̋̕łꍇA^ꂽl̂܂܃nbVR[hƂċL^܂B
		*/
		CollectionHashCode( const wchar_t *pSrc, const T_OUT seed = defaultSeed ) : m_val(FromTrailCodeCollection(pSrc,L'\0',seed)) {}
		/*!
		@brief z̐擪|C^Ɣz̏I[lw肵ănbVR[h𐶐
		@tparam T_IN \[Xž^w
		@note pSrcNULL܂́Aŏ̃f[^ŏI[̔złꍇA^ꂽl̂܂܃nbVR[hƂċL^܂B
		*/
		template <typename T_IN> static CollectionHashCode FromTrailCodeCollection( const T_IN *pSrc, const T_IN trailCode, const T_OUT seed = defaultSeed ) {
			CollectionHashCode ret(seed);
			if ( pSrc != NULL ) while ( (*pSrc) != trailCode ) ret.m_val = (ret.m_val * (T_OUT)(sizeof(T_IN) * 8 - 1)) ^ (*(pSrc++));
			return ret;
		}
		///@brief Öق̃LXgĖ߂l擾
		operator T_OUT() { return m_val; }
	private:
		T_OUT m_val;
	};
	
	/*!
	@brief MQSettingsNX
	@code
		PluginBase<MQCommandPlugin> some_plugin;
		{
			SettingProxy setting = some_plugin.Setting(); // Setting擾
			setting.Load( ... );
			setting.Save( ... );
			setting.Close(); // ȗ\ifXgN^oRłClose()͎s܂j
		}
	@endcode
	SettingProxỹRs[͋֎~Ă܂(notcopyable)
	*/
	struct SettingProxy {
	public:
		//!@brief SettingProxyNX̐nh^
		struct Handle {
			friend struct SettingProxy;
			template <typename T_MQPLUGIN> friend class PluginBase;
			static Handle Empty() { return Handle(NULL); }
		public:
			Handle( MQBasePlugin* plugin ) { this->plugin = plugin; }
			MQBasePlugin* plugin;
		};
		SettingProxy( Handle handle );
		~SettingProxy() { Close(); }
		void Close();
		bool Load(const char *name, bool& value, bool default_value=false);
		bool Load(const char *name, int& value, int default_value=0);
		bool Load(const char *name, unsigned int& value, unsigned int default_value=0);
		bool Load(const char *name, float& value, float default_value=0.0f);
		bool Load(const char *name, std::string& value, std::string default_value="");
		bool Save(const char *name, const bool& value);
		bool Save(const char *name, const int& value);
		bool Save(const char *name, const unsigned int& value);
		bool Save(const char *name, const float& value);
		bool Save(const char *name, const char* value);
		bool Save(const char *name, const std::string& value);
	private:
		SettingProxy(const SettingProxy&);				// kill copy
		SettingProxy& operator=(const SettingProxy&);	// kill copy
		MQBasePlugin* m_plugin;
		MQSetting* m_setting;
	};

	/*!
	@brief MQBasePluginpNXɁA{IȊgsev[gbp[NX
	@tparam T_MQPLUGIN MQBasePluginp^

@par

̃NX̓RXgN^ŐҖAvOCA\w肷鎖ňȉ̎܂B
- GetPlugInID()
- GetPlugInName()
- EnumString()
- MQSetting::Open()Close()

@par

@code
PluginBase<MQCommandPlugin> plugin("tiritomato", "SamplePlugin Copyright(C) 2013, tiritomato.", "SamplePlugin");
{
	SettingProxy setting = plugin.Setting();
	setting.Load(...);
	setting.Save(...);
	setting.Close(); // Close()SettingProxỹfXgN^ɔC鎖o܂B
}
@endcode

@par

ID̎ɂ͕̃nbVR[h̗pĂ܂B
- IDҖiproductNamej̃nbVR[h
- vOCIDvOCiGetPlugInName()Ŏ擾ł镶j̃nbVR[h
	
@par

nbVR[hZo͓T^IɁunbVR[h = nbVR[h * (͌^(̏ꍇchar^)TCỸrbg-1) ^ zvfvƂvZA
zvf̌JԂWbN̗pĂ܂B̃ev[gNXōŏIIɃbv̂Ãev[gNXx[XNXɂČpĊĝ͎RłB
	*/
	template <typename T_MQPLUGIN> class PluginBase : public T_MQPLUGIN {
	public:
		PluginBase( const char* productName, const char* pluginFullName, const char* pluginString ) :
			m_productName( productName ),
			m_pluginFullName( pluginFullName ),
			m_pluginString( pluginString ),
			m_idProduct( CollectionHashCode<DWORD>(productName) ),
			m_idPlugin( CollectionHashCode<DWORD>(pluginFullName) )
		{
		}

		PluginBase( const char* productName, const char* pluginFullName, const char* pluginString,
			const DWORD idProduct, const DWORD idPlugin	) :
			m_productName( productName ),
			m_pluginFullName( pluginFullName ),
			m_pluginString( pluginString ),
			m_idProduct( idProduct ),
			m_idPlugin( idPlugin )
		{
		}

		//! vOCIDԂB
		virtual void GetPlugInID(DWORD *Product, DWORD *ID) {
			*Product = m_idProduct;
			*ID = m_idPlugin;
		}
		//! vOCԂB
		virtual const char *GetPlugInName() { return m_pluginFullName.c_str(); }
		//! {^⃁j[ɕ\镶ԂB
		virtual const char *EnumString() { return m_pluginString.c_str(); }
		//! ҖԂiƎɒǉj
		const char* GetProductName() { return m_productName.c_str(); }
		//! pꂽɎgILXg
		MQBasePlugin* BasePlugin() { return this; }
		//! SettingProxy(MQSetting̑)I[vnh擾
		SettingProxy::Handle Setting() { return SettingProxy::Handle(BasePlugin()); }
		/// @brief v_NgID擾
		DWORD ProductID() { return m_idProduct; }
		/// @brief vOCID擾
		DWORD PluginID() { return m_idPlugin; }
	protected:
		const std::string m_productName;
		const std::string m_pluginFullName;
		const std::string m_pluginString;
		const DWORD m_idProduct;
		const DWORD m_idPlugin;
	};

	/*!	@name O[o
		@{ */

	//! @brief e̖O擾֐ɂāAϒobt@TCY̍ŒᏉl̃ftHg`B
#ifdef _DEBUG 
	static const std::vector<char>::size_type GetNameInitialBufferSize = 2;
#else
	static const std::vector<char>::size_type GetNameInitialBufferSize = 32;
#endif

	//! @brief hLg}eA폜B
	//! @return NULL܂̓j[NID̈v}eAȂꍇ͍폜s킸falseԂ܂BȊOtrue
	inline bool DeleteMaterial( const MQDocument doc, const MQMaterial mat ) {
		int index = prv_impl::GetIdentifiedIndex(doc, mat);
		if ( index < 0 ) return false;
		doc->DeleteMaterial(index); return true;
	}
	//! @brief hLgIuWFNg폜B
	//! @return NULL܂̓j[NID̈vIuWFNgȂꍇ͍폜s킸falseԂ܂BȊOtrue
	inline bool DeleteObject( const MQDocument doc, const MQObject obj ) {
		int index = prv_impl::GetIdentifiedIndex(doc, obj);
		if ( index < 0 ) return false;
		doc->DeleteObject(index); return true;
	}
	/*!	@brief }eAN[̂߂́AJEgAbvꂽdȂʖ擾
		@return ȂƂT_ŏdȂʖ╶BNULLw肳ȂǃG[ɂ͋̕񂪕ԂB
		@par ʖ̖K
		jobj > obj1 | obj00 > obj01 | obj0.99 > obj0.100
		- d͉
		- ̖O̖ɐꍇ'1't^B
		- ̖O̖0-9̐񂪂ꍇ́A+1B0-9ȊOAႦΏ_Ȃǂ͐l`ƂĂ͍lȂB
		- N[▼̖̌́A̖O̖̐ƓꌅB
		.
		@attention MQSDK Rev3.10MQDocument::GetUnusedMaterialName()ǉ܂B̊֐͉ʌ݊AэMQxƎdlƂĎc܂B
		@date 2013.02.04 MQSDK Rev3.10Ή
		*/
	inline std::string GetCountUpCloneableUniqueName( const MQDocument doc, const MQMaterial src, std::vector<char>* const buf = NULL ) {
		return prv_impl::GetCountUpCloneableUniqueName(doc,src,buf);
	}
	/*!	@brief IuWFNgN[̂߂́AJEgAbvꂽdȂʖ擾
		@return ȂƂT_ŏdȂʖ╶BNULLw肳ȂǃG[ɂ͋̕񂪕ԂB
		@par ʖ̖K
		jobj > obj1 | obj00 > obj01 | obj0.99 > obj0.100
		- d͉
		- ̖O̖ɐꍇ'1't^B
		- ̖O̖0-9̐񂪂ꍇ́A+1B0-9ȊOAႦΏ_Ȃǂ͐l`ƂĂ͍lȂB
		- N[▼̖̌́A̖O̖̐ƓꌅB
		.
		@attention MQSDK Rev3.10MQDocument::GetUnuseObjectName()ǉ܂B̊֐͉ʌ݊AэMQxƎdlƂĎc܂B
		@date 2013.02.04 MQSDK Rev3.10Ή
	*/
	inline std::string GetCountUpCloneableUniqueName( const MQDocument doc, const MQObject src, std::vector<char>* const buf = NULL ) {
		return prv_impl::GetCountUpCloneableUniqueName(doc,src,buf);
	}
	//! @brief hLgɓo^Ă}eA𖼑OŌ
	//! @return }eABȂꍇNULLB
	inline MQMaterial GetMaterial( const MQDocument doc, const char* name ) { return prv_impl::GetNamed<MQMaterial>( doc, name ); }
	//! @brief hLgɓo^Ă}eAj[NIDŌ
	//! @return }eABȂꍇNULLB
	//! @attention MQSDK Rev3.10MQDocument::GetMaterialFromUniqueID()ǉ܂B̊֐͉ʌ݊̂߂ɎcĂ܂B
	//!	@date 2013.02.04 MQSDK Rev3.10Ή
	inline MQMaterial GetMaterial( const MQDocument doc, const UINT id ) {
		// ^ZRCA{̂ɃoŐ^AL[vB
		/*
		#if 0x0310 <= MQPLUGIN_VERSION
			if ( doc != NULL ) return doc->GetMaterialFromUniqueID(id);
			return NULL;
		#else
			return prv_impl::GetIdentified<MQMaterial>( doc, id );
		#endif*/
		return prv_impl::GetIdentified<MQMaterial>( doc, id );
	}
	
	/// @cond
	std::string GetMaterialTextureName( const MQMaterial, DWORD );
	/// @endcond

	/// @brief eNX`̃t@CpX擾B GetMaterialTextureName()  map_type  MQMAPPING_ALPHA w肷̂ƓłB
	inline std::string GetMaterialAlphaName( const MQMaterial mat ) { return GetMaterialTextureName(mat,MQMAPPING_ALPHA); }
	/// @brief ʉeNX`̃t@CpX擾B GetMaterialTextureName()  map_type  MQMAPPING_BUMP w肷̂ƓłB
	inline std::string GetMaterialBumpName( const MQMaterial mat ) { return GetMaterialTextureName(mat,MQMAPPING_BUMP); }
	/// @brief hLgɓo^Ă}eA𖼑OŌB
	/// @return }eÃCfbNXBȂꍇ-1
	inline int GetMaterialIndex( const MQDocument doc, const char* name ) { return prv_impl::GetNamedIndex<MQMaterial>( doc, name ); }
	/// @brief hLgɓo^Ă}eAj[NIDŌB
	/// @return }eÃCfbNXBȂꍇ-1
	inline int GetMaterialIndex( const MQDocument doc, const UINT id ) { return prv_impl::GetIdentifiedIndex<MQMaterial>( doc, id ); }
/*!
@brief eNX`̃t@CpX擾B
@param map_type 擾eNX`̎ނw肷
- MQMAPPING_TEXTURE / MQMaterial::GetTextureName()ĂяoĖ͗l摜pX擾
- MQMAPPING_ALPHA / MQMaterial::GetAlphaName()Ăяoē摜pX擾
- MQMAPPING_BUMP / MQMaterial::GetBumpName()Ăяoēʉ摜pX擾
@return }bsÕt@C𑊑΃pXŎ擾܂iX΃pXŎw肳Ăꍇ͐΃pXԂ邻łjBX摜ݒ肳ĂȂA邢matNULLw肷ȂǂȂ炩̎sɂ́A̕񂪕Ԃ܂B
@details ꂽt@C΃pXɕϊɂMQDocument::FindMappingFile()gp܂B
*/
	inline std::string GetMaterialTextureName( const MQMaterial mat, const DWORD map_type = MQMAPPING_TEXTURE ) {
		if ( mat != NULL )
		{
			std::vector<char> buf;
			prv_impl::GetMaterialTextureName(&buf, mat, map_type);
			return std::string(&buf[0]);
		}
		return "";
	}
	/// @brief }eA̖O擾B
	/// @return }eA̖OBNULLw肳ȂǁAG[ɂ͋̕B
	inline std::string GetName( const MQMaterial mat ){ return prv_impl::GetName( mat ); }
	/// @brief IuWFNg̖O擾
	/// @return IuWFNg̖OBNULLw肳ȂǁAG[ɂ͋̕B
	inline std::string GetName( const MQObject obj ){ return prv_impl::GetName( obj ); }
	//! @brief hLgɓo^ĂIuWFNg𖼑OŌ
	//! @return IuWFNgBȂꍇNULLB
	inline MQObject GetObject( const MQDocument doc, const char* name ) { return prv_impl::GetNamed<MQObject>( doc, name ); }
	//! @brief hLgɓo^ĂIuWFNgj[NIDŌ
	//! @return IuWFNgBȂꍇNULLB
	//! @attention MQSDK Rev3.10MQDocument::GetObjectFromUniqueID()ǉ܂B̊֐͉ʌ݊̂߂ɎcĂ܂B
	//!	@date 2013.02.04 MQSDK Rev3.10Ή
	inline MQObject GetObject( const MQDocument doc, const UINT id ) {
		#if 0x0310 <= MQPLUGIN_VERSION
			if ( doc != NULL ) return doc->GetObjectFromUniqueID(id);
			return NULL;
		#else
			return prv_impl::GetIdentified<MQObject>(doc, id );
		#endif
	}
	//! @brief hLgɓo^ĂIuWFNg𖼑OŌ
	/// @return IuWFNg̃CfbNXBȂꍇ-1
	inline int GetObjectIndex( const MQDocument doc, const char* name ) { return prv_impl::GetNamedIndex<MQObject>( doc, name ); }
	/// @brief hLgɓo^ĂIuWFNgj[NIDŌB
	/// @return IuWFNg̃CfbNXBȂꍇ-1
	inline int GetObjectIndex( const MQDocument doc, const UINT id ) { return prv_impl::GetIdentifiedIndex<MQObject>(doc, id ); }

#if 0x0310 <= MQPLUGIN_VERSION

	/// @brief hLgɓo^ĂȂ}eA擾iMQDocument::GetUnusedMaterialNamẽbp[֐jB
	/// @return 擾BdocNULL̎͋̕B
	/// @attention MQSDK Rev3.10 痘p\
	inline std::string GetUnusedMaterialName( const MQDocument doc, const char* base_name = NULL ) {
		return prv_impl::GetUnusedNameString<MQMaterial>( doc, base_name );
	}
	/// @brief hLgɓo^ĂȂ}eA擾iMQDocument::GetUnusedMaterialNamẽbp[֐jB
	/// @param base_name_material ̖Ow肷}eABNULLŏȗbase_nameNULLɂMQDocument::GetUnusedMaterialNameĂяôƓB
	/// @return 擾BdocNULL̎͋̕B
	/// @attention MQSDK Rev3.10 痘p\
	inline std::string GetUnusedMaterialName( const MQDocument doc, const MQMaterial base_name_material ) {
		if ( base_name_material == NULL ) return prv_impl::GetUnusedNameString<MQMaterial>( doc );
		return prv_impl::GetUnusedNameString<MQMaterial>( doc, GetName( base_name_material ).c_str() );
	}
	/// @brief hLgɓo^ĂȂIuWFNg擾iMQDocument::GetUnusedObjectNamẽbp[֐jB
	/// @return 擾BdocNULL̎͋̕B
	/// @attention MQSDK Rev3.10 痘p\
	inline std::string GetUnusedObjectName( const MQDocument doc, const char* base_name = NULL ) {
		return prv_impl::GetUnusedNameString<MQObject>( doc, base_name );
	}
	/// @brief hLgɓo^ĂȂIuWFNg擾iMQDocument::GetUnusedObjectNamẽbp[֐jB
	/// @param base_name_object ̖Ow肷}eABNULLŏȗbase_nameNULLɂMQDocument::GetUnusedObjectNameĂяôƓB
	/// @return 擾BdocNULL̎͋̕B
	/// @attention MQSDK Rev3.10 痘p\
	inline std::string GetUnusedObjectName( const MQDocument doc, const MQObject base_name_object ) {
		if ( base_name_object == NULL ) return prv_impl::GetUnusedNameString<MQMaterial>( doc );
		return prv_impl::GetUnusedNameString<MQMaterial>( doc, GetName( base_name_object ).c_str() );
	}
	
#endif

	//! @}

	//! @}

	namespace prv_impl {}; // kill prv_impl access ( to private header implement trap )
};

#endif