/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sample.facade;

import com.sample.BackingDTO;
import com.sample.interceptor.LogIntercept;
import com.sample.iservicebean.ServiceBean;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.RequestScoped;

/**
 *
 * @author konishiyuji
 */
@RequestScoped
public class BackingBeanFacadeDelegater {
    @LogIntercept
    public String execute(List<ServiceBean> list, BackingDTO backingDTO){
        String errorCode = "000";
        for (ServiceBean bean : list){
            errorCode = bean.execute(backingDTO);
            if (!errorCode.equals("000")){
                return errorCode;
            }
        }
        return errorCode;
    }    

    public String execute(ServiceBean bean0, BackingDTO backingDTO){
        List<ServiceBean> list = new ArrayList<>();
        list.add(bean0);
        return execute(list, backingDTO);
    }

    public String execute(ServiceBean bean0, ServiceBean bean1, BackingDTO backingDTO){
        List<ServiceBean> list = new ArrayList<>();
        list.add(bean0);
        list.add(bean1);
        return execute(list, backingDTO);
    }
}
