/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sample;

import java.nio.charset.Charset;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 *
 * @author konishiyuji
 */
public class ByteValidator 
        implements ConstraintValidator<Byte, String> {

    private int min;
    private int max;
    private String charset;
    
    /** アノテーションから情報を受け取る */
    @Override
    public void initialize(Byte annotation) {
       min = annotation.min();
       max = annotation.max();
       charset = annotation.charset();
    }

    /** 
     * 検証処理
     * 
     * @param value 入力値
     * @param ctx コンテキスト
     * @return true - 制約を満たす。 false - 制約を満たさない。
     */
    @Override
    public boolean isValid(String value, 
            ConstraintValidatorContext ctx) {
        
        // nullは対象外
        if (value == null){return true;}
        
        byte[] b = value.getBytes(Charset.forName(charset));
        
        return min <= b.length && b.length <= max;
        
    }
}

