﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Namespace TwitterServices
    ''' <summary>保存された検索を操作します。</summary>
    Public NotInheritable Class SavedSearchesService
        <DebuggerBrowsable(DebuggerBrowsableState.Never)> Dim tw As Twitter
        Friend Sub New(ByVal tw As Twitter)
            Me.tw = tw
        End Sub

        ''' <summary>自分が保存した検索を取得します。</summary>
        Public Function GetSavedSearches() As IEnumerable(Of SavedSearch)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "saved_searches.xml"), "GET", Nothing, Nothing)
            Dim doc = XElement.Load(stream)
            stream.Close()
            Return doc.<saved_search>.Select(Function(o) SavedSearch.FromXml(o))
        End Function

        ''' <summary>IDを指定して保存された検索を取得します。</summary>
        Public Function GetSavedSearch(ByVal id As Long) As SavedSearch
            Dim stream = tw.GetStream(Twitter.CreateUri(1, String.Format("saved_searches/show/{0}.xml", id)), "GET", Nothing, Nothing)
            Dim doc = XElement.Load(stream)
            stream.Close()
            Return SavedSearch.FromXml(doc)
        End Function

        ''' <summary>検索内容を保存します。</summary>
        ''' <param name="query">検索内容</param>
        ''' <returns>保存結果</returns>
        Public Function Create(ByVal query As String) As SavedSearch
            Dim param As New Dictionary(Of String, String)
            param.Add("query", query)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "saved_searches/create.xml"), "POST", param, Nothing)
            Dim doc = XElement.Load(stream)
            stream.Close()
            Return SavedSearch.FromXml(doc)
        End Function

        ''' <summary>保存した検索を削除します。</summary>
        Public Sub Destroy(ByVal id As Long)
            tw.GetStream(Twitter.CreateUri(1, String.Format("saved_searches/destroy/{0}.xml", id)), "POST", Nothing, Nothing).Close()
        End Sub
    End Class
End Namespace