﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

''' <summary>PIN入力用フォーム</summary>
Public Class PINForm
    ''' <param name="reqUri">AuthenticatePinFlowRequestメソッドで取得したURI</param>
    Public Sub New(ByVal reqUri As Uri)

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
        MainWebBrowser.Url = reqUri
    End Sub

    Private Sub okButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OkButton.Click
        If PinTextBox.TextLength = 0 Then
            MessageBox.Show("暗証番号を入力してください。", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Return
        End If
        _pincode = PinTextBox.Text
        Me.DialogResult = Windows.Forms.DialogResult.OK
        Me.Close()
    End Sub

    Dim _pincode As String
    ''' <summary>入力された暗証番号</summary>
    Public ReadOnly Property PinCode As String
        Get
            Return _pincode
        End Get
    End Property

    Private Sub WebBrowser1_DocumentCompleted(ByVal sender As System.Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs) Handles MainWebBrowser.DocumentCompleted, MainWebBrowser.DocumentCompleted
        'PINコードを検索
        Dim pincodeElement = MainWebBrowser.Document.GetElementById("oauth_pin")
        If pincodeElement IsNot Nothing Then
            PinTextBox.Text = pincodeElement.InnerText.Trim
        End If
    End Sub
End Class