﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Namespace TwitterServices
    ''' <summary>フレンドを操作します。</summary>
    ''' <remarks>showはよく意味が分からないので未実装</remarks>
    Public NotInheritable Class FriendsService
        <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
        Dim tw As Twitter
        Friend Sub New(ByVal tw As Twitter)
            Me.tw = tw
        End Sub

        ''' <summary>指定したユーザーをフォローします。</summary>
        ''' <param name="id">フォローするユーザーのscreen_nameまたはid</param>
        Public Sub Create(ByVal id As String)
            tw.GetStream(Twitter.CreateUri(1, String.Format("friendships/create/{0}.xml", id)), "POST", Nothing, Nothing).Close()
        End Sub

        ''' <summary>指定したユーザーへのフォローを解除します。</summary>
        ''' <param name="id">フォローを解除するユーザーのscreen_nameまたはid</param>
        Public Sub Destroy(ByVal id As String)
            tw.GetStream(Twitter.CreateUri(1, String.Format("friendships/destroy/{0}.xml", id)), "POST", Nothing, Nothing).Close()
        End Sub

        ''' <summary>指定したユーザー同士が相互フォローの関係にあるか</summary>
        ''' <param name="user_a">確認する1人目のユーザーのscreen_nameまたはid</param>
        ''' <param name="user_b">確認する2人目のユーザーのscreen_nameまたはid</param>
        Public Function Exists(ByVal user_a As String, ByVal user_b As String) As Boolean
            Dim param As New Dictionary(Of String, String)
            param.Add("user_a", user_a)
            param.Add("user_b", user_b)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "friendships/exists.xml"), "GET", param, Nothing)
            Using sr As New StreamReader(stream)
                Exists = sr.ReadLine = "<friends>true</friends>"
                sr.Close()
            End Using
        End Function
    End Class
End Namespace
