/*
 * FileFilterGroupAnd class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.LinkedList;

/**
 * ̃t@CEtB^ANDł܂Ƃ߂邽߂̃t@CEtB^ENXB
 * <br>
 * 菈ɂāAi[SẴt@CEtB^Yꍇɂ̂
 * ^ԂB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:45 $
 */
public class FileFilterGroupAnd implements FileFilter
{
  /** q̃t@CEtB^i[郊XgB */
  private List<FileFilter> filterLst_ = new LinkedList<FileFilter>();

  /**
   * ftHgRXgN^B
   */
  public FileFilterGroupAnd()
  {}

  /**
   * q̃t@CEtB^ǉB
   *
   * @param  childFilter q̃t@CEtB^B
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public void addFilter(FileFilter childFilter)
  {
    assert (childFilter != null) : "@param:childFilter is null.";

    filterLst_.add(childFilter);
  }

  /**
   * w肳ꂽt@CÃIuWFNg̎ɍv邩𔻒肷B
   * <br>
   * ̃IuWFNgi[SĂ̎qt@CEtB^Yꍇɂ̂
   * ^ԂB
   * <br>
   * qt@CEtB^Po^ĂȂꍇ́Aɐ^ԂB
   *
   * @param  file Ώۂ̃t@CB
   * @return SĂ̎qt@CEtB^Yꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public boolean accept(File file)
  {
    assert (file != null) : "@param:file is null.";

    for (FileFilter filter : filterLst_) {
      if (! filter.accept(file)) {
        return false;
      }
    }

    return true;
  }
}

