/*
 * OutOfRangeException class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

/**
 * f[^̒l͈͊OɂȂƂɃX[ONXB
 * <br>
 * tB[hϐɂ́ÂƂ̃f[^̒lƁÃf[^̂Ƃׂ͈͂
 * JnlAIlĂB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:44 $
 */
public class OutOfRangeException extends RuntimeException
{
  /** VAԍB */
  static final long serialVersionUID = -927835090593432651L;

  /** ͈͊OɂȂƂ̒lB */
  private Comparable value_;

  /** ͈͂̊JnlB */
  private Comparable start_;

  /** ͈͂̏IlB*/
  private Comparable end_;

  /**
   * ͈͊OɂȂ<code>int</code>lƁA<code>int</code>^͈̔͂
   * ɂƂRXgN^B
   *
   * @param  value ͈͊OɂȂlB
   * @param  start ͈͂̊JnlB
   * @param  end   ͈͂̏IlB
   */
  public OutOfRangeException(int value, int start, int end)
  {
    value_ = new Integer(value);

    if (start < end) {
      start_ = new Integer(start);
      end_   = new Integer(end);
    }
    else {
      start_ = new Integer(end);
      end_   = new Integer(start);
    }
  }

  /**
   * ͈͊OɂȂ<code>long</code>lƁA<code>long</code>^͈̔͂
   * ɂƂRXgN^B
   *
   * @param  value ͈͊OɂȂlB
   * @param  start ͈͂̊JnlB
   * @param  end   ͈͂̏IlB
   */
  public OutOfRangeException(long value, long start, long end)
  {
    value_ = new Long(value);

    if (start < end) {
      start_ = new Long(start);
      end_   = new Long(end);
    }
    else {
      start_ = new Long(end);
      end_   = new Long(start);
    }
  }

  /**
   * ͈͊OɂȂ<code>float</code>lƁA<code>float</code>^͈̔͂
   * ɂƂRXgN^B
   *
   * @param  value ͈͊OɂȂlB
   * @param  start ͈͂̊JnlB
   * @param  end   ͈͂̏IlB
   */
  public OutOfRangeException(float value, float start, float end)
  {
    value_ = new Float(value);

    if (start < end) {
      start_ = new Float(start);
      end_   = new Float(end);
    }
    else {
      start_ = new Float(end);
      end_   = new Float(start);
    }
  }

  /**
   * ͈͊OɂȂ<code>double</code>lƁA<code>double</code>^͈̔͂
   * ɂƂRXgN^B
   *
   * @param  value ͈͊OɂȂlB
   * @param  start ͈͂̊JnlB
   * @param  end   ͈͂̏IlB
   */
  public OutOfRangeException(double value, double start, double end)
  {
    value_ = new Double(value);

    if (start < end) {
      start_ = new Double(start);
      end_   = new Double(end);
    }
    else {
      start_ = new Double(end);
      end_   = new Double(start);
    }
  }

  /**
   * ͈͊OɂȂ{@link java.lang.Comparable Comparable}IuWFNgƁA
   * {@link java.lang.Comparable Comparable}IuWFNg͈̔͂ɂƂ
   * RXgN^B
   * <br>
   * Ƀkw肵ꍇ́Â܂܃kݒ肷B
   *
   * @param  value ͈͊OɂȂlB
   * @param  start ͈͂̊JnlB
   * @param  end   ͈͂̏IlB
   */
  public <U extends Comparable<U>> OutOfRangeException(U value, U start, U end)
  {
    if (start == null || end == null) {
      value_ = value;
      start_ = start;
      end_ = end;
    }
    else if (start.compareTo(end) < 0) {
      value_ = value;
      start_ = start;
      end_ = end;
    }
    else {
      value_ = value;
      start_ = end;
      end_ = start;
    }
  }

  /**
   * bZ[WɂƂRXgN^B
   * <br>
   * ͈͊OɂȂlyє͈͂̊JnlAIlɂ́Aꂼkݒ肷B
   * Ƀkw肳ꂽꍇ́AbZ[Wɂ̂܂܃kݒ肷B
   * 
   * @param  msg ObZ[WB
   */
  public OutOfRangeException(String msg)
  {
    super(msg);
  }

  /**
   * ͈͊OƂȂl\lIuWFNgԂB
   *
   * @return ͈͊OƂȂl̐lIuWFNgB
   */
  public Comparable getValue()
  {
    return value_;
  }

  /**
   * ͈͂̊Jnl\lIuWFNgԂB
   *
   * @return ͈͂̊Jnl̐lIuWFNgB
   */
  public Comparable getStart()
  {
    return start_;
  }

  /**
   * ͈͂̏Il\lIuWFNgԂB
   *
   * @return ͈͂̏Il̐lIuWFNgB
   */
  public Comparable getEnd()
  {
    return end_;
  }

  /**
   * ObZ[W擾B
   * <br>
   * ͈͊OƂȂlA͈͂̊JnlAIl̂ꂩkłȂꍇ́A
   * ̒l\郁bZ[WԂB
   * ׂ̂Ă̒lk̏ꍇ́ARXgN^Őݒ肳ꂽbZ[W
   * ΂ԂAkł΃kԂB
   *
   * @return ObZ[WB
   */
  public String getMessage()
  {
    if (value_ != null || start_ != null || end_ != null) {
      StringBuilder msg = new StringBuilder();
      msg.append((value_ != null) ? value_.toString() : "?");
      msg.append(" is out of range (");
      msg.append((start_ != null) ? start_.toString() : "-");
      msg.append(",");
      msg.append((end_ != null) ? end_.toString() : "-");
      msg.append(").");
      return msg.toString();
    }

    return super.getMessage();
  }
}
