/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.function.print;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import ts.tester.function.Result;
import ts.tester.function.ResultType;
import ts.tester.function.print.AbstractPrinter;
import ts.util.resource.PropertyResource;
import ts.util.resource.Resource;

public class HtmlPrinterBase
extends AbstractPrinter {
    protected static final String KEY_TOFILE = "printer.html.toFile";
    protected static final String KEY_HEADER = "printer.html.format.header";
    protected static final String KEY_PRECASES = "printer.html.format.precases";
    protected static final String KEY_CASE = "printer.html.format.case";
    protected static final String KEY_POSTCASES = "printer.html.format.postcases";
    protected static final String KEY_FOOTER = "printer.html.format.footer";
    protected static final char PREFIX_CHAR = '%';
    protected static final String EOL = System.getProperty("line.separator");
    protected static final String FMT_TEST = "test";
    protected static final String FMT_CASE = "case";
    protected static final String OPT_NAME = ".name";
    protected static final String OPT_LASTNAME = ".lastname";
    protected static final String OPT_PACKAGEDIR = ".package-dir";
    protected static final String OPT_TESTER = ".tester";
    protected static final String OPT_DATE = ".date";
    protected static final String OPT_JUDGE = ".judge";
    protected static final String OPT_CHECK = ".check";
    protected static final String OPT_GOOD = ".good";
    protected static final String OPT_NOGOOD = ".nogood";
    protected static final String OPT_KNOWNBUG = ".knownbug";
    protected static final String OPT_CHILD = ".child";
    protected static final String OPT_EMPTY = ".empty";
    protected static final String OPT_INCOMPLETE = ".incomplete";
    protected static final String OPT_INDEX = ".index";
    protected static final String OPT_MESSAGE = ".message";
    private String testerName_ = "";
    private Resource htmlRes_ = Resource.EMPTY;

    protected HtmlPrinterBase() {
    }

    public HtmlPrinterBase(String string) {
        this.setTesterName(string);
        this.loadDefaultResource();
    }

    protected void loadDefaultResource() {
        try {
            this.htmlRes_ = new PropertyResource("ts/tester/function/print/html.properties"){

                protected InputStream getInputStream(String string) throws FileNotFoundException, IOException {
                    return ClassLoader.getSystemResourceAsStream("ts/tester/function/print/html.properties");
                }
            };
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            this.htmlRes_ = Resource.EMPTY;
        }
    }

    public HtmlPrinterBase(String string, Resource resource) {
        assert (resource != null) : "@param:resource is null.";
        this.setTesterName(string);
        this.htmlRes_ = resource;
    }

    protected Resource getResource() {
        return this.htmlRes_;
    }

    public void setTesterName(String string) {
        assert (string != null) : "@param:testerName is null.";
        this.testerName_ = string;
    }

    protected String getTesterName() {
        return this.testerName_;
    }

    @Override
    public CaseResult createCaseResult(String string, CaseResult caseResult) {
        return new _CaseResult(string, caseResult);
    }

    @Override
    public void testEnded(CaseResult caseResult) {
        assert (caseResult != null) : "@param:root is null.";
        assert (caseResult instanceof _CaseResult) : "@param:root is an instance of unsupported CaseResult class.";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FMT_TEST, caseResult);
        Iterator<Result> iterator = ((_CaseResult)caseResult).resultList().iterator();
        if (iterator.hasNext()) {
            Result result = iterator.next();
            hashMap.put(FMT_CASE, result);
        }
        this.outputHtmlFile(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputHtmlFile(Map<String, Object> map) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            String string = this.getReplacedString(KEY_TOFILE, map);
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            outputStreamWriter = new FileWriter(string);
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            printWriter.println(this.getReplacedString(KEY_HEADER, map));
            printWriter.flush();
            printWriter.println(this.getReplacedString(KEY_PRECASES, map));
            printWriter.flush();
            _CaseResult _CaseResult2 = (_CaseResult)map.get(FMT_TEST);
            for (Result result : _CaseResult2.resultList()) {
                Object object = map.put(FMT_CASE, result);
                printWriter.println(this.getReplacedString(KEY_CASE, map));
                printWriter.flush();
                map.put(FMT_CASE, object);
            }
            printWriter.println(this.getReplacedString(KEY_POSTCASES, map));
            printWriter.flush();
            printWriter.println(this.getReplacedString(KEY_FOOTER, map));
            printWriter.flush();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    String convertToHtml(String string) {
        assert (string != null) : "@param:s is null.";
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&#60;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&#62;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&#38;");
                continue;
            }
            if (string.substring(i).startsWith(EOL)) {
                stringBuffer.append("<BR>");
                i += EOL.length() - 1;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected String getReplacedString(String string, Map<String, Object> map) {
        assert (string != null) : "@param:key is null.";
        assert (map != null) : "@param:objMap is null.";
        String string2 = this.getResource().getFirstValue(string);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (bl) {
                if (c == '%') {
                    stringBuffer.append('%');
                } else {
                    i = this.replaceArgument(stringBuffer, string2, i - 1, map);
                }
                bl = false;
                continue;
            }
            if (c == '%') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    int replaceArgument(StringBuffer stringBuffer, String string, int n, Map<String, Object> map) {
        assert (stringBuffer != null) : "@param:buf is null.";
        assert (string != null) : "@param:fmt is null.";
        assert (map != null) : "@param:objMap is null.";
        assert (n >= 0) : "@param:fmt is negative.";
        assert (n <= string.length()) : "@param:fmt is out of bounds.";
        if (string.length() == 0) {
            return 0;
        }
        if (string.charAt(n + 1) != '{') {
            stringBuffer.append(string.substring(n, n + 2));
            return n + 1;
        }
        int n2 = string.indexOf(125, n + 2);
        if (n2 < 0) {
            stringBuffer.append(string.substring(n));
            return string.length() - 1;
        }
        String string2 = string.substring(n + 2, n2).trim();
        stringBuffer.append(this.convertToHtml(this.replaceArgument(string2, map)));
        return n2;
    }

    protected String replaceArgument(String string, Map<String, Object> map) {
        assert (string != null) : "@param:arg is null.";
        assert (map != null) : "@param:objMap is null.";
        if (string.startsWith(FMT_CASE)) {
            Object object = map.get(FMT_CASE);
            if (object == null || !(object instanceof _CaseResult)) {
                return "--";
            }
            _CaseResult _CaseResult2 = (_CaseResult)object;
            String string2 = string.substring(FMT_CASE.length());
            if (string2.equals(OPT_NAME)) {
                return _CaseResult2.getName();
            }
            if (string2.equals(OPT_MESSAGE)) {
                return _CaseResult2.getMessage();
            }
            if (string2.equals(OPT_JUDGE)) {
                return _CaseResult2.count(ResultType.NG) > 0 ? "reject" : "pass";
            }
            if (string2.equals(OPT_CHECK)) {
                return String.valueOf(_CaseResult2.countOfCheckResults());
            }
            if (string2.equals(OPT_GOOD)) {
                return String.valueOf(_CaseResult2.count(ResultType.OK));
            }
            if (string2.equals(OPT_NOGOOD)) {
                return String.valueOf(_CaseResult2.count(ResultType.NG));
            }
            if (string2.equals(OPT_KNOWNBUG)) {
                return String.valueOf(_CaseResult2.count(ResultType.KnownBug));
            }
            if (string2.equals(OPT_CHILD)) {
                return String.valueOf(_CaseResult2.countOfResults());
            }
            if (string2.equals(OPT_EMPTY)) {
                return String.valueOf(_CaseResult2.count(ResultType.Empty));
            }
            if (string2.equals(OPT_INCOMPLETE)) {
                return String.valueOf(_CaseResult2.count(ResultType.Incomplete));
            }
            if (string2.equals(OPT_INDEX)) {
                return String.valueOf(_CaseResult2.getIndex());
            }
        } else if (string.startsWith(FMT_TEST)) {
            Object object = map.get(FMT_TEST);
            if (object == null || !(object instanceof _CaseResult)) {
                return "--";
            }
            _CaseResult _CaseResult3 = (_CaseResult)object;
            String string3 = string.substring(FMT_TEST.length());
            if (string3.equals(OPT_NAME)) {
                return _CaseResult3.getName();
            }
            if (string3.equals(OPT_LASTNAME)) {
                return this.getClassLastName(_CaseResult3.getName());
            }
            if (string3.equals(OPT_PACKAGEDIR)) {
                return this.getPackageDir(_CaseResult3.getName());
            }
            if (string3.equals(OPT_MESSAGE)) {
                return _CaseResult3.getMessage();
            }
            if (string3.equals(OPT_TESTER)) {
                return this.testerName_;
            }
            if (string3.startsWith(OPT_DATE)) {
                if (string3.length() == OPT_DATE.length()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return simpleDateFormat.format(new Date());
                }
                try {
                    int n = string3.indexOf(44, OPT_DATE.length());
                    String string4 = string3.substring(n + 1).trim();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string4);
                    return simpleDateFormat.format(new Date());
                }
                catch (Exception exception) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return simpleDateFormat.format(new Date());
                }
            }
            if (string3.equals(OPT_JUDGE)) {
                return _CaseResult3.count(ResultType.NG) > 0 ? "reject" : "pass";
            }
            if (string3.equals(OPT_CHECK)) {
                return String.valueOf(_CaseResult3.countOfCheckResults());
            }
            if (string3.equals(OPT_GOOD)) {
                return String.valueOf(_CaseResult3.count(ResultType.OK));
            }
            if (string3.equals(OPT_NOGOOD)) {
                return String.valueOf(_CaseResult3.count(ResultType.NG));
            }
            if (string3.equals(OPT_KNOWNBUG)) {
                return String.valueOf(_CaseResult3.count(ResultType.KnownBug));
            }
            if (string3.equals(OPT_CHILD)) {
                return String.valueOf(_CaseResult3.countOfResults());
            }
            if (string3.equals(OPT_EMPTY)) {
                return String.valueOf(_CaseResult3.count(ResultType.Empty));
            }
            if (string3.equals(OPT_INCOMPLETE)) {
                return String.valueOf(_CaseResult3.count(ResultType.Incomplete));
            }
        }
        return "--";
    }

    protected String getPackageDir(String string) {
        assert (string != null) : "@param:className is null.";
        int n = string.lastIndexOf(46);
        if (n <= 0) {
            return ".";
        }
        return string.substring(0, n).replace('.', '/');
    }

    protected String getClassLastName(String string) {
        assert (string != null) : "@param:className is null.";
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        if (n >= string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    protected class _CaseResult
    extends CaseResult {
        private List<Result> resultLst_;
        private int index_;

        _CaseResult(String string, CaseResult caseResult) {
            super(string, caseResult);
            this.resultLst_ = new LinkedList<Result>();
            this.index_ = 0;
        }

        public List<Result> resultList() {
            return this.resultLst_;
        }

        @Override
        public int count(ResultType resultType) {
            assert (resultType != null) : "@param:type is null.";
            int n = 0;
            for (Result result : this.resultList()) {
                n += result.count(resultType);
            }
            return n;
        }

        @Override
        public void addChildResult(Result result) {
            assert (result != null) : "@param:result is null.";
            assert (result != this) : "@param:result == this";
            this.resultLst_.add(result);
            if (result instanceof _CaseResult) {
                _CaseResult _CaseResult2 = (_CaseResult)result;
                _CaseResult2.index_ = this.resultLst_.size();
            }
        }

        int getIndex() {
            return this.index_;
        }

        int countOfResults() {
            return this.resultLst_.size();
        }

        int countOfCheckResults() {
            return this.countOfCheckResults(this);
        }

        int countOfCheckResults(Result result) {
            assert (result != null) : "@param:result is null.";
            if (result instanceof CheckResult) {
                return 1;
            }
            if (result instanceof _CaseResult) {
                _CaseResult _CaseResult2 = (_CaseResult)result;
                int n = 0;
                for (Result result2 : _CaseResult2.resultLst_) {
                    n += this.countOfCheckResults(result2);
                }
                return n;
            }
            return 0;
        }
    }
}

