/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.coverage;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ts.tester.coverage.CaseResult;
import ts.tester.coverage.Coverage;
import ts.tester.coverage.PassResult;
import ts.tester.coverage.Result;

public class LineCoverage
extends Coverage {
    TreeMap<String, PassResult<Integer>> sourcePassMap_ = new TreeMap();
    TreeMap<String, Result<Integer>> classPassMap_ = new TreeMap();
    Map<String, Map<Coverage.MethodKey, Result<Integer>>> methodPassMap_ = new HashMap<String, Map<Coverage.MethodKey, Result<Integer>>>();

    public LineCoverage(Class<?> clazz) {
        super(clazz);
        this.setEventOfEntryMethodEnabled(false);
        this.setEventOfExitMethodEnabled(false);
    }

    public LineCoverage(Class<?> clazz, String string) {
        super(clazz, string);
        this.setEventOfEntryMethodEnabled(false);
        this.setEventOfExitMethodEnabled(false);
    }

    @Override
    protected void entryLine(Location location) {
        try {
            PassResult<Integer> passResult = this.getPassResult(location.sourcePath());
            ReferenceType referenceType = location.declaringType();
            Method method = location.method();
            Result<Integer> result = this.getClassResult(referenceType.name(), passResult);
            Result<Integer> result2 = this.getMethodResult(method, result);
            result2.addResult(location.lineNumber());
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    public Result<Integer> getMethodResult(Coverage.MethodKey methodKey, Result<Integer> result) {
        Result<Integer> result2;
        String string = methodKey.getClassName();
        Map<Coverage.MethodKey, Result<Integer>> map = this.methodPassMap_.get(string);
        if (map == null) {
            map = new HashMap<Coverage.MethodKey, Result<Integer>>();
            this.methodPassMap_.put(string, map);
        }
        if ((result2 = map.get(methodKey)) == null) {
            result2 = new CaseResult<Integer>(result);
            map.put(methodKey, result2);
        }
        return result2;
    }

    public Result<Integer> getMethodResult(Method method, Result<Integer> result) {
        String string = method.declaringType().name();
        String string2 = method.name();
        List<String> list = method.argumentTypeNames();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = list.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(",").append(iterator.next());
            }
        }
        Coverage.MethodKey methodKey = new Coverage.MethodKey(string, string2, stringBuffer.toString());
        return this.getMethodResult(methodKey, result);
    }

    public Result<Integer> getClassResult(String string, Result<Integer> result) {
        Result<Integer> result2 = this.classPassMap_.get(string);
        if (result2 == null) {
            result2 = new CaseResult<Integer>(result);
            this.classPassMap_.put(string, result2);
        }
        return result2;
    }

    public PassResult<Integer> getPassResult(String string) {
        PassResult<Integer> passResult = this.sourcePassMap_.get(string);
        if (passResult == null) {
            passResult = new PassResult();
            this.sourcePassMap_.put(string, passResult);
        }
        return passResult;
    }

    @Override
    protected void passLine(Location location) {
        try {
            PassResult<Integer> passResult = this.sourcePassMap_.get(location.sourcePath());
            if (passResult != null) {
                passResult.incrementPassCountOfResult(location.lineNumber());
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    @Override
    protected void entryClass(ReferenceType referenceType) {
    }

    @Override
    protected void entryMethod(Method method) {
    }

    @Override
    protected void exitMethod(Method method) {
    }

    @Override
    public Collection<String> allSourcePaths() {
        return this.sourcePassMap_.keySet();
    }

    @Override
    public Collection<String> allClassNames() {
        return this.classPassMap_.keySet();
    }

    @Override
    public Collection<Coverage.MethodKey> methodKeysOf(String string) {
        Map<Coverage.MethodKey, Result<Integer>> map = this.methodPassMap_.get(string);
        if (map != null) {
            return map.keySet();
        }
        return new ArrayList<Coverage.MethodKey>(0);
    }
}

