/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.coverage;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ts.tester.coverage.CoveragePrinter;
import ts.tester.coverage.ObjectWriter;
import ts.util.Trio;

public abstract class Coverage {
    private StringBuffer classPath_ = new StringBuffer();
    private String vmOptions_ = "";
    private Class<?> execClass_;
    private String commandArgs_;
    private String sourceBasePath_;
    private List<String> targetClassPatternLst_ = new LinkedList<String>();
    private List<String> exclusionClassPatternLst_ = new LinkedList<String>();
    private FilterType classFilterType_ = FilterType.ALLOW_DENY_ALLOW;
    private OutputStream outputStream_ = System.out;
    private OutputStream errorStream_ = System.err;
    private ObjectWriter objectWriter_ = DEFAULT_OBJECT_WRITER;
    private static ObjectWriter DEFAULT_OBJECT_WRITER = new ObjectWriter();
    private CoveragePrinter printer_ = CoveragePrinter.NULL;
    private boolean eventOfEntryMethodEnabled_ = true;
    private boolean eventOfExitMethodEnabled_ = true;

    public Coverage(Class<?> clazz) {
        this.setExecClass(clazz, "");
    }

    public Coverage(Class<?> clazz, String string) {
        this.setExecClass(clazz, string);
    }

    public void setPrinter(CoveragePrinter coveragePrinter) {
        assert (coveragePrinter != null) : "@param:printer is null.";
        this.printer_ = coveragePrinter;
    }

    public void setClassFilterType(FilterType filterType) {
        assert (filterType != null) : "@param:filterType is null.";
        this.classFilterType_ = filterType;
    }

    public void addClassPath(String string) {
        assert (string != null) : "@param:path is null.";
        if (this.classPath_.length() > 0) {
            this.classPath_.append(File.pathSeparator);
        }
        this.classPath_.append(string);
    }

    public void addTargetClassPattern(String string) {
        assert (string != null) : "@param:classPattern is null.";
        this.targetClassPatternLst_.add(string);
    }

    public void addExclusionClassPattern(String string) {
        assert (string != null) : "@param:classPattern is null.";
        this.exclusionClassPatternLst_.add(string);
    }

    public void setEventOfEntryMethodEnabled(boolean bl) {
        this.eventOfEntryMethodEnabled_ = bl;
    }

    public void setEventOfExitMethodEnabled(boolean bl) {
        this.eventOfExitMethodEnabled_ = bl;
    }

    public void setVMOptions(String string) {
        assert (string != null) : "@param:options is null.";
        this.vmOptions_ = string;
    }

    public void setExecClass(Class<?> clazz, String string) {
        assert (clazz != null) : "@param:execClass is null.";
        assert (string != null) : "@param:commandArgs is null.";
        assert (this.hasMainFunction(clazz)) : "@param;execClass does not have main function.";
        this.execClass_ = clazz;
        this.commandArgs_ = string;
    }

    public void setSourceBasePath(String string) {
        assert (string != null) : "@param:path is null.";
        this.sourceBasePath_ = string;
    }

    private boolean hasMainFunction(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("main", String[].class);
            int n = method.getModifiers();
            return Modifier.isStatic(n);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        assert (outputStream != null) : "@param:outstream is null.";
        this.outputStream_ = outputStream;
    }

    public void setErrorStream(OutputStream outputStream) {
        assert (outputStream != null) : "@param:errstream is null.";
        this.errorStream_ = outputStream;
    }

    public void setObjectWriter(ObjectWriter objectWriter) {
        assert (objectWriter != null) : "@param:objWriter is null.";
        this.objectWriter_ = objectWriter;
    }

    public void run() throws Exception {
        VirtualMachine virtualMachine = this.launchVM();
        this.prepareVM(virtualMachine);
        this.executeVM(virtualMachine);
    }

    protected VirtualMachine launchVM() throws IOException, VMStartException {
        LaunchingConnector launchingConnector = Bootstrap.virtualMachineManager().defaultConnector();
        Map<String, Connector.Argument> map = launchingConnector.defaultArguments();
        Connector.Argument argument = map.get("main");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.classPath_.length() > 0) {
            stringBuffer.append("-classpath \"").append(this.classPath_).append("\" ");
        }
        stringBuffer.append(this.vmOptions_).append(" ");
        stringBuffer.append(this.execClass_.getName());
        if (this.commandArgs_.length() > 0) {
            stringBuffer.append(" ").append(this.commandArgs_);
        }
        argument.setValue(stringBuffer.toString());
        try {
            return launchingConnector.launch(map);
        }
        catch (VMStartException vMStartException) {
            throw vMStartException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.setStackTrace(exception.getStackTrace());
            throw iOException;
        }
    }

    protected void prepareVM(VirtualMachine virtualMachine) {
        assert (virtualMachine != null) : "@param:vm is null.";
        virtualMachine.setDebugTraceMode(0);
        this.enableEventRequest(virtualMachine);
        this.printer_.prepareCoverage(this);
    }

    private void enableEventRequest(VirtualMachine virtualMachine) {
        EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
        if (FilterType.ALLOW_DENY_ALLOW.equals((Object)this.classFilterType_)) {
            ClassPrepareRequest classPrepareRequest = eventRequestManager.createClassPrepareRequest();
            MethodEntryRequest methodEntryRequest = eventRequestManager.createMethodEntryRequest();
            MethodExitRequest methodExitRequest = eventRequestManager.createMethodExitRequest();
            classPrepareRequest.setSuspendPolicy(2);
            methodEntryRequest.setSuspendPolicy(2);
            methodExitRequest.setSuspendPolicy(2);
            for (String string : this.exclusionClassPatternLst_) {
                classPrepareRequest.addClassExclusionFilter(string);
                methodEntryRequest.addClassExclusionFilter(string);
                methodExitRequest.addClassExclusionFilter(string);
            }
            classPrepareRequest.enable();
            methodEntryRequest.setEnabled(this.eventOfEntryMethodEnabled_);
            methodExitRequest.setEnabled(this.eventOfExitMethodEnabled_);
            for (String string : this.targetClassPatternLst_) {
                ClassPrepareRequest classPrepareRequest2 = eventRequestManager.createClassPrepareRequest();
                MethodEntryRequest methodEntryRequest2 = eventRequestManager.createMethodEntryRequest();
                MethodExitRequest methodExitRequest2 = eventRequestManager.createMethodExitRequest();
                classPrepareRequest2.setSuspendPolicy(2);
                methodEntryRequest2.setSuspendPolicy(2);
                methodExitRequest2.setSuspendPolicy(2);
                classPrepareRequest2.addClassFilter(string);
                methodEntryRequest2.addClassFilter(string);
                methodExitRequest2.addClassFilter(string);
                classPrepareRequest2.enable();
                methodEntryRequest2.setEnabled(this.eventOfEntryMethodEnabled_);
                methodExitRequest2.setEnabled(this.eventOfExitMethodEnabled_);
            }
        } else {
            ClassPrepareRequest classPrepareRequest = eventRequestManager.createClassPrepareRequest();
            MethodEntryRequest methodEntryRequest = eventRequestManager.createMethodEntryRequest();
            MethodExitRequest methodExitRequest = eventRequestManager.createMethodExitRequest();
            classPrepareRequest.setSuspendPolicy(2);
            methodEntryRequest.setSuspendPolicy(2);
            methodExitRequest.setSuspendPolicy(2);
            classPrepareRequest.addClassExclusionFilter("*");
            methodEntryRequest.addClassExclusionFilter("*");
            methodExitRequest.addClassExclusionFilter("*");
            classPrepareRequest.enable();
            methodEntryRequest.setEnabled(this.eventOfEntryMethodEnabled_);
            methodExitRequest.setEnabled(this.eventOfExitMethodEnabled_);
            for (String string : this.targetClassPatternLst_) {
                ClassPrepareRequest classPrepareRequest3 = eventRequestManager.createClassPrepareRequest();
                MethodEntryRequest methodEntryRequest3 = eventRequestManager.createMethodEntryRequest();
                MethodExitRequest methodExitRequest3 = eventRequestManager.createMethodExitRequest();
                classPrepareRequest3.setSuspendPolicy(2);
                methodEntryRequest3.setSuspendPolicy(2);
                methodExitRequest3.setSuspendPolicy(2);
                classPrepareRequest3.addClassFilter(string);
                methodEntryRequest3.addClassFilter(string);
                methodExitRequest3.addClassFilter(string);
                for (String string2 : this.exclusionClassPatternLst_) {
                    classPrepareRequest3.addClassExclusionFilter(string2);
                    methodEntryRequest3.addClassExclusionFilter(string2);
                    methodExitRequest3.addClassExclusionFilter(string2);
                }
                classPrepareRequest3.enable();
                methodEntryRequest3.setEnabled(this.eventOfEntryMethodEnabled_);
                methodExitRequest3.setEnabled(this.eventOfExitMethodEnabled_);
            }
        }
    }

    protected void executeVM(VirtualMachine virtualMachine) throws Exception {
        assert (virtualMachine != null) : "@param:vm is null.";
        Process process = virtualMachine.process();
        StreamRedirectThread streamRedirectThread = new StreamRedirectThread(process.getInputStream(), this.outputStream_);
        StreamRedirectThread streamRedirectThread2 = new StreamRedirectThread(process.getErrorStream(), this.errorStream_);
        streamRedirectThread.start();
        streamRedirectThread2.start();
        boolean bl = true;
        block5: while (bl) {
            EventQueue eventQueue = virtualMachine.eventQueue();
            EventSet eventSet = null;
            try {
                eventSet = eventQueue.remove();
                for (Event event : eventSet) {
                    this.handleEvent(event);
                    if (!(event instanceof VMDisconnectEvent) && !(event instanceof VMDeathEvent)) continue;
                    bl = false;
                    continue block5;
                }
            }
            catch (Exception exception) {
                bl = false;
                throw exception;
            }
            finally {
                if (eventSet == null) continue;
                eventSet.resume();
            }
        }
        streamRedirectThread.join();
        streamRedirectThread2.join();
        this.printer_.postCoverage(this);
    }

    protected void handleEvent(Event event) throws Exception {
        if (event instanceof ClassPrepareEvent) {
            ClassPrepareEvent classPrepareEvent = (ClassPrepareEvent)event;
            ReferenceType referenceType = classPrepareEvent.referenceType();
            this.entryClass(referenceType);
            this.printer_.entryClass(referenceType);
            VirtualMachine virtualMachine = referenceType.virtualMachine();
            EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
            for (Location location : referenceType.allLineLocations()) {
                BreakpointRequest breakpointRequest = eventRequestManager.createBreakpointRequest(location);
                breakpointRequest.setSuspendPolicy(2);
                breakpointRequest.enable();
                this.entryLine(location);
                this.printer_.entryLine(location);
            }
        } else if (event instanceof MethodEntryEvent) {
            MethodEntryEvent methodEntryEvent = (MethodEntryEvent)event;
            com.sun.jdi.Method method = methodEntryEvent.method();
            this.entryMethod(method);
            this.printer_.entryMethod(method);
        } else if (event instanceof MethodExitEvent) {
            MethodExitEvent methodExitEvent = (MethodExitEvent)event;
            com.sun.jdi.Method method = methodExitEvent.method();
            this.exitMethod(method);
            this.printer_.exitMethod(method);
        } else if (event instanceof BreakpointEvent) {
            BreakpointEvent breakpointEvent = (BreakpointEvent)event;
            this.passLine(breakpointEvent.location());
            this.printer_.passLine(breakpointEvent.location());
        }
    }

    protected abstract void entryLine(Location var1);

    protected abstract void passLine(Location var1);

    protected abstract void entryClass(ReferenceType var1);

    protected abstract void entryMethod(com.sun.jdi.Method var1);

    protected abstract void exitMethod(com.sun.jdi.Method var1);

    public abstract Collection<String> allSourcePaths();

    public abstract Collection<String> allClassNames();

    public abstract Collection<MethodKey> methodKeysOf(String var1);

    public static class MethodKey
    extends Trio<String, String, String>
    implements Comparable {
        static final long serialVersionUID = -8984651534984062853L;

        public MethodKey(String string, String string2, String string3) {
            assert (string != null) : "@param:className is null.";
            assert (string2 != null) : "@param:methodName is null.";
            assert (string3 != null) : "@param:argTypeNames is null.";
            this.set(string, string2, string3);
        }

        public String getClassName() {
            return (String)this.getFirst();
        }

        public String getMethodName() {
            return (String)this.getSecond();
        }

        public String getArgTypeNames() {
            return (String)this.getThird();
        }

        public int compareTo(Object object) throws NullPointerException, ClassCastException {
            MethodKey methodKey = (MethodKey)object;
            int n = ((String)this.getFirst()).compareTo((String)methodKey.getFirst());
            if (n != 0) {
                return n;
            }
            n = ((String)this.getSecond()).compareTo((String)methodKey.getSecond());
            if (n != 0) {
                return n;
            }
            return ((String)this.getThird()).compareTo((String)methodKey.getThird());
        }
    }

    private class StreamRedirectThread
    extends Thread {
        private final InputStreamReader streamReader_;
        private final OutputStreamWriter streamWriter_;
        private static final int BUFFER_SIZE = 524288;

        StreamRedirectThread(InputStream inputStream, OutputStream outputStream) {
            assert (inputStream != null) : "@param:in is null.";
            assert (outputStream != null) : "@param:outin is null.";
            this.streamReader_ = new InputStreamReader(inputStream);
            this.streamWriter_ = new OutputStreamWriter(outputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Coverage.this.objectWriter_.setStreamWriter(this.streamWriter_);
            char[] cArray = new char[524288];
            while (true) {
                InputStreamReader inputStreamReader = this.streamReader_;
                synchronized (inputStreamReader) {
                    try {
                        int n = this.streamReader_.read(cArray, 0, cArray.length);
                        if (n < 0) {
                            break;
                        }
                        Coverage.this.objectWriter_.writeObjectOrStream(cArray, n);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    public static enum FilterType {
        ALLOW_DENY_ALLOW,
        DENY_ALLOW_DENY;

    }
}

