/*
 * Decompiled with CFR 0.152.
 */
package ts.util.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ts.util.resource.AbstractResource;
import ts.util.resource.IllegalKeyException;
import ts.util.resource.Resource;
import ts.util.text.StringOperation;
import ts.util.text.StringSequence;

public class XmlResource
extends AbstractResource {
    private Document document_;
    private Node baseNode_;
    private boolean isValidating_ = true;

    public XmlResource() {
        this.renew();
    }

    public XmlResource(String string) throws FileNotFoundException, IOException {
        this.load(string);
    }

    protected XmlResource(XmlResource xmlResource) {
        super(xmlResource);
        this.document_ = xmlResource.document_;
        this.baseNode_ = xmlResource.baseNode_;
    }

    public void setValidating(boolean bl) {
        this.isValidating_ = bl;
    }

    protected Document getDocument() {
        return this.document_;
    }

    protected Node getBaseNode() {
        return this.baseNode_;
    }

    @Override
    public String getBaseElementName() {
        return this.getBaseNode().getLocalName();
    }

    protected Node findFirstNode(String string) throws IllegalKeyException {
        assert (string != null) : "@param:key is null.";
        if (StringOperation.isEmpty(string)) {
            return this.getBaseNode();
        }
        List<String> list = this.splitKey(string);
        return this.findFirstNode(this.getBaseNode(), list, 0);
    }

    private Node findFirstNode(Node node, List<String> list, int n) throws NullPointerException, IndexOutOfBoundsException {
        if (n >= list.size()) {
            return node;
        }
        String string = list.get(n);
        String string2 = this.getNameOfKeyElement(string);
        List<String[]> list2 = this.listAttributesOfKeyElement(string);
        block0: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            if (node2.getNodeType() != 1 || !string2.equals("*") && !string2.equals(node2.getLocalName())) continue;
            if (list2.size() > 0) {
                object = node2.getAttributes();
                for (String[] stringArray : list2) {
                    Node node3 = object.getNamedItem(stringArray[0]);
                    if (node3 != null && stringArray[1].equals(node3.getNodeValue())) continue;
                    continue block0;
                }
            }
            if ((object = this.findFirstNode(node2, list, n + 1)) == null) continue;
            return object;
        }
        return null;
    }

    protected List<Node> findAllNodes(String string) throws IllegalKeyException {
        assert (string != null) : "@param:key is null.";
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (StringOperation.isEmpty(string)) {
            linkedList.add(this.getBaseNode());
            return linkedList;
        }
        List<String> list = this.splitKey(string);
        this.findAllNodes(linkedList, this.getBaseNode(), list, 0);
        return linkedList;
    }

    private void findAllNodes(List<Node> list, Node node, List<String> list2, int n) throws NullPointerException, IndexOutOfBoundsException {
        if (n >= list2.size()) {
            list.add(node);
            return;
        }
        String string = list2.get(n);
        String string2 = this.getNameOfKeyElement(string);
        List<String[]> list3 = this.listAttributesOfKeyElement(string);
        block0: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !string2.equals("*") && !string2.equals(node2.getLocalName())) continue;
            if (list3.size() > 0) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                for (String[] stringArray : list3) {
                    Node node3 = namedNodeMap.getNamedItem(stringArray[0]);
                    if (node3 != null && stringArray[1].equals(node3.getNodeValue())) continue;
                    continue block0;
                }
            }
            this.findAllNodes(list, node2, list2, n + 1);
        }
    }

    protected Node findOrCreateFirstNode(String string) throws IllegalKeyException {
        Object object;
        int n;
        assert (string != null) : "@param:key is null.";
        if (StringOperation.isEmpty(string)) {
            return this.getBaseNode();
        }
        List<String> list = this.splitKey(string);
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("");
        Object object2 = this.getBaseNode();
        for (n = 0; n < list.size(); ++n) {
            arrayList.set(0, list.get(n));
            object = this.findFirstNode((Node)object2, arrayList, 0);
            if (object == null) break;
            object2 = object;
        }
        while (n < list.size()) {
            object = list.get(n);
            String string2 = this.getNameOfKeyElement((String)object);
            List<String[]> list2 = this.listAttributesOfKeyElement((String)object);
            Element element = this.getDocument().createElementNS(object2.getNamespaceURI(), string2);
            for (String[] stringArray : list2) {
                element.setAttribute(stringArray[0], stringArray[1]);
            }
            object2.appendChild(element);
            object2 = element;
            ++n;
        }
        return object2;
    }

    protected String getNodeText(Node node) {
        if (node == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() > 0) {
            Node node2 = nodeList.item(0);
            switch (node2.getNodeType()) {
                case 4: {
                    stringBuilder.append(node2.getNodeValue());
                    break;
                }
                case 3: {
                    stringBuilder.append(this.shortenWhitespace(node2.getNodeValue()));
                }
            }
            block8: for (int i = 1; i < nodeList.getLength(); ++i) {
                node2 = nodeList.item(i);
                switch (node2.getNodeType()) {
                    case 4: {
                        String string = node2.getNodeValue();
                        if (StringOperation.isEmpty(string)) continue block8;
                        stringBuilder.append(" ").append(string);
                        continue block8;
                    }
                    case 3: {
                        String string = this.shortenWhitespace(node2.getNodeValue());
                        if (StringOperation.isEmpty(string)) continue block8;
                        stringBuilder.append(" ").append(string);
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    protected String shortenWhitespace(String string) {
        assert (string != null) : "@param:s is null.";
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringSequence stringSequence = new StringSequence(string).skipWhitespaces();
        while (stringSequence.validIndex()) {
            if (stringSequence.index() != stringSequence.skipWhitespaces().index()) {
                if (!stringSequence.validIndex()) break;
                stringBuilder.append(" ");
            }
            stringBuilder.append(stringSequence.character());
            stringSequence.next();
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized String getFirstValue(String string) throws IllegalKeyException {
        return this.getNodeText(this.findFirstNode(string));
    }

    @Override
    public synchronized List<String> getValues(String string) throws IllegalKeyException {
        List<Node> list = this.findAllNodes(string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Node node : list) {
            arrayList.add(this.getNodeText(node));
        }
        return arrayList;
    }

    @Override
    public synchronized String getFirstAttribute(String string, String string2) throws IllegalKeyException {
        assert (string2 != null) : "@param:attr is null.";
        Node node = this.findFirstNode(string);
        if (node == null) {
            return this.getNodeText(null);
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return this.getNodeText(null);
        }
        return this.getNodeText(namedNodeMap.getNamedItem(string2));
    }

    @Override
    public synchronized List<String> getAttributes(String string, String string2) throws IllegalKeyException {
        assert (string2 != null) : "@param:attr is null.";
        List<Node> list = this.findAllNodes(string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Node node : list) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null) {
                arrayList.add(this.getNodeText(null));
                continue;
            }
            arrayList.add(this.getNodeText(namedNodeMap.getNamedItem(string2)));
        }
        return arrayList;
    }

    @Override
    public synchronized Resource getFirstChild(String string) throws IllegalKeyException {
        Node node = this.findFirstNode(string);
        if (node == null) {
            return Resource.EMPTY;
        }
        XmlResource xmlResource = new XmlResource(this);
        xmlResource.baseNode_ = node;
        return xmlResource;
    }

    @Override
    public synchronized List<Resource> getChildren(String string) throws IllegalKeyException {
        List<Node> list = this.findAllNodes(string);
        ArrayList<Resource> arrayList = new ArrayList<Resource>(list.size());
        for (Node node : list) {
            XmlResource xmlResource = new XmlResource(this);
            xmlResource.baseNode_ = node;
            arrayList.add(xmlResource);
        }
        return arrayList;
    }

    @Override
    public synchronized void setFirstValue(String string, String string2) throws IllegalKeyException {
        assert (string2 != null) : "@param:value is null.";
        try {
            Node node = this.findOrCreateFirstNode(string);
            CDATASection cDATASection = this.getDocument().createCDATASection(string2);
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 3 && node2.getNodeType() != 4) continue;
                node.removeChild(node2);
            }
            node.appendChild(cDATASection);
        }
        catch (IllegalKeyException illegalKeyException) {
            throw illegalKeyException;
        }
        catch (Exception exception) {
            throw new IllegalKeyException(string, exception);
        }
    }

    @Override
    public synchronized Resource getOrCreateFirstChild(String string) throws IllegalKeyException {
        Node node = this.findOrCreateFirstNode(string);
        XmlResource xmlResource = new XmlResource(this);
        xmlResource.baseNode_ = node;
        return xmlResource;
    }

    @Override
    public synchronized void removeChildren(String string) throws IllegalKeyException {
        List<Node> list = this.findAllNodes(string);
        for (Node node : list) {
            Node node2 = node.getParentNode();
            if (node2 == null) continue;
            node2.removeChild(node);
        }
        if (StringOperation.isEmpty(string)) {
            this.renew();
        }
    }

    public synchronized List<Object> getValuesAndChildren() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Node node = this.getBaseNode();
        block5: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    XmlResource xmlResource = new XmlResource(this);
                    xmlResource.baseNode_ = node2;
                    linkedList.add(xmlResource);
                    continue block5;
                }
                case 4: {
                    linkedList.add(node2.getNodeValue());
                    continue block5;
                }
                case 3: {
                    String string = node2.getNodeValue().trim();
                    if (string.length() == 0) continue block5;
                    linkedList.add(this.shortenWhitespace(string));
                }
            }
        }
        return linkedList;
    }

    private void renew() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document_ = documentBuilder.newDocument();
            this.baseNode_ = this.document_;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void load(InputStream inputStream) throws IOException {
        assert (inputStream != null) : "@param:stream is null.";
        try {
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            this.document_ = documentBuilder.parse(inputStream);
            this.baseNode_ = this.document_;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.setStackTrace(exception.getStackTrace());
            throw iOException;
        }
    }

    protected DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(this.isValidating_);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (!documentBuilderFactory.isValidating()) {
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        return documentBuilder;
    }

    @Override
    public void save(OutputStream outputStream) throws IOException {
        assert (outputStream != null) : "@param:stream is null.";
        if (this.getBaseNode() != this.getDocument()) {
            throw new UnsupportedOperationException("XmlResource class cannot save a child resource.");
        }
        try {
            DocumentType documentType = this.getDocument().getDoctype();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("doctype-system", documentType.getSystemId());
            transformer.setOutputProperty("doctype-public", documentType.getPublicId() != null ? documentType.getPublicId() : "");
            Properties properties = transformer.getOutputProperties();
            properties.setProperty("encoding", this.getDocument().getXmlEncoding());
            transformer.setOutputProperties(properties);
            DOMSource dOMSource = new DOMSource(this.getBaseNode());
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.setStackTrace(exception.getStackTrace());
            throw iOException;
        }
    }
}

