/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.serializer.handler.patch;

import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.serializer.handler.patch.AbstractSerializerHandler;

public class Patch031SerializerHandler
extends AbstractSerializerHandler {
    @Override
    public String handleBeforeDeserialize(String in) {
        this.logger.info("handleBeforeDeserialize");
        if (this.versionUnderEqual(in, 0, 3, 0)) {
            return this.fixIdentifierSpell(in);
        }
        return in;
    }

    @Override
    public Diagram handleAfterDeserialize(Diagram in) {
        if (this.versionUnderEqual(in, 0, 3, 0)) {
            this.logger.info("apply patch 0.3.1");
            for (ModelElement o : in.getChildren()) {
                if (!(o instanceof Detail)) continue;
                Detail model = (Detail)o;
                model.setDetailIdentifierEnabled(true);
            }
        }
        return in;
    }

    private String fixIdentifierSpell(String in) {
        String out1 = in.replace("Identifires", "Identifiers");
        String out2 = out1.replace("identifires", "identifiers");
        String out3 = out2.replace("Identifieres", "Identifiers");
        String out4 = out3.replace("identifieres", "identifiers");
        return out4;
    }
}

