/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.treeeditpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.property.AttributePropertySource;
import jp.sourceforge.tmdmaker.property.IPropertyAvailable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener,
IPropertyAvailable {
    private static Logger logger = LoggerFactory.getLogger(AttributeTreeEditPart.class);
    protected EditPolicy componentPolicy;

    public AttributeTreeEditPart(Attribute attribute, EditPolicy policy) {
        this.setModel(attribute);
        this.componentPolicy = policy;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", this.componentPolicy);
    }

    public Attribute getModel() {
        return (Attribute)super.getModel();
    }

    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            Command ccommand = this.getCommand(request);
            this.executeEditCommand(ccommand);
        }
    }

    protected void executeEditCommand(Command command) {
        this.getViewer().getEditDomain().getCommandStack().execute(command);
    }

    protected String getText() {
        Attribute model = this.getModel();
        if (model.getName() == null) {
            return "";
        }
        return model.getName();
    }

    protected Image getImage() {
        return TMDPlugin.getImage("icons/outline/attribute.png");
    }

    public void activate() {
        super.activate();
        this.getModel().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        this.getModel().removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug(this.getClass() + "." + evt.getPropertyName());
        if (evt.getPropertyName().equals("_property_name")) {
            this.refreshVisuals();
        } else {
            logger.warn("Not Handle Event Occured.");
        }
    }

    @Override
    public IPropertySource getPropertySource(TMDEditor editor) {
        return new AttributePropertySource(editor, this.getModel());
    }
}

