/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.action.AbstractMultipleSelectionAction;
import jp.sourceforge.tmdmaker.editpart.AbstractModelEditPart;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.ConstraintConverter;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ConstraintChangeCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IWorkbenchPart;

public class AutoSizeSettingAction
extends AbstractMultipleSelectionAction {
    public static final String ID = "AutoSizeSettingAction";

    public AutoSizeSettingAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.AutomaticSizeAdjustment);
        this.setId(ID);
    }

    public void run() {
        CompoundCommand ccommand = new CompoundCommand();
        for (ConnectableElement m : this.getSelectedElementList()) {
            ccommand.add((Command)new ConstraintChangeCommand((ModelElement)m, ConstraintConverter.getResetRectangle((ModelElement)m)));
        }
        if (!ccommand.isEmpty()) {
            this.execute(ccommand.unwrap());
        }
    }

    @Override
    protected boolean isTargetModel(Object selection) {
        if (selection instanceof AbstractModelEditPart) {
            return ((AbstractModelEditPart)selection).canAutoSize();
        }
        return false;
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getSelectedElementList().size() >= 1;
    }

    protected List<ConnectableElement> getSelectedElementList() {
        ArrayList<ConnectableElement> list = new ArrayList<ConnectableElement>();
        for (Object selection : this.getSelectedObjects()) {
            Object model;
            if (!this.isTargetModel(selection) || !((model = ((AbstractModelEditPart)selection).getModel()) instanceof ConnectableElement)) continue;
            list.add((ConnectableElement)model);
        }
        return list;
    }
}

