/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.value.AbstractValue;
import org.w3c.dom.DOMException;

public class ICCColor
extends AbstractValue {
    protected String colorProfile;
    protected int count;
    protected float[] colors = new float[5];

    public ICCColor(String string) {
        this.colorProfile = string;
    }

    public short getCssValueType() {
        return 3;
    }

    public String getColorProfile() throws DOMException {
        return this.colorProfile;
    }

    public int getNumberOfColors() throws DOMException {
        return this.count;
    }

    public float getColor(int n) throws DOMException {
        return this.colors[n];
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("icc-color(");
        stringBuffer.append(this.colorProfile);
        int n = 0;
        while (n < this.count) {
            stringBuffer.append(", ");
            stringBuffer.append(this.colors[n]);
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void append(float f) {
        if (this.count == this.colors.length) {
            float[] fArray = new float[this.count * 2];
            int n = 0;
            while (n < this.count) {
                fArray[n] = this.colors[n];
                ++n;
            }
            this.colors = fArray;
        }
        this.colors[this.count++] = f;
    }
}

