/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.graphics.GraphicsToGraphics2DAdaptor;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGColorConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.DrawableRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderingListener;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GraphicsSVG
extends GraphicsToGraphics2DAdaptor
implements DrawableRenderedImage {
    private Document doc;

    public static GraphicsSVG getInstance(Rectangle viewPort) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNameSpace = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNameSpace, "svg", null);
        SVGGraphics2D svgGraphics = new SVGGraphics2D(doc);
        svgGraphics.getGeneratorContext().setPrecision(3);
        svgGraphics.setSVGCanvasSize(new Dimension(viewPort.width, viewPort.height));
        return new GraphicsSVG(svgGraphics, doc, svgNameSpace, viewPort);
    }

    public SVGGraphics2D getSVGGraphics2D() {
        return (SVGGraphics2D)this.getGraphics2D();
    }

    private GraphicsSVG(SVGGraphics2D graphics, Document doc, String svgNameSpace, Rectangle viewPort) {
        this(graphics, doc, svgNameSpace, new org.eclipse.swt.graphics.Rectangle(viewPort.x, viewPort.y, viewPort.width, viewPort.height));
    }

    private GraphicsSVG(SVGGraphics2D graphics, Document doc, String svgNameSpace, org.eclipse.swt.graphics.Rectangle viewPort) {
        super((Graphics2D)graphics, viewPort);
        this.doc = doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getRoot() {
        return this.getSVGGraphics2D().getRoot();
    }

    @Override
    public RenderedImage drawRenderedImage(RenderedImage srcImage, Rectangle rect, RenderingListener listener) {
        this.checkState();
        DOMTreeManager treeManager = this.getSVGGraphics2D().getDOMTreeManager();
        Point trans = this.getTranslationOffset();
        if (srcImage instanceof SVGImage) {
            RenderInfo info;
            Document document = ((SVGImage)srcImage).getDocument();
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            if ((document = DOMUtilities.deepCloneDocument((Document)document, (DOMImplementation)impl)) instanceof SVGOMDocument && (info = srcImage.getRenderInfo()) != null && info.getBackgroundColor() != null && info.getForegroundColor() != null) {
                SVGColorConverter.getInstance().replaceDocumentColors((SVGOMDocument)document, new Color(info.getBackgroundColor().red, info.getBackgroundColor().green, info.getBackgroundColor().blue), new Color(info.getForegroundColor().red, info.getForegroundColor().green, info.getForegroundColor().blue));
            }
            Element root = document.getDocumentElement();
            Element toAppend = (Element)this.doc.importNode(root, true);
            toAppend.setAttributeNS(null, "x", String.valueOf(rect.x + trans.x));
            toAppend.setAttributeNS(null, "y", String.valueOf(rect.y + trans.y));
            toAppend.setAttributeNS(null, "width", String.valueOf(rect.width));
            toAppend.setAttributeNS(null, "height", String.valueOf(rect.height));
            treeManager.appendGroup(toAppend, null);
            return srcImage;
        }
        return super.drawRenderedImage(srcImage, rect, listener);
    }
}

