/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.component.AttributeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.ImplementInfoSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.TableNameSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.dialog.model.EditVirtualEntity;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.VirtualEntity;
import jp.sourceforge.tmdmaker.model.VirtualEntityType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VirtualEntityEditDialog
extends Dialog
implements PropertyChangeListener {
    private EditVirtualEntity entity;
    private VirtualEntity editedValue;
    private TableNameSettingPanel panel1;
    private AttributeSettingPanel panel2;
    private ImplementInfoSettingPanel panel3;
    private Combo typeCombo;

    public VirtualEntityEditDialog(Shell parentShell, VirtualEntity original) {
        super(parentShell);
        this.entity = new EditVirtualEntity(original);
        this.entity.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Button okButton;
        if (evt.getPropertyName().equals("_edit_property_attributes")) {
            this.panel2.updateAttributeTable();
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(this.entity.isValid());
        }
    }

    public boolean close() {
        this.entity.removePropertyChangeListener(this);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u307f\u306a\u3057\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u7de8\u96c6");
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new TableNameSettingPanel(composite, 0, this.entity);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        this.typeCombo = new Combo(composite, 8);
        this.typeCombo.add("\u901a\u5e38");
        this.typeCombo.add("\u30ea\u30bd\u30fc\u30b9\u30bf\u30a4\u30d7");
        this.typeCombo.add("\u30a4\u30d9\u30f3\u30c8\u30bf\u30a4\u30d7");
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VirtualEntityEditDialog.this.entity.setVirtualEntityType(VirtualEntityType.values()[VirtualEntityEditDialog.this.typeCombo.getSelectionIndex()]);
            }
        });
        this.panel3 = new ImplementInfoSettingPanel(composite, 0, this.entity);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.panel3.setLayoutData(gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.panel2 = new AttributeSettingPanel(composite, 0, this.entity);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        this.initializeTypeCombo();
        return composite;
    }

    private void initializeTypeCombo() {
        this.typeCombo.select(this.entity.getVirtualEntityType().ordinal());
    }

    protected void okPressed() {
        this.editedValue = (VirtualEntity)this.entity.createEditedModel();
        super.okPressed();
    }

    public List<EditAttribute> getEditAttributeList() {
        return this.entity.getAttributes();
    }

    public AbstractEntityModel getEditedValue() {
        return this.editedValue;
    }
}

