/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker;

import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.List;
import jp.sourceforge.tmdmaker.TMDContextMenuProvider;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.action.AbstractEntitySelectionAction;
import jp.sourceforge.tmdmaker.action.AutoSizeSettingAction;
import jp.sourceforge.tmdmaker.action.CommonAttributeSettingAction;
import jp.sourceforge.tmdmaker.action.DatabaseSelectAction;
import jp.sourceforge.tmdmaker.action.DiagramImageGenerateAction;
import jp.sourceforge.tmdmaker.action.FileImportAction;
import jp.sourceforge.tmdmaker.action.GenerateAction;
import jp.sourceforge.tmdmaker.action.ImplementInfoEditAction;
import jp.sourceforge.tmdmaker.action.MultivalueAndCreateAction;
import jp.sourceforge.tmdmaker.action.MultivalueOrCreateAction;
import jp.sourceforge.tmdmaker.action.SubsetCreateAction;
import jp.sourceforge.tmdmaker.action.SubsetTypeTurnAction;
import jp.sourceforge.tmdmaker.action.VirtualEntityCreateAction;
import jp.sourceforge.tmdmaker.action.VirtualSupersetCreateAction;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpart.DiagramEditPart;
import jp.sourceforge.tmdmaker.editpart.TMDEditPartFactory;
import jp.sourceforge.tmdmaker.generate.Generator;
import jp.sourceforge.tmdmaker.generate.GeneratorProvider;
import jp.sourceforge.tmdmaker.importer.impl.AttributeFileImporter;
import jp.sourceforge.tmdmaker.importer.impl.EntityFileImporter;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.Version;
import jp.sourceforge.tmdmaker.persistence.SerializationException;
import jp.sourceforge.tmdmaker.persistence.Serializer;
import jp.sourceforge.tmdmaker.persistence.SerializerFactory;
import jp.sourceforge.tmdmaker.ruler.TMDRulerProvider;
import jp.sourceforge.tmdmaker.ruler.model.RulerModel;
import jp.sourceforge.tmdmaker.tool.EntityCreationTool;
import jp.sourceforge.tmdmaker.tool.MovableSelectionTool;
import jp.sourceforge.tmdmaker.tool.TMDConnectionCreationTool;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ToggleRulerVisibilityAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDEditor
extends GraphicalEditorWithPalette
implements IResourceChangeListener {
    private static Logger logger = LoggerFactory.getLogger(TMDEditor.class);
    private RulerComposite rulerComp;

    public TMDEditor() {
        logger.debug("{} is instanciate.", TMDEditor.class);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new RulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    protected void initializeGraphicalViewer() {
        logger.debug(((Object)((Object)this)).getClass() + "#initializeGraphicalViewer()");
        GraphicalViewer viewer = this.getGraphicalViewer();
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        Diagram diagram = null;
        try {
            Serializer serializer = SerializerFactory.getInstance();
            diagram = serializer.deserialize(file.getContents());
        }
        catch (Exception e) {
            TMDPlugin.showErrorDialog("\u8aad\u307f\u8fbc\u307f\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
            diagram = new Diagram();
        }
        Version version = this.getPluginVersion();
        diagram.setVersion(version.getValue());
        viewer.setContents((Object)diagram);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    private Version getPluginVersion() {
        Bundle bundle = TMDPlugin.getDefault().getBundle();
        return new Version((String)bundle.getHeaders().get("Bundle-Version"));
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
    }

    protected PaletteRoot getPaletteRoot() {
        logger.debug("getPaletteRoot() called");
        PaletteRoot root = new PaletteRoot();
        PaletteGroup toolGroup = new PaletteGroup("\u30c4\u30fc\u30eb");
        SelectionToolEntry tool = new SelectionToolEntry();
        tool.setToolClass(MovableSelectionTool.class);
        toolGroup.add((PaletteEntry)tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        toolGroup.add((PaletteEntry)tool);
        PaletteDrawer drawer = new PaletteDrawer("\u4f5c\u6210");
        ImageDescriptor descriptor = TMDPlugin.getImageDescriptor("icons/new_entity.gif");
        CreationToolEntry creationEntry = new CreationToolEntry("\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3", "\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3", (CreationFactory)new SimpleFactory(Entity.class), descriptor, descriptor);
        creationEntry.setToolClass(EntityCreationTool.class);
        drawer.add((PaletteEntry)creationEntry);
        descriptor = TMDPlugin.getImageDescriptor("icons/new_relationship.gif");
        ConnectionCreationToolEntry connxCCreationEntry = new ConnectionCreationToolEntry("\u30ea\u30ec\u30fc\u30b7\u30e7\u30f3\u30b7\u30c3\u30d7", "\u30ea\u30ec\u30fc\u30b7\u30e7\u30f3\u30b7\u30c3\u30d7", null, descriptor, descriptor);
        connxCCreationEntry.setToolClass(TMDConnectionCreationTool.class);
        drawer.add((PaletteEntry)connxCCreationEntry);
        root.add((PaletteEntry)toolGroup);
        root.add((PaletteEntry)drawer);
        return root;
    }

    public void doSave(IProgressMonitor monitor) {
        logger.debug("doSave() called");
        Diagram diagram = (Diagram)this.getGraphicalViewer().getContents().getModel();
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        try {
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        }
        catch (CoreException e) {
            TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
            logger.warn("IFile#deleteMarkers()." + (Object)((Object)e));
        }
        try {
            Serializer serializer = SerializerFactory.getInstance();
            file.setContents(serializer.serialize(diagram), true, true, monitor);
        }
        catch (SerializationException e) {
            TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
            logger.warn("IFile#setContents().", (Throwable)e);
        }
        catch (CoreException e) {
            TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
            logger.warn("IFile#setContents().", (Throwable)e);
        }
        this.getCommandStack().markSaveLocation();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        logger.debug("doSaveAs() called");
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        try {
            new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    Diagram diagram = (Diagram)TMDEditor.this.getGraphicalViewer().getContents().getModel();
                    try {
                        Serializer serializer = SerializerFactory.getInstance();
                        file.create(serializer.serialize(diagram), true, monitor);
                    }
                    catch (SerializationException e) {
                        TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
                        logger.warn("IFile#setContents().", (Throwable)e);
                    }
                    catch (CoreException e) {
                        TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
                        logger.warn("IFile#setContents().", (Throwable)e);
                    }
                    TMDEditor.this.getCommandStack().markSaveLocation();
                    TMDEditor.this.setInput((IEditorInput)new FileEditorInput(file));
                }
            });
        }
        catch (InterruptedException e) {
            logger.warn("ProgressMonitorDialog#run().", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn("ProgressMonitorDialog#run().", (Throwable)e);
        }
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void createActions() {
        logger.debug("createAction() called");
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        List selectionActions = this.getSelectionActions();
        AbstractEntitySelectionAction selectionAction = new SubsetCreateAction((IWorkbenchPart)this);
        this.setupSelectionAction(registry, selectionActions, selectionAction);
        selectionAction = new SubsetTypeTurnAction((IWorkbenchPart)this);
        this.setupSelectionAction(registry, selectionActions, selectionAction);
        selectionAction = new MultivalueOrCreateAction((IWorkbenchPart)this);
        this.setupSelectionAction(registry, selectionActions, selectionAction);
        selectionAction = new MultivalueAndCreateAction((IWorkbenchPart)this);
        this.setupSelectionAction(registry, selectionActions, selectionAction);
        selectionAction = new VirtualEntityCreateAction((IWorkbenchPart)this);
        this.setupSelectionAction(registry, selectionActions, selectionAction);
        selectionAction = new VirtualSupersetCreateAction((IWorkbenchPart)this);
        this.setupSelectionAction(registry, selectionActions, selectionAction);
        selectionAction = new ImplementInfoEditAction((IWorkbenchPart)this);
        this.setupSelectionAction(registry, selectionActions, selectionAction);
        Object action = null;
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AutoSizeSettingAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    private void setupSelectionAction(ActionRegistry registry, List<String> selectionActions, SelectionAction selectionAction) {
        registry.registerAction((IAction)selectionAction);
        selectionActions.add(selectionAction.getId());
        selectionAction.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
    }

    protected void configureGraphicalViewer() {
        logger.debug("configureGraphicalViewer() called");
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setEditPartFactory((EditPartFactory)new TMDEditPartFactory());
        TMDContextMenuProvider provider = new TMDContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        ActionRegistry registry = this.getActionRegistry();
        DiagramImageGenerateAction action66 = new DiagramImageGenerateAction(viewer, (IWorkbenchPart)this);
        registry.registerAction((IAction)action66);
        List selectionActions = this.getSelectionActions();
        for (Generator generator : GeneratorProvider.getGenerators()) {
            GenerateAction act = new GenerateAction(this, viewer, generator);
            registry.registerAction((IAction)act);
            selectionActions.add(act.getId());
        }
        Action action = new DatabaseSelectAction(viewer);
        registry.registerAction((IAction)action);
        action = new CommonAttributeSettingAction(viewer);
        registry.registerAction((IAction)action);
        action = new FileImportAction(viewer, new EntityFileImporter());
        registry.registerAction((IAction)action);
        action = new FileImportAction(viewer, new AttributeFileImporter());
        registry.registerAction((IAction)action);
        action = new ToggleGridAction(viewer);
        registry.registerAction((IAction)action);
        action = new ToggleRulerVisibilityAction(viewer);
        this.getActionRegistry().registerAction((IAction)action);
        action = new ToggleSnapToGeometryAction(viewer);
        this.getActionRegistry().registerAction((IAction)action);
        this.loadProperties();
    }

    private void loadProperties() {
        TMDRulerProvider provider = new TMDRulerProvider(new RulerModel());
        this.getGraphicalViewer().setProperty("horizontal ruler", (Object)provider);
        provider = new TMDRulerProvider(new RulerModel());
        this.getGraphicalViewer().setProperty("vertical ruler", (Object)provider);
        this.getGraphicalViewer().setProperty("ruler$visibility", (Object)Boolean.FALSE);
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)Boolean.FALSE);
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return new TMDContentOutlinePage();
        }
        return super.getAdapter(type);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IEditorInput input;
        if (event.getType() == 1 && (input = this.getEditorInput()) instanceof IFileEditorInput) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IFile file = ((IFileEditorInput)input).getFile();
                    if (!file.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.closeEditor((IEditorPart)TMDEditor.this, true);
                    } else if (!TMDEditor.this.getPartName().equals(file.getName())) {
                        TMDEditor.this.setPartName(file.getName());
                    }
                }
            });
        }
    }

    public void updateVisuals() {
        List editParts = this.getGraphicalViewer().getRootEditPart().getChildren();
        for (Object o : editParts) {
            logger.debug(o.getClass().getName());
            if (o instanceof AbstractEntityEditPart) {
                ((AbstractEntityEditPart)o).updateAppearance();
                continue;
            }
            if (!(o instanceof DiagramEditPart)) continue;
            for (Object ob : ((DiagramEditPart)o).getChildren()) {
                if (!(ob instanceof AbstractEntityEditPart)) continue;
                ((AbstractEntityEditPart)ob).updateAppearance();
            }
        }
    }

    private class TMDContentOutlinePage
    extends ContentOutlinePage {
        private SashForm sash;
        private ScrollableThumbnail thumbnail;
        private DisposeListener disposeListener;

        public TMDContentOutlinePage() {
            super((EditPartViewer)new TreeViewer());
        }

        public void createControl(Composite parent) {
            this.sash = new SashForm(parent, 512);
            Canvas canvas = new Canvas((Composite)this.sash, 2048);
            LightweightSystem lws = new LightweightSystem(canvas);
            this.thumbnail = new ScrollableThumbnail((Viewport)((FreeformGraphicalRootEditPart)TMDEditor.this.getGraphicalViewer().getRootEditPart()).getFigure());
            this.thumbnail.setSource(((FreeformGraphicalRootEditPart)TMDEditor.this.getGraphicalViewer().getRootEditPart()).getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (TMDContentOutlinePage.this.thumbnail != null) {
                        TMDContentOutlinePage.this.thumbnail.deactivate();
                        TMDContentOutlinePage.this.thumbnail = null;
                    }
                }
            };
            TMDEditor.this.getGraphicalViewer().getControl().addDisposeListener(this.disposeListener);
        }

        public Control getControl() {
            return this.sash;
        }

        public void dispose() {
            if (TMDEditor.this.getGraphicalViewer().getControl() != null && !TMDEditor.this.getGraphicalViewer().getControl().isDisposed()) {
                TMDEditor.this.getGraphicalViewer().getControl().removeDisposeListener(this.disposeListener);
            }
            super.dispose();
        }
    }
}

