#!/usr/bin/perl
#------------------------------------------------------------------------------
#    ThreadPlus, simply forum CGI.
#    Copyright (C) 2012,2013 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------
use strict;
use warnings;

use CGI;
use Encode;

use HTML::Template;

require "config.cgi";
require "subs.cgi";

# ユーザーエージェントから携帯かどうかを判定
my $device = 'pc';
my $ua = $ENV{'HTTP_USER_AGENT'};
if (defined $ua && $ua =~ /\ADoCoMo|\AUP.Browser|\AKDDI|\AJ-PHONE|\AVodafone|\ASoftBank/) {
    $device = 'mobile';
}

my $cgi = CGI->new();
my $a = $cgi->param('a');
if (defined $a && $a eq 'exec') {
    _exec($cgi);
}
else {
    _view();
}

exit;

sub _view {
    _view_input('');
}

sub _exec {
    my ($cgi) = @_;

    my $sessionid = '';
    my $userpass = $cgi->param('userpass');
    if ($userpass eq get_pass()) {
        # 10000 ～ 99999 のセッションIDを生成
        my $sessionfile;
        while (1) {
            $sessionid = int(rand(89999)) + 10000;
            $sessionfile = get_session_dir() . "/$sessionid.txt";
            last if (!(-f $sessionfile));
        }

        my $uid = $ENV{'REMOTE_ADDR'};
        if ($device eq 'mobile') {
            $uid = _get_uid();
        }

        # セッションファイルを作成
        open my $sessionfh, '>', $sessionfile;
        print {$sessionfh} "$device,$uid\n";
        close $sessionfh;

        # ファイルのパーミッションを変更
        chmod 0766, $sessionfile;

        if ($device eq 'mobile') {
            print "Location: ./?s=$sessionid", "\n\n";
        }
        else {

            # Cookieを設定してリダイレクト
            my $redirect = './';
            my $html = <<"END_HTML";
<html>
<head>
<title>Redirecting...</title>
<script type="text/javascript">
<!--
var __onload_flag = window.onload;
window.onload = function() {
    if (__onload_flag) __onload_flag();
    location.href = '$redirect';
}
//-->
</script>
</head>
<body>
Redirecting...
</body>
</html>
END_HTML

            my $cookiename = get_cookie_name();
            my $cookie = "Set-Cookie: $cookiename=$sessionid\n";
            print "Content-Type: text/html\n";
            print "$cookie\n";
            print $html;
        }
    }
    else {
        _view_input('パスワードが間違っています');
    }
}

sub _view_input {
    my ($msg) = @_;

    my $template = HTML::Template->new(filename => get_tmpl_dir() . '/pass.tmpl');

    $template->param(SITETITLE => get_site_title());
    if ($device eq 'mobile') {
        $template->param(CHARSET => 'SHIFT_JIS');
    }
    else {
        $template->param(CHARSET => 'UTF-8');
    }

    my $pagesource = $template->output;
    if ($device eq 'mobile') {
        Encode::from_to($pagesource, 'utf8', 'shiftjis'); # シフトJISに変換
    }
    print "Content-Type: text/html\n\n", $pagesource;
}
