/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.thin.AbstractControlFilter;
import jp.terasoluna.fw.web.thin.AuthenticationController;
import jp.terasoluna.fw.web.thin.UnauthenticatedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationControlFilter
extends AbstractControlFilter<AuthenticationController> {
    public static final String AUTHENTICATION_THRU_KEY = "AUTHENTICATION_THRU_KEY";
    public static final String DEFAULT_AUTHENTICATION_BEAN_ID = "authenticationController";
    private static final String AUTHENTICATION_CONTROLLER_ERROR = "errors.authentication.controller";
    private static final Class AUTHENTICATION_CONTROLLER_CLASS = AuthenticationController.class;
    private static Log log = LogFactory.getLog(AuthenticationControlFilter.class);
    protected static AuthenticationController controller = null;

    public static AuthenticationController getAuthenticationController() {
        return controller;
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        if (controller == null) {
            controller = (AuthenticationController)this.getController();
        }
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(AUTHENTICATION_THRU_KEY) == null) {
            req.setAttribute(AUTHENTICATION_THRU_KEY, (Object)"true");
            if (controller.isCheckRequired(req) && !controller.isAuthenticated(RequestUtil.getPathInfo(req), req)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"isAuthenticated() failed.");
                }
                throw new UnauthenticatedException();
            }
        }
        chain.doFilter(req, res);
    }

    @Override
    protected Class getControllerClass() {
        return AUTHENTICATION_CONTROLLER_CLASS;
    }

    @Override
    protected String getErrorCode() {
        return AUTHENTICATION_CONTROLLER_ERROR;
    }

    @Override
    public String getDefaultControllerBeanId() {
        return DEFAULT_AUTHENTICATION_BEAN_ID;
    }
}

