/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;

/**
 * 񑀍s[eBeBNXB
 *
 * <p>
 *  pESpϊAHTMLꕶGXP[vASQLLIKE
 *  GXP[vA񑀍ɕKvȋ@\񋟂B
 * </p>
 * 
 */
public class StringUtil {

    /**
     * sOSŗpsR[h擾B
     */
    public static final String LINE_SEP
        = System.getProperty("line.separator");

    /**
     * SpXgB
     */
    private static final String ZENKAKU_LIST = 
        "Ihfij{C|D^OPQRS"
        + "TUVWXFGH`abcdefg"
        + "hijklmnopqrstuvwxym"
        + "nOQM"
        + "obpPBuvAE"
        + "@BDFHb[ACGIijklm"
        + "}~JK@";


    /**
     * SpJiXg(JATA^An)sƃEB
     */
    private static final String ZENKAKU_KASATAHA_LIST = 
        "JLNPRTVXZ\^`cegnqtwzE";

    /**
     * SpJiXg(KAUA_Ao)sƃB
     */
    private static final String ZENKAKU_GAZADABA_LIST = 
        "KMOQSUWY[]_adfhorux{";

    /**
     * SpJi("[&yen;30f7])B
     */
    private static final Character ZENKAKU_WA_DAKUTEN = 
        new Character('\u30f7');

    /**
     * SpJi("[&yen;30fa])B
     */
    private static final Character ZENKAKU_WO_DAKUTEN = 
        new Character('\u30fa');

    /**
     * SpJiXg(p)sB
     */
    private static final String ZENKAKU_PA_LIST = "psvy|";

    /**
     * pXgB
     */
    private static final String HANKAKU_LIST = 
        "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGH"
      + "IJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnop"
      + "qrstuvwxyz{|}~"
      + " ";

    /**
     * pJiXg()sƳB
     */
    private static final String HANKAKU_KASATAHA_LIST
        = "γ";

    /**
     * pJiXg()sB
     */
    private static final String HANKAKU_HA_LIST = "";

    /**
     * w肳ꂽpXy[Xǂ𔻕ʂB
     *  StringUtil ̃gn\bhŋʂŗpB
     *
     * @param c Ώە
     * @return zCgXy[XłƂ true
     */
    public static boolean isWhitespace(char c) {
        return c == ' ';
    }

    /**
     * w肳ꂽSp܂͔pXy[Xǂ𔻕ʂB
     *  StringUtil ̃gn\bhŋʂŗpB
     *
     * @param c Ώە
     * @return Sp܂͔pXy[XłƂ true
     */
    public static boolean isZenHankakuSpace(char c) {
        return (c == '@' || c == ' ');
    }

    /**
     * ̉ẼzCgXy[X폜B
     * null ̂Ƃ null ԂB
     *
     * <p>
     * Ⴆ Oracle ̏ꍇA CHAR ^̗̒l
     * ResultSet.getString() Ŏ擾ƁA`܂ŃXy[X
     * pfBOꂽ񂪕ԂBA VARCHAR2 ̏ꍇ
     * E[̃Xy[X̓g~O邽߁Â܂܂ł͗҂𐳂
     * r邱ƂoȂB܂Aʓ͂ꂽ̉E[ɃXy[X
     * ܂܂ĂꍇɁA VARCHAR2 ̗ɑ}
     * Xy[X̂܂܊i[邪AE[̃Xy[Xg~O铮삪
     * ÓȏꍇB̂悤ȂƂɂ̃\bh𗘗pB
     * </p>
     *  SpXy[X̓g~OȂB
     *
     * @param str ϊO̕
     * @return ϊ̕
     */
    public static String rtrim(String str) {
        if (str == null) {
            return null;
        }

        int length = str.length();
        while ((0 < length) && isWhitespace(str.charAt(length - 1))) {
            length--;
        }

        return length < str.length() ? str.substring(0, length) : str;
    }

    /**
     * ̍̃zCgXy[X폜B
     * 
     *  null ̂Ƃ null ԂB<br>
     *  SpXy[X̓g~OȂB
     *
     * @param str ϊO̕
     * @return ϊ̕
     */
    public static String ltrim(String str) {
        if (str == null) {
            return null;
        }

        int start = 0;
        int length = str.length();
        while ((start < length) && isWhitespace(str.charAt(start))) {
            start++;
        }

        return start > 0 ? str.substring(start, length) : str;
    }

    /**
     * ̗̃zCgXy[X폜B
     * 
     *  null ̂Ƃ null ԂB<br>
     *  SpXy[X̓g~OȂB
     *
     * @param str ϊO̕
     * @return ϊ̕
     */
    public static String trim(String str) {
        return StringUtils.trim(str);
    }

    /**
     * ̉ȆSpєpXy[X폜B
     * null ̂Ƃ null ԂB
     *
     * <p>
     * Ⴆ Oracle ̏ꍇA CHAR ^̗̒l
     * ResultSet.getString() Ŏ擾ƁA`܂ŃXy[X
     * pfBOꂽ񂪕ԂBA VARCHAR2 ̏ꍇ
     * E[̃Xy[X̓g~O邽߁Â܂܂ł͗҂𐳂
     * r邱ƂoȂB܂Aʓ͂ꂽ̉E[ɃXy[X
     * ܂܂ĂꍇɁA VARCHAR2 ̗ɑ}
     * Xy[X̂܂܊i[邪AE[̃Xy[Xg~O铮삪
     * ÓȏꍇB̂悤ȂƂɂ̃\bh𗘗pB
     * </p>
     *
     * @param str ϊO̕
     * @return ϊ̕
     */
    public static String rtrimZ(String str) {
        if (str == null) {
            return null;
        }

        int length = str.length();
        while ((0 < length) && isZenHankakuSpace(str.charAt(length - 1))) {
            length--;
        }

        return length < str.length() ? str.substring(0, length) : str;
    }

    /**
     * ̍̑SpєpXy[X폜B
     * 
     *  null ̂Ƃ null ԂB<br>
     *
     * @param str ϊO̕
     * @return ϊ̕
     */
    public static String ltrimZ(String str) {
        if (str == null) {
            return null;
        }

        int start = 0;
        int length = str.length();
        while ((start < length) && isZenHankakuSpace(str.charAt(start))) {
            start++;
        }

        return start > 0 ? str.substring(start, length) : str;
    }

    /**
     * ̗̑SpєpXy[X폜B
     * 
     *  null ̂Ƃ null ԂB<br>
     *
     * @param str ϊO̕
     * @return ϊ̕
     */
    public static String trimZ(String str) {
        return ltrimZ(rtrimZ(str));
    }

    /**
     * w肳ꂽNXZkNXipbP[WCȂj擾B
     *
     * @param longClassName NX
     * @return ZkNX
     */
    public static String toShortClassName(String longClassName) {
        return ClassUtils.getShortClassName(longClassName);
    }

    /**
     * w肳ꂽ񂩂疖̊gq擾B
     * 
     * gqȂꍇ͋󕶎ԂB
     * namenull̏ꍇnullԂB
     *
     * @param name gq̖O
     * @return gq
     */
    public static String getExtension(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf('.');
        return (index < 0) ? "" : name.substring(index);
    }

    /**
     * oCgz16iɕϊB
     *
     * @param byteArray oCgz
     * @param delim f~^
     * @return 16i
     */
    public static String toHexString(byte[] byteArray, String delim) {
        if (delim == null) {
            delim = "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < byteArray.length; i++) {
            if (i > 0) {
                sb.append(delim);
            }
            String hex = Integer.toHexString(byteArray[i] & 0x00ff)
                    .toUpperCase();
            if (hex.length() < 2) {
                sb.append("0");
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    /**
     * w肳ꂽ̓啶ɂB
     *
     * @param str ϊO̕
     * @return ϊ̕
     */
    public static String capitalizeInitial(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    /**
     * CSV`̕𕶎̔zɕϊB
     * 
     * <p>
     * ̐擪J}
     * n܂ĂA̍ŌオJ}ŏIĂꍇɂ́A
     * ꂼϊʂ̔z̍ŏA邢͍Ō̗vf󕶎ƂȂ悤
     * ϊB</p>
     * <p>J}AĂꍇɂ́A󕶎ƂĕϊB</p>
     * <p>csvString  null ꍇɂ́A
     * vf0̔zɕϊB
     *
     * @param csvString CSV`̕
     * @return J}ŕꂽvfɎz
     */
    public static String[] parseCSV(String csvString) {
        if (csvString == null) {
            return new String[0];
        }
        if ("".equals(csvString)) {
            return new String[] { csvString };
        }

        Collection<String> result = new ArrayList<String>();

        char[] chars = csvString.toCharArray();
        int prevCommaIndex = -1;
        for (int i = 0; i < chars.length; i++) {
            if (chars[i] == ',') {
                if (i == prevCommaIndex + 1) {
                    result.add("");
                } else {
                    result.add(new String(chars, prevCommaIndex + 1, i
                            - (prevCommaIndex + 1)));
                }
                if (i == chars.length - 1) {
                    result.add("");
                }
                prevCommaIndex = i;
            } else if (i == chars.length - 1) {
                result.add(new String(chars,
                                    prevCommaIndex + 1,
                                    i - (prevCommaIndex + 1) + 1));
            }
        }

        return result.toArray(new String[0]);
    }

    /**
     * CSV`̕𕶎̔zɕϊB
     * 
     * <p>
     * ̐擪J}
     * n܂ĂA̍ŌオJ}ŏIĂꍇɂ́A
     * ꂼϊʂ̔z̍ŏA邢͍Ō̗vf󕶎ƂȂ悤
     * ϊB</p>
     * <p>J}AĂꍇɂ́A󕶎ƂĕϊB</p>
     * <p>csvString  null ꍇɂ́A
     * vf0̔zɕϊB<br>
     * GXP[vɐݒ肳ꂽ̎ɂJ}͋؂蕶
     * ƂĂ͔FȂB<br>
     * GXP[v̌̃GXP[v̓GXP[vƂ
     * FȂB
     * </p>
     * 
     * @param csvString CSV`̕
     * @param escapeString GXP[v
     * @return J}ŕꂽvfɎz
     */
    public static String[] parseCSV(String csvString, String escapeString) {
        if (csvString == null) {
            return new String[0];
        }
        if ("".equals(csvString)) {
            return new String[] { csvString };
        }

        Collection<String> result = new ArrayList<String>();

        char[] chars = csvString.toCharArray();
        StringBuilder str = new StringBuilder();
        boolean escape = false;
        for (int i = 0; i < chars.length; i++) {
            if (!escape && chars[i] == ',') {
                result.add(str.toString());
                str = new StringBuilder();
                escape = false;
            } else {
                if (escapeString != null
                    && escapeString.indexOf(chars[i]) >= 0) {
                    // GXP[v̌̃GXP[v͒ʏ̕
                    // FB
                    if (escape) {
                        str.append(chars[i]);
                        escape = false;
                    } else {
                        escape = true;
                    }
                } else {
                    escape = false;
                    str.append(chars[i]);
                }
            }
        }
        result.add(str.toString());
        return result.toArray(new String[0]);
    }

    /**
     * ̃}bṽ_v擾B
     * 
     * lIuWFNgɔz񂪊܂܂ĂꍇAevfIuWFNg
     * toString()sAo͂B
     *
     * @param map o̓}bv
     * @return _v
     */
    public static String dump(Map<?, ?> map) {

        if (map == null) {
            return null;
        }

        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEP);
        sb.append("Map{");
        sb.append(LINE_SEP);

        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            // L[IuWFNg
            String appendKey = null;
            if (key == null) {
                appendKey = "null";
            } else {
                appendKey = key.toString();
            }
            sb.append(appendKey);
            sb.append('=');
            Object valueObj = map.get(key);
            if (valueObj == null) {
                sb.append("null");
            } else if (valueObj.getClass().isArray()) {
                // z^ȂΊevf擾
                sb.append(getArraysStr((Object[]) valueObj));
            } else {
                sb.append(valueObj.toString());
            }
            sb.append(LINE_SEP);
        }
        sb.append("}");
        return sb.toString();
    }

    /**
     * _vΏۂ̒lIuWFNgz`̏ꍇA
     * zvfłȂȂ܂ŌJԂl擾B
     *
     * @param arrayObj z^IuWFNg
     * @return z_vΏە
     */
    public static String getArraysStr(Object[] arrayObj) {
        return ArrayUtils.toString(arrayObj, null);
    }

    /**
     * pSpɕϊB
     * 
     * <p>
     * Jiɑ_܂͔_ꍇ́A\ȌPɕϊB<br>
     * () '' + '' =&gt; 'K'</p>
     *
     * <p>܂̕ϊł͈ȉ̑Spϊ敶ƂB</p>
     *
     * <p><ul>
     *  <li>uv</li>
     *  <li>u"v(''ɑ_F&yen;u30f7)</li>
     *  <li>u"v(''ɑ_F&yen;30fa)</li>
     * </ul></p>
     *
     * @param value p
     * @return Sp
     */
    public static String hankakuToZenkaku(String value) {

        if (value == null || "".equals(value)) {
            return value;
        }

        char[] chars = value.toCharArray();
        StringBuilder returnValue = new StringBuilder();
        String getValue = null;
        Character nextvalue = null;

        for (int i = 0; i < chars.length; i++) {

            getValue = getZenkakuMoji(chars[i]);

            if (getValue != null) {
                returnValue.append(getValue);
            } else if (i == (chars.length - 1)) {
                // Ō̕
                getValue = getZenkakuKasatahaMoji(chars[i]);
                if (getValue != null) {
                    // γ
                    returnValue.append(getValue);
                } else if (new Character(chars[i]).equals(
                        new Character(''))) {
                    returnValue.append("");
                } else if (new Character(chars[i]).equals(
                        new Character(''))) {
                    returnValue.append("");
                } else {
                    returnValue.append(String.valueOf(chars[i]));
                }
            } else {
                nextvalue = new Character(chars[i + 1]);
                if (nextvalue.equals(new Character(''))) {
                    getValue = getZenkakuDakuMoji(chars[i]);
                    if (getValue != null) {
                        // ޷޸޹޺޻޼޽޾޿޳
                        returnValue.append(getValue);
                        i++;
                    } else if (new Character(chars[i]).equals(
                            new Character(''))) {
                        // 
                        returnValue.append(ZENKAKU_WA_DAKUTEN);
                        i++;
                    } else if (new Character(chars[i]).equals(
                            new Character(''))) {
                        // 
                        returnValue.append(ZENKAKU_WO_DAKUTEN);
                        i++;
                    } else {
                        returnValue.append((String.valueOf(chars[i]) + "J"));
                        i++;
                    }
                } else if (nextvalue.equals(new Character(''))) {
                    getValue = getZenkakuHandakuMoji(chars[i]);
                    if (getValue != null) {
                        // 
                        returnValue.append(getValue);
                        i++;
                    } else {
                        // ߷߸߹ߺ߻߼߽߾߿߳
                        getValue = getZenkakuKasatahaMoji(chars[i]);
                        returnValue.append((String.valueOf(getValue) + "K"));
                        i++;
                    }
                } else {
                    getValue = getZenkakuKasatahaMoji(chars[i]);
                    if (getValue != null) {
                        // γ
                        returnValue.append(getValue);
                    } else if (new Character(chars[i]).equals(
                            new Character(''))) {
                        returnValue.append("");
                    } else if (new Character(chars[i]).equals(
                            new Character(''))) {
                        returnValue.append("");
                    } else {
                        returnValue.append(String.valueOf(chars[i]));
                    }
                }
            }
        }
        return returnValue.toString();
    }

    /**
     * Sp𔼊pɕϊB
     * 
     * <p>
     * _܂͔_JíAQɕB<br>
     * () 'K' =&gt; '' + ''</p>
     *
     * <p>܂̕ϊł͈ȉ̑SpϊƎ󂯕tB</p>
     *
     * <p><ul>
     *  <li>uv</li>
     *  <li>u"v(''ɑ_F&yen;u30f7)</li>
     *  <li>u"v(''ɑ_F&yen;30fa)</li>
     * </ul></p>
     *
     * @param value Sp
     * @return p
     */
    public static String zenkakuToHankaku(String value) {

        if (value == null || "".equals(value)) {
            return value;
        }

        char[] chars = value.toCharArray();
        StringBuilder returnValue = new StringBuilder();
        String getValue = null;

        for (int i = 0; i < chars.length; i++) {

            getValue = getHankakuMoji(chars[i]);

            if (getValue != null) {
                returnValue.append(getValue);
            } else {
                returnValue.append(String.valueOf(chars[i]));
            }
        }
        return returnValue.toString();
    }

    /**
     * pSpɕϊB
     * 
     * SpXg̕ϊsB
     * 
     * @param c p
     * @return Sp
     */
    private static String getZenkakuMoji(char c) {

        int index = HANKAKU_LIST.indexOf(c);

        if (index >= 0) {
            return String.valueOf(ZENKAKU_LIST.charAt(index));
        }
        return null;
    }

    /**
     * pSpɕϊB
     * 
     * SpJi(KAUA_Ao)sƃ̕ϊsB
     * 
     * @param c p
     * @return Sp
     */
    private static String getZenkakuDakuMoji(char c) {

        int index = HANKAKU_KASATAHA_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(ZENKAKU_GAZADABA_LIST.charAt(index));
        }
        return null;
    }

    /**
     * pSpɕϊB
     * 
     * SpJi(p)s̕ϊsB
     * 
     * @param c p
     * @return Sp
     */
    private static String getZenkakuHandakuMoji(char c) {

        int index = HANKAKU_HA_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(ZENKAKU_PA_LIST.charAt(index));
        }
        return null;
    }

    /**
     * pSpɕϊB
     * 
     * SpJi(JATA^An)sƃE̕ϊsB
     * 
     * @param c p
     * @return Sp
     */
    private static String getZenkakuKasatahaMoji(char c) {

        int index = HANKAKU_KASATAHA_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(ZENKAKU_KASATAHA_LIST.charAt(index));
        }
        return null;
    }

    /**
     * Sp𔼊pɕϊB
     * 
     * ̃\bhł͈ȉ̕ΏۂƂϊsB<br>
     *
     * <p><ul>
     *  <li>pXg</li>
     *  <li>pJi()sƳ</li>
     *  <li>pJi(ޤޤޤ)sƳ</li>
     *  <li>pJi()s</li>
     *  <li>pJi(ޤ)</li>
     * </ul></p>
     * 
     * @param c Sp
     * @return p
     */
    private static String getHankakuMoji(char c) {

        int index = 0;
        String value = null;

        index = ZENKAKU_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(HANKAKU_LIST.charAt(index));
        }

        index = ZENKAKU_KASATAHA_LIST.indexOf(c);
        if (index >= 0) {
            // JLNPRTVXZ\^`cegnqtwzE
            return String.valueOf(HANKAKU_KASATAHA_LIST.charAt(index));
        }

        index = ZENKAKU_GAZADABA_LIST.indexOf(c);
        if (index >= 0) {
            // KMOQSUWY[]"_adfhorux{
            value = String.valueOf(HANKAKU_KASATAHA_LIST.charAt(index));
            return value + "";
        }

        index = ZENKAKU_PA_LIST.indexOf(c);
        if (index >= 0) {
            // psvy|
            value = String.valueOf(HANKAKU_HA_LIST.charAt(index));
            return value + "";
        } else if ((new Character(c)).equals(new Character(''))) {
            // 
            return "";
        } else if ((new Character(c)).equals(new Character(''))) {
            // 
            return "";
        } else if ((new Character(c)).equals(ZENKAKU_WA_DAKUTEN)) {
            // "[\u30f7]
            return "";
        } else if ((new Character(c)).equals(ZENKAKU_WO_DAKUTEN)) {
            // "[\u30fa]
            return "";
        } else {
            // YȂ
            return null;
        }
    }

    /**
     * HTML^ϊB
     * 
     * <p>
     *  "&lt;"A"&gt;"A"&amp;"A"&quot;"ƂAHTML
     *  ̂܂܏o͂Ɩ肪镶
     *  "&amp;lt;"A"&amp;gt;"A"&amp;amp;"A"&amp;quot;"
     *  ɕϊB
     * </p>
     * <p>
     * nullnꂽꍇnullԂB
     * </p
     *
     * @param str ϊ镶
     * @return ϊ̕
     */
    public static String filter(String str) {
        if (str == null) {
            return null;
        }
        char[] cbuf = str.toCharArray();
        StringBuilder sbui = new StringBuilder();
        for (int i = 0; i < cbuf.length; i++) {
            if (cbuf[i] == '&') {
                sbui.append("&amp;");
            } else if (cbuf[i] == '<') {
                sbui.append("&lt;");
            } else if (cbuf[i] == '>') {
                sbui.append("&gt;");
            } else if (cbuf[i] == '"') {
                sbui.append("&quot;");
            } else {
                sbui.append(cbuf[i]);
            }
        }
        return sbui.toString();
    }

    /**
     * LIKEq̃p^[ŗpGXP[vB
     */
    public static final String LIKE_ESC_CHAR = "~";

    /**
     * <p>LIKEq̃p^[ɕϊB</p>
     *
     * <p>ϊ[͈ȉ̒ʂB</p>
     *
     * <ol>
     *   <li><code>LIKE_ESC_CHAR</code>  <code>LIKE_ESC_CHAR</code> 
     *       GXP[vB</li>
     *   <li>'%''_' <code>LIKE_ESC_CHAR</code> ŃGXP[vB</li>
     *   <li>'%'ǉB</li>
     * </ol>
     *
     * <p>conditionnull̏ꍇnullԂB</p>
     *
     * @param condition 
     * @return ϊ̌
     */
    public static String toLikeCondition(String condition) {
        if (condition == null) {
            return null;
        }
        final char esc = (LIKE_ESC_CHAR.toCharArray())[0];
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < condition.length(); i++) {
            char c = condition.charAt(i);
            if (c == esc) {
                result.append(esc);
                result.append(esc);
            } else if (c == '%' || c == '_') {
                result.append(esc);
                result.append(c);
            } else {
                result.append(c);
            }
        }
        result.append('%');
        return result.toString();
    }

    /**
     * w肳ꂽ̃oCg񒷂擾B
     * ̃GR[fBOŃoCgɕϊ邪A
     * GR[hw肳ĂȂꍇ̓ftHg̃GR[fBO
     * oCgɕϊsB
     *
     * @param value oCg񒷂擾Ώۂ̕
     * @param encoding GR[fBO
     * @return oCg
     * @throws UnsupportedEncodingException T|[gĂȂ
     * GR[fBOw肵ƂOB
     */
    public static int getByteLength(String value, String encoding)
            throws UnsupportedEncodingException {
        if (value == null || "".equals(value)) {
            return 0;
        }

        byte[] bytes = null;
        if (encoding == null || "".equals(encoding)) {
            bytes = value.getBytes();
        } else {
            try {
                bytes = value.getBytes(encoding);
            } catch (UnsupportedEncodingException e) {
                throw e;
            }
        }
        return bytes == null ? 0 : bytes.length;
    }
}
