/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MethodDelegateTypeMunger;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.NewMethodTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;

public abstract class ResolvedTypeMunger {
    protected Kind kind;
    protected ResolvedMember signature;
    protected ResolvedMember declaredSignature;
    protected List typeVariableAliases;
    private Set superMethodsCalled = Collections.EMPTY_SET;
    private ISourceLocation location;
    public static final Kind Field = new Kind("Field", 1);
    public static final Kind Method = new Kind("Method", 2);
    public static final Kind Constructor = new Kind("Constructor", 5);
    public static final Kind PerObjectInterface = new Kind("PerObjectInterface", 3);
    public static final Kind PrivilegedAccess = new Kind("PrivilegedAccess", 4);
    public static final Kind Parent = new Kind("Parent", 6);
    public static final Kind PerTypeWithinInterface = new Kind("PerTypeWithinInterface", 7);
    public static final Kind AnnotationOnType = new Kind("AnnotationOnType", 8);
    public static final Kind MethodDelegate = new Kind("MethodDelegate", 9);
    public static final Kind FieldHost = new Kind("FieldHost", 10);
    public static final String SUPER_DISPATCH_NAME = "superDispatch";

    public ResolvedTypeMunger(Kind kind, ResolvedMember signature) {
        UnresolvedType declaringType;
        this.kind = kind;
        this.signature = signature;
        UnresolvedType unresolvedType = declaringType = signature != null ? signature.getDeclaringType() : null;
        if (declaringType != null) {
            if (declaringType.isRawType()) {
                throw new IllegalStateException("Use generic type, not raw type");
            }
            if (declaringType.isParameterizedType()) {
                throw new IllegalStateException("Use generic type, not parameterized type");
            }
        }
    }

    public void setSourceLocation(ISourceLocation isl) {
        this.location = isl;
    }

    public ISourceLocation getSourceLocation() {
        return this.location;
    }

    public ConcreteTypeMunger concretize(World world, ResolvedType aspectType) {
        ConcreteTypeMunger munger = world.concreteTypeMunger(this, aspectType);
        return munger;
    }

    public boolean matches(ResolvedType matchType, ResolvedType aspectType) {
        ResolvedType onType = matchType.getWorld().resolve(this.signature.getDeclaringType());
        if (onType.isRawType()) {
            onType = onType.getGenericType();
        }
        if (matchType.equals(onType)) {
            if (!onType.isExposedToWeaver()) {
                boolean ok;
                boolean bl = ok = onType.isInterface() && onType.lookupMemberWithSupersAndITDs(this.getSignature()) != null;
                if (!ok && onType.getWeaverState() == null && matchType.getWorld().getLint().typeNotExposedToWeaver.isEnabled()) {
                    matchType.getWorld().getLint().typeNotExposedToWeaver.signal(matchType.getName(), this.signature.getSourceLocation());
                }
            }
            return true;
        }
        if (onType.isInterface()) {
            return matchType.isTopmostImplementor(onType);
        }
        return false;
    }

    public String toString() {
        return "ResolvedTypeMunger(" + this.getKind() + ", " + this.getSignature() + ")";
    }

    public static ResolvedTypeMunger read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        Kind kind = Kind.read(s);
        if (kind == Field) {
            return NewFieldTypeMunger.readField(s, context);
        }
        if (kind == Method) {
            return NewMethodTypeMunger.readMethod(s, context);
        }
        if (kind == Constructor) {
            return NewConstructorTypeMunger.readConstructor(s, context);
        }
        if (kind == MethodDelegate) {
            return MethodDelegateTypeMunger.readMethod(s, context);
        }
        if (kind == FieldHost) {
            return MethodDelegateTypeMunger.FieldHostTypeMunger.readFieldHost(s, context);
        }
        throw new RuntimeException("unimplemented");
    }

    protected static Set readSuperMethodsCalled(VersionedDataInputStream s) throws IOException {
        HashSet<ResolvedMemberImpl> ret = new HashSet<ResolvedMemberImpl>();
        int n = s.readInt();
        if (n < 0) {
            throw new BCException("Problem deserializing type munger");
        }
        for (int i = 0; i < n; ++i) {
            ret.add(ResolvedMemberImpl.readResolvedMember(s, null));
        }
        return ret;
    }

    protected void writeSuperMethodsCalled(DataOutputStream s) throws IOException {
        if (this.superMethodsCalled == null || this.superMethodsCalled.size() == 0) {
            s.writeInt(0);
            return;
        }
        ArrayList ret = new ArrayList(this.superMethodsCalled);
        Collections.sort(ret);
        int n = ret.size();
        s.writeInt(n);
        Iterator i = ret.iterator();
        while (i.hasNext()) {
            ResolvedMember m = (ResolvedMember)i.next();
            m.write(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ISourceLocation readSourceLocation(VersionedDataInputStream s) throws IOException {
        if (s.getMajorVersion() < AjAttribute.WeaverVersionInfo.WEAVER_VERSION_MAJOR_AJ150) {
            return null;
        }
        SourceLocation ret = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(s);
            Boolean validLocation = (Boolean)ois.readObject();
            if (validLocation.booleanValue()) {
                File f = (File)ois.readObject();
                Integer ii = (Integer)ois.readObject();
                Integer offset = (Integer)ois.readObject();
                ret = new SourceLocation(f, ii);
                ret.setOffset(offset);
            }
        }
        catch (EOFException eof) {
            ISourceLocation iSourceLocation = null;
            return iSourceLocation;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            ISourceLocation iSourceLocation = null;
            return iSourceLocation;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
        return ret;
    }

    protected void writeSourceLocation(DataOutputStream s) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(s);
        oos.writeObject(new Boolean(this.location != null));
        if (this.location != null) {
            oos.writeObject(this.location.getSourceFile());
            oos.writeObject(new Integer(this.location.getLine()));
            oos.writeObject(new Integer(this.location.getOffset()));
        }
        oos.flush();
        oos.close();
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public Kind getKind() {
        return this.kind;
    }

    public void setSuperMethodsCalled(Set c) {
        this.superMethodsCalled = c;
    }

    public Set getSuperMethodsCalled() {
        return this.superMethodsCalled;
    }

    public ResolvedMember getSignature() {
        return this.signature;
    }

    public ResolvedMember getMatchingSyntheticMember(Member member, ResolvedType aspectType) {
        if (this.getSignature() != null && this.getSignature().isPublic() && member.equals(this.getSignature())) {
            return this.getSignature();
        }
        return null;
    }

    public boolean changesPublicSignature() {
        return this.kind == Field || this.kind == Method || this.kind == Constructor;
    }

    public boolean needsAccessToTopmostImplementor() {
        if (this.kind == Field) {
            return true;
        }
        if (this.kind == Method) {
            return !this.signature.isAbstract();
        }
        return false;
    }

    protected static List readInTypeAliases(VersionedDataInputStream s) throws IOException {
        int count;
        if (s.getMajorVersion() >= AjAttribute.WeaverVersionInfo.WEAVER_VERSION_MAJOR_AJ150 && (count = s.readInt()) != 0) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                aliases.add(s.readUTF());
            }
            return aliases;
        }
        return null;
    }

    protected void writeOutTypeAliases(DataOutputStream s) throws IOException {
        if (this.typeVariableAliases == null || this.typeVariableAliases.size() == 0) {
            s.writeInt(0);
        } else {
            s.writeInt(this.typeVariableAliases.size());
            Iterator iter = this.typeVariableAliases.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                s.writeUTF(element);
            }
        }
    }

    public List getTypeVariableAliases() {
        return this.typeVariableAliases;
    }

    public boolean hasTypeVariableAliases() {
        return this.typeVariableAliases != null && this.typeVariableAliases.size() > 0;
    }

    public boolean sharesTypeVariablesWithGenericType() {
        return this.typeVariableAliases != null && this.typeVariableAliases.size() > 0;
    }

    public ResolvedTypeMunger parameterizedFor(ResolvedType target) {
        throw new BCException("Dont call parameterizedFor on a type munger of this kind: " + this.getClass());
    }

    public void setDeclaredSignature(ResolvedMember rm) {
        this.declaredSignature = rm;
    }

    public ResolvedMember getDeclaredSignature() {
        return this.declaredSignature;
    }

    public boolean isLateMunger() {
        return false;
    }

    public boolean existsToSupportShadowMunging() {
        return false;
    }

    public static class Kind
    extends TypeSafeEnum {
        Kind(String name, int key) {
            super(name, key);
        }

        public static Kind read(DataInputStream s) throws IOException {
            byte key = s.readByte();
            switch (key) {
                case 1: {
                    return Field;
                }
                case 2: {
                    return Method;
                }
                case 5: {
                    return Constructor;
                }
                case 9: {
                    return MethodDelegate;
                }
                case 10: {
                    return FieldHost;
                }
            }
            throw new BCException("bad kind: " + key);
        }

        public String toString() {
            if (MethodDelegate.getName().equals(this.getName())) {
                return Method.toString();
            }
            return super.toString();
        }
    }
}

