/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.common;

import java.util.Date;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;

/**
 * c̃p[^NXB
 */
@FileFormat(overWriteFlg=true)
public class ZandakaData {

    /**
     * ڋqR[h
     */
    @InputFileColumn(columnIndex = 0)
    @OutputFileColumn(columnIndex = 0)
    private String kokyakucd;
    
    /**
     * c
     */
    @InputFileColumn(columnIndex = 1)
    @OutputFileColumn(columnIndex = 1)
    private int zandaka;

    /**
     * ŏI
     */
    private Date saisyutorihikibi;
    
    /**
     * ڋqR[hԋpB
     * @return ڋqR[h
     */
    public String getKokyakucd() {
        return kokyakucd;
    }
    
    /**
     * ڋqR[hݒ肷B
     * @param kokyakucd ݒ肷ڋqR[h
     */
    public void setKokyakucd(String kokyakucd) {
        this.kokyakucd = kokyakucd;
    }
    
    /**
     * cԋpB
     * @return c
     */
    public int getZandaka() {
        return zandaka;
    }
    
    /**
     * cݒ肷B
     * @param zandaka ݒ肷c
     */
    public void setZandaka(int zandaka) {
        this.zandaka = zandaka;
    }

    /**
     * ŏIԋpB
     * @return ŏI
     */
    public Date getSaisyutorihikibi() {
        return saisyutorihikibi;
    }

    /**
     * ŏIݒ肷B
     * @param saisyutorihikibi ݒ肷ŏI
     */
    public void setSaisyutorihikibi(Date saisyutorihikibi) {
        this.saisyutorihikibi = saisyutorihikibi;
    }
    
}
