/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.init;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.batch.core.InitializeException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Wu˗̊i[NXB
 * 
 */
public class JobRequestInfo implements JobInfo {

    /**
     * Serializablepo[WID
     */
    private static final long serialVersionUID = 3134293738030810122L;

    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(JobRequestInfo.class);

    /**
     * vZXID̎ʎqB
     */
    private static final String PROCESS_ID_SPLIT = "-P";

    /**
     * WuIDB
     */
    private String jobId = null;

    /**
     * WuBean`t@C̑΃pXB
     */
    private String jobDiscriptorPath = null;

    /**
     * Wup[^i[lB
     */
    private String[] jobParameters = null;

    /**
     * WuvZXIDB
     */
    private String jobRequestNo = "";

    /**
     * NB
     */
    private String[] inParameters = null;

    /**
     * Wu˗̊i[NX̐ݒsRXgN^B
     * 
     * @param inParameters
     *            N̈
     */
    public JobRequestInfo(String[] inParameters) {
        this.inParameters = inParameters;
    }

    /**
     * Wu˗̏p\bhBRXgN^
     * <code>String</code>zK؂
     * lɐݒ肷B
     * 
     */
    public void init() {
        if (inParameters == null || inParameters.length < 2) {
            throw new InitializeException(
                   "There is not a required argument at the time of job start");
        }
        setJobId(inParameters[0]);
        setJobDiscriptorPath(inParameters[1]);
        setJobParameters(inParameters);
        if (log.isDebugEnabled()) {
            log.debug("Parameter valuesF " + toString());
        }
    }

    /**
     * Wup[^͒lԂB
     * 
     * @return Wup[^͒l
     */
    public String[] getJobParameters() {
        return jobParameters;
    }

    /**
     * Wu`t@C̑΃pXԂB
     * 
     * @return Wu`t@C̑΃pX
     */
    public String getJobDiscriptorPath() {
        return jobDiscriptorPath;
    }

    /**
     * WuIDԂB
     * 
     * @return WuID
     */
    public String getJobId() {
        return jobId;
    }

    /**
     * WuvZXIDԂB
     * 
     * @return WuvZXID
     */
    public String getJobRequestNo() {
        return jobRequestNo;
    }

    /**
     * WuReLXgi[pp[^ݒB<BR>
     * WuvZXIDݒB
     * 
     * @param inParameters
     *            N̈
     */
    private void setJobParameters(String[] inParameters) {
        List<String> tempArray = new ArrayList<String>();
        
        for (int index = 2; index < inParameters.length ; index++) {
            
            String tempStr = inParameters[index];
            
            if (tempStr != null
                  && PROCESS_ID_SPLIT.equalsIgnoreCase(tempStr)) {
                // WuvZXIDݒ
                if (index < inParameters.length - 1) {
                    this.jobRequestNo = inParameters[++index];
                }
            } else {
                tempArray.add(tempStr);
            }
        }

        jobParameters = 
            (String[]) tempArray.toArray(new String[tempArray.size()]);
    }
    
    /**
     * WuBeanݒt@C̑΃pX̐ݒB
     * 
     * @param jobDiscriptorPath
     *            N̑Q
     */
    private void setJobDiscriptorPath(String jobDiscriptorPath) {
        if (jobDiscriptorPath == null) {
            throw new InitializeException(
                    "A job Bean definition file is null");
        }
        this.jobDiscriptorPath = jobDiscriptorPath;
    }

    /**
     * WuID̐ݒB
     * 
     * @param jobId
     *            N̑P
     */
    private void setJobId(String jobId) {
        if (jobId == null) {
            throw new InitializeException("jobID is null");
        }
        this.jobId = jobId;
    }

    /**
     * ̐ݒl𕶎쐬B
     * 
     * @return ݒl̕
     */
    public String toString() {
        StringBuilder returnStr = new StringBuilder();
        returnStr.append("[jobId=");
        returnStr.append(jobId);
        returnStr.append("] [jobDiscriptPath=");
        returnStr.append(jobDiscriptorPath);
        returnStr.append("] [parameters=[");
        for (int i = 0; i < jobParameters.length; i++) {
            returnStr.append(jobParameters[i]);
            if (i != jobParameters.length - 1) {
                returnStr.append(", ");
            }
        }
        returnStr.append("]] [jobRequestNo=");
        returnStr.append(jobRequestNo);
        returnStr.append("]");

        return returnStr.toString();
    }

}
