/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.core;

import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * RN^[ۃNXB
 *
 * <p>
 * Ώۃf[^擾JnB<br>
 * Ώۃf[^擾͂<code>Abstract</code>
 * NXNXɂčsB
 * </p>
 * 
 * @see jp.terasoluna.fw.batch.ibatissupport.IBatisDbCollectorImpl
 * @see jp.terasoluna.fw.batch.init.JobRequestInfoCollector
 * @see jp.terasoluna.fw.batch.standard.ListPropertyCollector
 * @see jp.terasoluna.fw.batch.standard.StringArrayPropertyCollector
 * @param <T> WuReNXg̃TuNX
 */
public abstract class AbstractCollector<T extends JobContext> 
    implements Collector<T> {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(AbstractCollector.class);

    /**
     * Ώۃf[^nhB
     */
    private CollectedDataHandlerFactory collectedDataHandlerFactory = null;
    
    /**
     * Ώۃf[^擾JnB
     *
     * @param jobContext WuReNXg
     * @param workQueue [NL[
     * @param jobStatus WuXe[^X
     * @return RN^̏
     */
    public CollectorResult collect(T jobContext, WorkQueue workQueue,
            JobStatus jobStatus) {
        //JnO
        writeStartLog(jobStatus);
        CollectedDataHandler collectedDataHandler
            = collectedDataHandlerFactory.getHandler(workQueue, jobContext);
        CollectorResult collectorResult = null;
        try {
            collectorResult = doCollect(jobContext, collectedDataHandler,
                    jobStatus);
            // END_MARKput̂͐Ił
            collectedDataHandler.close();
        } catch (QueueingException e) {
            // WuN/ċN󋵂łꍇQueueingExceptiońA
            // L[ւ̗vfǉ̍ۂɁAXbhC^vgꂽꍇ
            // łB
            if (jobStatus.isExecuting()) {
                throw e;
            } else {
                // [JŃWuXe[^XXVꂽƂɂ
                // QueueingExceptionLb`ꍇ́A
                // RN^𐳏IB
                collectorResult =
                    new CollectorResult(ReturnCode.NORMAL_END, -1);
            }
        }

        writeEndLog(jobStatus);
        return collectorResult;
    }

    /**
     * Wf[^nhݒ肷B
     * 
     * @param collectedDataHandlerFactory Wf[^nh
     */
    public void setCollectedDataHandlerFactory(
            CollectedDataHandlerFactory collectedDataHandlerFactory) {
        this.collectedDataHandlerFactory = collectedDataHandlerFactory;
    }

    /**
     * Ώۃf[^擾B
     *
     * @param jobContext WuReNXg
     * @param collectedDataHandler Wf[^nh
     * @param jobStatus WuXe[^X
     * @return RN^̏
     */
    protected abstract CollectorResult doCollect(T jobContext,
            CollectedDataHandler collectedDataHandler, JobStatus jobStatus);

    /**
     * AbstractCollector̊JnOo͂B
     * 
     * @param jobStatus WuXe[^X
     */
    private void writeStartLog(JobStatus jobStatus) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Collector processing START: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [ClassName=");
            logStr.append(this.getClass().getSimpleName());
            logStr.append("] [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("]");
            log.info(logStr.toString());
        }
    }

    /**
     * AbstractCollectoȑIOo͂B
     * 
     * @param jobStatus WuXe[^X
     */
    private void writeEndLog(JobStatus jobStatus) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Collector processing END: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [ClassName=");
            logStr.append(this.getClass().getSimpleName());
            logStr.append("] [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("] [collected=");
            logStr.append(jobStatus.getCollected());
            logStr.append("]");
            log.info(logStr.toString());
        }
    }
}
