/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineIterator;
import jp.terasoluna.fw.file.dao.standard.ColumnParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedFileLineIterator<T>
extends AbstractFileLineIterator<T> {
    private static final char DELIMITER = ',';
    private static final char ENCLOSE_CHAR = '\u0000';
    private int totalDefineBytes = 0;

    public FixedFileLineIterator(String fileName, Class<T> clazz, Map<String, ColumnParser> columnParserMap) {
        super(fileName, clazz, columnParserMap);
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat.delimiter() != ',') {
            throw new FileException("Delimiter can not change.", new IllegalStateException(), fileName);
        }
        if (fileFormat.encloseChar() != '\u0000') {
            throw new FileException("EncloseChar can not change.", new IllegalStateException(), fileName);
        }
        super.init();
        for (Field field : this.getFields()) {
            this.totalDefineBytes += field.getAnnotation(InputFileColumn.class).bytes();
        }
    }

    @Override
    protected String[] separateColumns(String fileLineString) {
        if (fileLineString == null || "".equals(fileLineString)) {
            return new String[0];
        }
        Field[] fields = this.getFields();
        String[] results = new String[fields.length];
        try {
            byte[] bytes = fileLineString.getBytes(this.getFileEncoding());
            if (this.totalDefineBytes != bytes.length) {
                throw new FileException("Total Columns byte is different from Total FileLineObject's columns byte.", new IllegalStateException(), this.getFileName());
            }
            int byteIndex = 0;
            int columnBytes = 0;
            for (int i = 0; i < fields.length; ++i) {
                columnBytes = fields[i].getAnnotation(InputFileColumn.class).bytes();
                results[i] = new String(bytes, byteIndex, columnBytes, this.getFileEncoding());
                byteIndex += columnBytes;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new FileException("fileEncoding which isn't supported was set.", e, this.getFileName());
        }
        return results;
    }

    @Override
    protected boolean isCheckByte(InputFileColumn inputFileColumn) {
        return false;
    }

    @Override
    protected boolean isCheckByte(int columnByte) {
        return false;
    }

    @Override
    public char getDelimiter() {
        return ',';
    }

    @Override
    public char getEncloseChar() {
        return '\u0000';
    }
}

