/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.terasoluna.fw.batch.core.BatchUpdateProcessor;
import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.fw.dao.UpdateDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardBatchUpdateProcessor
implements BatchUpdateProcessor {
    private UpdateDAO updateDAO = null;

    @Override
    public void processBatchUpdate(List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (batchUpdateMapList.size() == 0) {
            return;
        }
        int headSize = batchUpdateMapList.get(0).size();
        ArrayList<SqlHolder> sqlHolderList = new ArrayList<SqlHolder>(headSize * batchUpdateMapList.size());
        for (LinkedHashMap<String, Object> sqlMap : batchUpdateMapList) {
            Set<Map.Entry<String, Object>> entries = sqlMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                SqlHolder sqlHolder = this.createSqlHolder(entry.getKey(), entry.getValue());
                sqlHolderList.add(sqlHolder);
            }
        }
        if (sqlHolderList.size() > 0) {
            Collections.sort(sqlHolderList, new SqlHolderListComparator());
            this.updateDAO.executeBatch(sqlHolderList);
        }
    }

    private SqlHolder createSqlHolder(String sqlId, Object bindParams) {
        SqlHolder sqlHolder = new SqlHolder(sqlId, bindParams);
        return sqlHolder;
    }

    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SqlHolderListComparator
    implements Comparator<SqlHolder> {
        private SqlHolderListComparator() {
        }

        @Override
        public int compare(SqlHolder obj1, SqlHolder obj2) {
            return obj1.getSqlID().compareTo(obj2.getSqlID());
        }
    }
}

