/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample004;

import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.batch.functionsample.common.CodeData;
import jp.terasoluna.batch.functionsample.common.NyusyukkinData;

/**
 * uR[hvƁuoR[hv𖼏̂ɕϊB
 *  <p>ϊp̃R[he[u̓LbVB<br>
 *  LbV̐ݒSqlMapConfigt@CSqlMapt@CQƂ̂ƁB</p>
 *
 */
public class Sample004BLogic implements BLogic<NyusyukkinData, JobContext> {

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO;
    
    /**
     * t@Co͗psC^NXB
     * SpringɂCX^Xݒ肳B
     */
    private FileLineWriter<Sample004NyusyukkinData> fileLineWriter = null;

    public BLogicResult execute(NyusyukkinData nyusyukkin, JobContext arg1) {
        	
    CodeData codeData = new CodeData();
        	  
    codeData.setCode("torihikicd");
        codeData.setKey(String.valueOf(nyusyukkin.getTorihikicd()));
        String torihikikbn = queryDAO.executeForObject("SAMPLE004.getCodeDataByCodeKey", codeData, String.class);
        
        codeData.setCode("nyusyukkincd");
        codeData.setKey(String.valueOf(nyusyukkin.getNyusyukkincd()));
        String nyusyukkinkbn = queryDAO.executeForObject("SAMPLE004.getCodeDataByCodeKey", codeData, String.class);
        
        Sample004NyusyukkinData outputData = new Sample004NyusyukkinData();
        
        outputData.setId(nyusyukkin.getId());
        outputData.setKokyakucd(nyusyukkin.getKokyakucd());
        outputData.setNyusyukkinkbn(nyusyukkinkbn);
        outputData.setTorihikikbn(torihikikbn);
        outputData.setKingaku(nyusyukkin.getKingaku());
        outputData.setTorihikibi(nyusyukkin.getTorihikibi());
        
        fileLineWriter.printDataLine(outputData);
    
    return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }
    
    /**
     * QueryDAOݒ肷B
     * @param queryDAO ݒ肷QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * t@Co͗psC^NXݒ肷B
     * @param fileLineWriter t@Co͗psC^NX
     */
    public void setFileLineWriter(FileLineWriter<Sample004NyusyukkinData> fileLineWriter){
    this.fileLineWriter = fileLineWriter;
    }
}
